/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.ui.actions;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mdht.uml.cda.core.util.CDAProfileUtil;
import org.eclipse.mdht.uml.cda.ui.internal.Logger;
import org.eclipse.mdht.uml.common.ui.dialogs.DialogLaunchUtil;
import org.eclipse.mdht.uml.common.ui.dialogs.SubclassHandler;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;

public class CreateNewTemplateAction
implements IObjectActionDelegate {
    protected IWorkbenchPart activePart;
    protected ISelection currentSelection;
    protected Package selectedPackage;

    protected View getSelectedView() {
        Object[] objectArray = ((IStructuredSelection)this.currentSelection).toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            View view = (View)((IAdaptable)element).getAdapter(View.class);
            if (view != null) {
                return view;
            }
            ++n2;
        }
        return null;
    }

    public void run(IAction action) {
        try {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.selectedPackage);
            AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, "Create New Template"){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                    String className = null;
                    InputDialog inputDialog = new InputDialog(CreateNewTemplateAction.this.activePart.getSite().getShell(), "New Template", "Enter template name", "", null);
                    if (inputDialog.open() == 0) {
                        className = inputDialog.getValue();
                    }
                    if (className == null || className.length() == 0) {
                        return Status.CANCEL_STATUS;
                    }
                    Class newClass = null;
                    Class baseClass = (Class)DialogLaunchUtil.chooseElement((java.lang.Class[])new java.lang.Class[]{Class.class}, (ResourceSet)CreateNewTemplateAction.this.selectedPackage.eResource().getResourceSet(), (Shell)CreateNewTemplateAction.this.activePart.getSite().getShell(), (String)"Class Selection", (String)"Select base class:");
                    if (baseClass == null) {
                        return Status.CANCEL_STATUS;
                    }
                    newClass = CreateNewTemplateAction.this.selectedPackage.createOwnedClass(className, false);
                    newClass.createGeneralization((Classifier)baseClass);
                    SubclassHandler subclassHandler = new SubclassHandler(CreateNewTemplateAction.this.activePart.getSite().getShell(), newClass);
                    int resultStatus = subclassHandler.openSubclassDialog();
                    if (resultStatus != 0) {
                        newClass.destroy();
                        return Status.CANCEL_STATUS;
                    }
                    if (CreateNewTemplateAction.this.activePart instanceof ISetSelectionTarget) {
                        ((ISetSelectionTarget)CreateNewTemplateAction.this.activePart).selectReveal((ISelection)new StructuredSelection((Object)newClass));
                    }
                    return Status.OK_STATUS;
                }
            };
            try {
                IWorkspaceCommandStack commandStack = (IWorkspaceCommandStack)editingDomain.getCommandStack();
                operation.addContext(commandStack.getDefaultUndoContext());
                commandStack.getOperationHistory().execute((IUndoableOperation)operation, (IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException ee) {
                Logger.logException(ee);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.currentSelection = selection;
        this.selectedPackage = null;
        if (((IStructuredSelection)selection).size() == 1) {
            Object selected = ((IStructuredSelection)selection).getFirstElement();
            if (selected instanceof IAdaptable) {
                selected = ((IAdaptable)selected).getAdapter(EObject.class);
            }
            if (selected instanceof View) {
                selected = ((View)selected).getElement();
            }
            if (selected instanceof Package) {
                this.selectedPackage = (Package)selected;
            }
        }
        if (this.selectedPackage != null && CDAProfileUtil.getAppliedCDAProfile((Element)this.selectedPackage) != null) {
            action.setEnabled(true);
        } else {
            action.setEnabled(false);
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.activePart = targetPart;
    }
}

