/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.ui.util;

import org.eclipse.mdht.uml.cda.core.util.CDAProfileUtil;
import org.eclipse.mdht.uml.common.notation.ClassNotationUtil;
import org.eclipse.mdht.uml.common.util.NamedElementUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Stereotype;

public class CDAClassNotation
extends ClassNotationUtil {
    public static String getCustomLabel(Class clazz, int style) {
        String hl7Metadata;
        boolean multiLine;
        String modifiers;
        boolean showBrackets;
        StringBuffer buffer = new StringBuffer();
        if ((style & 2) != 0) {
            buffer.append(NamedElementUtil.getVisibilityAsSign((NamedElement)clazz));
        }
        if ((style & 8) != 0) {
            buffer.append(" ");
            buffer.append(clazz.getName());
        }
        boolean bl = showBrackets = buffer.length() > 0;
        if ((style & 0x80) != 0 && !(modifiers = CDAClassNotation.getModifiersAsString((Class)clazz, (boolean)(multiLine = (style & 0x100000) != 0))).equals("")) {
            if (multiLine) {
                buffer.append("\n");
            }
            buffer.append(showBrackets ? " {" : "");
            buffer.append(modifiers);
            buffer.append(showBrackets ? "}" : "");
        }
        if ((hl7Metadata = CDAClassNotation.getHL7Metadata(clazz, style)).length() > 0) {
            buffer.append(showBrackets ? " {" : "");
            buffer.append(hl7Metadata);
            buffer.append(showBrackets ? "}" : "");
        }
        return buffer.toString();
    }

    private static String getHL7Metadata(Class clazz, int style) {
        String templateId;
        StringBuffer buffer = new StringBuffer();
        if ((style & 0x2000) != 0 && (templateId = CDAClassNotation.getTemplateId(clazz)) != null && templateId.length() > 0) {
            if (buffer.length() > 0) {
                buffer.append(" ");
            }
            buffer.append(templateId);
        }
        return buffer.toString();
    }

    private static String getTemplateId(Class clazz) {
        StringBuffer value = new StringBuffer();
        Stereotype cdaTemplate = CDAProfileUtil.getAppliedCDAStereotype((Element)clazz, (String)"CDATemplate");
        try {
            String templateId;
            if (cdaTemplate != null && (templateId = (String)clazz.getValue(cdaTemplate, "templateId")) != null) {
                value.append(templateId);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return value.toString();
    }
}

