/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.ui.util;

import org.eclipse.mdht.uml.term.ui.notation.TermPropertyNotation;
import org.eclipse.uml2.uml.Property;

public class CDAPropertyNotation
extends TermPropertyNotation {
    public static String getCustomLabel(Property property, int style) {
        String termMetadata;
        String modifiers;
        StringBuffer buffer = new StringBuffer();
        boolean multiLine = (style & 0x100000) != 0;
        StringBuffer annotations = new StringBuffer();
        if ((style & 0x80) != 0 && !(modifiers = CDAPropertyNotation.getModifiersAsString(property, multiLine)).equals("")) {
            annotations.append(modifiers);
        }
        if ((termMetadata = CDAPropertyNotation.getTerminologyAnnotations((Property)property, (int)style)).length() > 0) {
            if (annotations.length() > 0) {
                annotations.append(", ");
            }
            annotations.append(termMetadata);
        }
        if (annotations.length() > 0) {
            if (multiLine) {
                buffer.append("\n");
            }
            boolean showBrackets = buffer.length() > 0;
            buffer.append(showBrackets ? " {" : "");
            buffer.append(annotations);
            buffer.append(showBrackets ? "}" : "");
        }
        return buffer.toString().trim();
    }

    protected static String getModifiersAsString(Property property, boolean multiLine) {
        String NL;
        StringBuffer buffer = new StringBuffer();
        boolean needsComma = false;
        String string = NL = multiLine ? "\n" : "";
        if (property.isReadOnly()) {
            buffer.append("readOnly");
            needsComma = true;
        }
        if (property.isOrdered()) {
            if (needsComma) {
                buffer.append(",");
                buffer.append(NL);
            }
            buffer.append("ordered");
            needsComma = true;
        }
        if (property.isUnique() && property.getUpper() > 1) {
            if (needsComma) {
                buffer.append(",");
                buffer.append(NL);
            }
            buffer.append("unique");
            needsComma = true;
        }
        for (Property redefinedProperty : property.getRedefinedProperties()) {
            if (redefinedProperty.eIsProxy() || redefinedProperty.getName().equals(property.getName())) continue;
            if (needsComma) {
                buffer.append(", ");
                buffer.append(NL);
            }
            buffer.append("redefines ");
            buffer.append(redefinedProperty.getName());
            needsComma = true;
        }
        for (Property current : property.getSubsettedProperties()) {
            if (current.eIsProxy()) continue;
            if (needsComma) {
                buffer.append(", ");
                buffer.append(NL);
            }
            buffer.append("subsets ");
            buffer.append(current.getName());
            needsComma = true;
        }
        return buffer.toString();
    }
}

