/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.ui.wizards;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mdht.uml.cda.core.util.CDAModelUtil;
import org.eclipse.mdht.uml.cda.ui.internal.Logger;
import org.eclipse.mdht.uml.cda.ui.util.CDAUIUtil;
import org.eclipse.mdht.uml.common.UmlPlugin;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginReference;
import org.eclipse.pde.internal.ui.wizards.IProjectProvider;
import org.eclipse.pde.internal.ui.wizards.plugin.PluginFieldData;
import org.eclipse.pde.ui.IFieldData;
import org.eclipse.pde.ui.IPluginContentWizard;
import org.eclipse.pde.ui.templates.PluginReference;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.osgi.framework.Bundle;

public abstract class CDAWizard
extends Wizard
implements IWorkbenchWizard {
    protected HashMap<String, Package> cdaPackages = new HashMap();
    protected HashMap<String, Type> cdaDocuments = new HashMap();
    protected HashMap<String, IFile> cdaDocumentsManifest = new HashMap();
    protected HashMap<String, IFile> cdaDocumentsGenModels = new HashMap();
    protected HashMap<String, PluginReference> references = new HashMap();
    protected Type clinicalDocument = null;
    protected IPluginContentWizard contentWizard = new IPluginContentWizard(){

        public void addPages() {
        }

        public boolean canFinish() {
            return false;
        }

        public void createPageControls(Composite pageContainer) {
        }

        public void dispose() {
        }

        public IWizardContainer getContainer() {
            return null;
        }

        public Image getDefaultPageImage() {
            return null;
        }

        public IDialogSettings getDialogSettings() {
            return null;
        }

        public IWizardPage getNextPage(IWizardPage page) {
            return null;
        }

        public IWizardPage getPage(String pageName) {
            return null;
        }

        public int getPageCount() {
            return 0;
        }

        public IWizardPage[] getPages() {
            return null;
        }

        public IWizardPage getPreviousPage(IWizardPage page) {
            return null;
        }

        public IWizardPage getStartingPage() {
            return null;
        }

        public RGB getTitleBarColor() {
            return null;
        }

        public String getWindowTitle() {
            return null;
        }

        public boolean isHelpAvailable() {
            return false;
        }

        public boolean needsPreviousAndNextButtons() {
            return false;
        }

        public boolean needsProgressMonitor() {
            return false;
        }

        public boolean performCancel() {
            return false;
        }

        public boolean performFinish() {
            return false;
        }

        public void setContainer(IWizardContainer wizardContainer) {
        }

        public void init(IFieldData data) {
        }

        public IPluginReference[] getDependencies(String schemaVersion) {
            Comparator<IPluginReference> c = new Comparator<IPluginReference>(){

                @Override
                public int compare(IPluginReference arg0, IPluginReference arg1) {
                    return arg0.getId().compareTo(arg1.getId());
                }
            };
            ArrayList<PluginReference> list = new ArrayList<PluginReference>();
            list.addAll(CDAWizard.this.references.values());
            Collections.sort(list, c);
            IPluginReference[] results = new IPluginReference[list.size()];
            list.toArray(results);
            return results;
        }

        public String[] getNewFiles() {
            return new String[0];
        }

        public boolean performFinish(IProject project, IPluginModelBase model, IProgressMonitor monitor) {
            return false;
        }
    };
    protected IProjectProvider fProjectProvider;
    protected PluginFieldData fPluginData = new PluginFieldData();
    IProject modelProject;
    IProject generatedProject;
    IProject docProject;
    String modelProjectName;
    String generateProjectName;
    String docProjectName;

    public CDAWizard() {
        this.fPluginData.setDoGenerateClass(false);
        this.fPluginData.setEnableAPITooling(false);
        this.fPluginData.setClassname(null);
        this.fPluginData.setSourceFolderName("src");
        this.fPluginData.setOutputFolderName("bin");
        this.fPluginData.setUIPlugin(false);
        this.fPluginData.setHasBundleStructure(true);
        this.fPluginData.setTargetVersion("3.5");
        this.fPluginData.setExecutionEnvironment("JavaSE-1.7");
        this.fPluginData.setVersion("0.1.0.qualifier");
        this.fProjectProvider = new IProjectProvider(){

            public IProject getProject() {
                return CDAWizard.this.generatedProject;
            }

            public String getProjectName() {
                return CDAWizard.this.generateProjectName;
            }

            public IPath getLocationPath() {
                return CDAWizard.this.generatedProject.getFullPath();
            }
        };
    }

    IFolder createFolder(IProject project, String name) {
        try {
            IFolder folder = CDAUIUtil.getBundleRelativeFolder(project, (IPath)new Path(name));
            folder.create(true, false, null);
            return folder;
        }
        catch (Exception e) {
            Logger.logException(e);
            return null;
        }
    }

    IFile createFile(IProject project, String name, InputStream contents) {
        try {
            Path filePath = new Path(name);
            IFile file = CDAUIUtil.getBundleRelativeFile(project, (IPath)filePath);
            file.create(contents, true, null);
            return file;
        }
        catch (Exception e) {
            Logger.logException(e);
            return null;
        }
    }

    void loadCDAModels() {
        this.loadCDAModelsfromWorkspace();
    }

    void loadCDAModelsfromWorkspace() {
        UmlPlugin.computeModelPathMapExtensions();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap((boolean)false));
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        Path model = new Path("model");
        IProject[] iProjectArray = root.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isOpen() && project.exists((IPath)model)) {
                IFile plugin = project.getFile("plugin.xml");
                IFolder folder = project.getFolder((IPath)model);
                try {
                    IResource[] iResourceArray = folder.members();
                    int n3 = iResourceArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IResource resource = iResourceArray[n4];
                        if (resource.getName().endsWith(".uml") && !resource.getName().contains("_Ecore")) {
                            Package p;
                            URI pathMap;
                            URI modelFile = null;
                            modelFile = plugin.exists() ? ((pathMap = UmlPlugin.getPathMap((InputStream)plugin.getContents())) != null ? pathMap.appendSegment(resource.getName()) : URI.createFileURI((String)project.getFolder((IPath)model).getFile(resource.getName()).getRawLocation().toOSString())) : URI.createFileURI((String)project.getFolder((IPath)model).getFile(resource.getName()).getRawLocation().toOSString());
                            PackageableElement pe = (PackageableElement)EcoreUtil.getObjectByType((Collection)resourceSet.getResource(modelFile, true).getContents(), (EClassifier)UMLPackage.eINSTANCE.getPackageableElement());
                            if (pe != null && pe instanceof Package && ((p = (Package)pe).getAppliedProfile("CDA") != null || p.getName().equals("cda"))) {
                                IProject generatedProject = project;
                                if (project.getName().endsWith(".model")) {
                                    generatedProject = root.getProject(project.getName().replace(".model", ""));
                                }
                                this.cdaPackages.put(p.getQualifiedName(), p);
                                this.cdaDocumentsManifest.put(p.getQualifiedName(), CDAUIUtil.getManifest(generatedProject));
                                if (generatedProject.getFolder((IPath)model).exists()) {
                                    IResource[] iResourceArray2 = generatedProject.getFolder((IPath)model).members();
                                    int n5 = iResourceArray2.length;
                                    int n6 = 0;
                                    while (n6 < n5) {
                                        IResource genmodel = iResourceArray2[n6];
                                        if (genmodel.getName().endsWith(".genmodel")) {
                                            this.cdaDocumentsGenModels.put(p.getQualifiedName(), CDAUIUtil.getGenModel(generatedProject, genmodel.getProjectRelativePath()));
                                        }
                                        ++n6;
                                    }
                                }
                            }
                        }
                        ++n4;
                    }
                }
                catch (Exception e) {
                    Logger.logException(e);
                }
            }
            ++n2;
        }
        Package cdaPackage = this.cdaPackages.get("cda");
        if (cdaPackage != null) {
            this.clinicalDocument = cdaPackage.getOwnedType("ClinicalDocument");
            for (Package ps : this.cdaPackages.values()) {
                for (Type type : ps.getOwnedTypes()) {
                    if (!CDAModelUtil.isClinicalDocument((Type)type)) continue;
                    this.cdaDocuments.put(type.getQualifiedName(), type);
                    this.cdaDocumentsManifest.put(type.getQualifiedName(), this.cdaDocumentsManifest.get(ps.getQualifiedName()));
                    this.cdaDocumentsGenModels.put(type.getQualifiedName(), this.cdaDocumentsGenModels.get(ps.getQualifiedName()));
                }
            }
        }
    }

    void loadCDAModelsfromPlugins() {
        Package cdaPackage;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.emf.ecore.generated_package");
        if (point != null) {
            IExtension[] iExtensionArray = point.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Enumeration umlFiles;
                IExtension extension = iExtensionArray[n2];
                Bundle bundle = Platform.getBundle((String)extension.getContributor().getName());
                if (bundle != null && (umlFiles = bundle.findEntries("model", "*.uml", true)) != null) {
                    while (umlFiles.hasMoreElements()) {
                        Package p;
                        URI foo;
                        PackageableElement foo2;
                        URL umlFileURL = (URL)umlFiles.nextElement();
                        if (umlFileURL.getFile().contains("_Ecore") || !((foo2 = (PackageableElement)EcoreUtil.getObjectByType((Collection)resourceSet.getResource(foo = URI.createPlatformPluginURI((String)(String.valueOf(extension.getContributor().getName()) + umlFileURL.getPath()), (boolean)false), true).getContents(), (EClassifier)UMLPackage.eINSTANCE.getPackageableElement())) instanceof Package) || (p = (Package)foo2).getAppliedProfile("CDA") == null && !p.getName().equals("cda")) continue;
                        this.cdaPackages.put(p.getQualifiedName(), p);
                        this.references.put(bundle.getSymbolicName(), new PluginReference(bundle.getSymbolicName(), null, 0));
                        this.references.put("org.eclipse.mdht.builder.cda", new PluginReference("org.eclipse.mdht.builder.cda", null, 0));
                        Object header = bundle.getHeaders().get("Require-Bundle");
                        try {
                            ManifestElement[] manifestElementArray = ManifestElement.parseHeader((String)"Require-Bundle", (String)((String)header));
                            int n3 = manifestElementArray.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                ManifestElement manifestElement = manifestElementArray[n4];
                                this.references.put(manifestElement.getValue(), new PluginReference(manifestElement.getValue(), null, 0));
                                ++n4;
                            }
                        }
                        catch (Exception e) {
                            Logger.logException(e);
                        }
                    }
                }
                ++n2;
            }
        }
        if ((cdaPackage = this.cdaPackages.get("cda")) != null) {
            this.clinicalDocument = cdaPackage.getOwnedType("ClinicalDocument");
            for (Package ps : this.cdaPackages.values()) {
                for (Type type : ps.getOwnedTypes()) {
                    if (!type.conformsTo(this.clinicalDocument)) continue;
                    this.cdaDocuments.put(type.getQualifiedName(), type);
                }
            }
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

