/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.ui.navigator.internal;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.service.IValidationListener;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.emf.validation.service.ValidationEvent;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.mdht.uml.ui.navigator.UMLAbstractNavigatorItem;
import org.eclipse.mdht.uml.ui.navigator.UMLDomainNavigatorItem;
import org.eclipse.mdht.uml.ui.navigator.internal.UMLNavigatorGroup;
import org.eclipse.mdht.uml.ui.navigator.internal.plugin.Activator;
import org.eclipse.mdht.uml.ui.navigator.internal.providers.NavigatorUMLItemProviderAdapterFactory;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonLabelProvider;

public class UMLNavigatorLabelProvider
extends LabelProvider
implements ICommonLabelProvider {
    private ComposedAdapterFactory adapterFactory;
    private ILabelProvider labelProvider;
    private IValidationListener validationListener = new IValidationListener(){

        public void validationOccurred(ValidationEvent event) {
            if (event.getClientContextIds().contains("org.eclipse.mdht.uml.ui.validation.refresh") && event.getEvaluationMode() == EvaluationMode.BATCH) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        UMLNavigatorLabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)UMLNavigatorLabelProvider.this, null));
                    }
                });
            }
        }
    };

    static {
        Activator.getDefault().getImageRegistry().put("Navigator?InvalidElement", ImageDescriptor.getMissingImageDescriptor());
        Activator.getDefault().getImageRegistry().put("Navigator?UnknownElement", ImageDescriptor.getMissingImageDescriptor());
        Activator.getDefault().getImageRegistry().put("Navigator?ImageNotFound", ImageDescriptor.getMissingImageDescriptor());
    }

    public UMLNavigatorLabelProvider() {
        this.adapterFactory = this.createAdapterFactory();
        this.labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory);
        ModelValidationService.getInstance().addValidationListener(this.validationListener);
    }

    public void dispose() {
        this.adapterFactory.dispose();
        ModelValidationService.getInstance().removeValidationListener(this.validationListener);
    }

    protected ComposedAdapterFactory createAdapterFactory() {
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.adapterFactory.addAdapterFactory((AdapterFactory)new NavigatorUMLItemProviderAdapterFactory());
        return this.adapterFactory;
    }

    public Image getImage(Object element) {
        if (!(element instanceof UMLAbstractNavigatorItem)) {
            return super.getImage(element);
        }
        UMLAbstractNavigatorItem abstractNavigatorItem = (UMLAbstractNavigatorItem)((Object)element);
        if (abstractNavigatorItem instanceof UMLDomainNavigatorItem) {
            UMLDomainNavigatorItem navigatorItem = (UMLDomainNavigatorItem)abstractNavigatorItem;
            return this.labelProvider.getImage((Object)navigatorItem.getEObject());
        }
        if (abstractNavigatorItem instanceof UMLNavigatorGroup) {
            UMLNavigatorGroup group = (UMLNavigatorGroup)((Object)element);
            return Activator.getDefault().getBundledImage(group.getIcon());
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof IFile) {
            return "(" + super.getText(element) + ")";
        }
        if (element instanceof UMLAbstractNavigatorItem) {
            UMLAbstractNavigatorItem abstractNavigatorItem = (UMLAbstractNavigatorItem)((Object)element);
            if (abstractNavigatorItem instanceof UMLDomainNavigatorItem) {
                UMLDomainNavigatorItem navigatorItem = (UMLDomainNavigatorItem)abstractNavigatorItem;
                return this.labelProvider.getText((Object)navigatorItem.getEObject());
            }
            if (abstractNavigatorItem instanceof UMLNavigatorGroup) {
                UMLNavigatorGroup group = (UMLNavigatorGroup)((Object)element);
                return group.getGroupName();
            }
        }
        return super.getText(element);
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public String getDescription(Object anElement) {
        return null;
    }
}

