/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.dita.ui.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.xerces.util.XMLCatalogResolver;
import org.eclipse.ant.internal.launching.launchConfigurations.AntHomeClasspathEntry;
import org.eclipse.ant.internal.launching.launchConfigurations.ContributedClasspathEntriesEntry;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.mdht.dita.ui.internal.Activator;
import org.osgi.framework.Bundle;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DitaUtil {
    public static void validate(IPath tmpFileInWorkspaceDir) throws IOException, ParserConfigurationException, SAXException, URISyntaxException {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.mdht.dita.ui");
        Path ditaFolderPath = new Path("DITA-OT");
        URL ditaFolder = FileLocator.toFileURL((URL)FileLocator.find((Bundle)bundle, (IPath)ditaFolderPath, null));
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        DocumentBuilder parser = dbf.newDocumentBuilder();
        Document document = parser.parse(tmpFileInWorkspaceDir.toFile());
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        File ditaCatalogFile = new File(ditaFolder.getFile(), "schema/catalog.xml");
        XMLCatalogResolver resolver = new XMLCatalogResolver(new String[]{ditaCatalogFile.getAbsolutePath()});
        schemaFactory.setResourceResolver((LSResourceResolver)resolver);
        File ditaSchemaFile = new File(ditaFolder.getFile(), "schema/technicalContent/xsd/topic.xsd");
        StreamSource schemaFile = new StreamSource(ditaSchemaFile);
        Schema schema = schemaFactory.newSchema(schemaFile);
        Validator validator = schema.newValidator();
        DOMSource dom = new DOMSource(document);
        validator.validate(dom);
    }

    public static ILaunch publish(IFile ditaMapFile, String antTargets) throws IOException, CoreException, URISyntaxException {
        return DitaUtil.publish(ditaMapFile, antTargets, "ditaval.xml");
    }

    public static ILaunch publish(IFile ditaMapFile, String antTargets, String ditavalFileName) throws IOException, CoreException, URISyntaxException {
        IProject ditaProject = ditaMapFile.getProject();
        IFolder ditaFolder = ditaProject.getFolder((IPath)new Path("dita"));
        IFile ditaValFile = ditaFolder.getFile(ditavalFileName);
        StringBuffer jvmArguments = new StringBuffer();
        for (String arg : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
            if (!arg.startsWith("-X")) continue;
            jvmArguments.append(arg);
            jvmArguments.append(" ");
        }
        jvmArguments.append("-Dfile.encoding=UTF-8 ");
        String[] segments = ditaMapFile.getName().split("\\.");
        String ditaMapFileRoot = segments[0];
        Bundle bundle = Platform.getBundle((String)"org.dita.dost");
        if (bundle == null) {
            return null;
        }
        Path path = new Path("META-INF/MANIFEST.MF");
        URL fileURL = FileLocator.find((Bundle)bundle, (IPath)path, null);
        Path ditadirPath = new Path("DITA-OT");
        URL ditadirURL = FileLocator.find((Bundle)bundle, (IPath)ditadirPath, null);
        if (ditadirURL == null) {
            return null;
        }
        ditadirURL = FileLocator.toFileURL((URL)ditadirURL);
        InputStream in = fileURL.openStream();
        Manifest ditaPluginManifest = new Manifest(in);
        Attributes attributes = ditaPluginManifest.getMainAttributes();
        String ditaClassPath = attributes.getValue("Bundle-ClassPath");
        ArrayList<String> classpath = new ArrayList<String>();
        String ditaRequiredBundles = attributes.getValue("Require-Bundle");
        String[] stringArray = ditaRequiredBundles.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String requiredBundleSymbolicName = stringArray[n2];
            Bundle requiredBundle = Platform.getBundle((String)requiredBundleSymbolicName.split(";")[0]);
            if (requiredBundle != null) {
                File file = FileLocator.getBundleFile((Bundle)requiredBundle);
                IRuntimeClasspathEntry requiredBundleEntry = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)new Path(file.getPath()));
                requiredBundleEntry.setClasspathProperty(3);
                classpath.add(requiredBundleEntry.getMemento());
            }
            ++n2;
        }
        stringArray = ditaClassPath.split(",");
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            URL url;
            String classPath = stringArray[n2];
            if (".".equals(classPath)) {
                url = FileLocator.find((Bundle)bundle, (IPath)new Path(""), null);
                url = FileLocator.toFileURL((URL)url);
                IRuntimeClasspathEntry pluginEntry = JavaRuntime.newRuntimeContainerClasspathEntry((IPath)new Path(url.getPath()), (int)3);
                classpath.add(pluginEntry.getMemento());
            } else {
                url = FileLocator.find((Bundle)bundle, (IPath)new Path(classPath), null);
                System.out.println(url);
                url = FileLocator.toFileURL((URL)url);
                IRuntimeClasspathEntry toolsEntry = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)new Path(url.getPath()));
                toolsEntry.setClasspathProperty(3);
                classpath.add(toolsEntry.getMemento());
            }
            ++n2;
        }
        ContributedClasspathEntriesEntry ccee = new ContributedClasspathEntriesEntry();
        AntHomeClasspathEntry ace = new AntHomeClasspathEntry();
        classpath.add(ace.getMemento());
        classpath.add(ccee.getMemento());
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = launchManager.getLaunchConfigurationType("org.eclipse.ant.AntLaunchConfigurationType");
        URL ditaPublishBuildFileURL = fileURL = FileLocator.find((Bundle)bundle, (IPath)new Path("dita-publish.xml"), null);
        ditaPublishBuildFileURL = FileLocator.toFileURL((URL)ditaPublishBuildFileURL);
        String name = launchManager.generateLaunchConfigurationName("Publish DITA");
        ILaunchConfigurationWorkingCopy workingCopy = type.newInstance(null, name);
        workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", ditaPublishBuildFileURL.getPath());
        IVMInstall jre = JavaRuntime.getDefaultVMInstall();
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, jre.getName());
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, "-Djavax.xml.transform.TransformerFactory=net.sf.saxon.TransformerFactoryImpl");
        HashMap<String, String> antProperties = new HashMap<String, String>();
        antProperties.put("dita.dir", ditadirURL.getPath());
        antProperties.put("ditaMapFile", ditaMapFile.getLocation().toOSString());
        if (ditaValFile != null) {
            antProperties.put("args.filter", ditaValFile.getLocation().toOSString());
        }
        antProperties.put("ditaMapFileName", ditaMapFile.getName().substring(0, ditaMapFile.getName().length() - ditaMapFile.getFileExtension().length()));
        antProperties.put("dita.output", ditaProject.getLocation().append(antTargets).toOSString());
        antProperties.put("ditaMapFileRoot", ditaMapFileRoot);
        String fileName = DitaUtil.getFileNameFromMap(ditaMapFile.getLocation().toOSString());
        if (StringUtils.isEmpty((String)fileName)) {
            fileName = ditaMapFile.getName().replace("." + ditaMapFile.getFileExtension(), "");
        }
        antProperties.put("fileName", fileName);
        antProperties.put("args.debug", "no");
        antProperties.put("ditaFilePath", ditaFolder.getLocation().toOSString());
        antProperties.put("tempFilePath", Activator.getDefault().getStateLocation().append("temp").toOSString());
        antProperties.put("docProject", ditaProject.getLocation().toOSString());
        String pdfFileLocation = ditaMapFile.getName();
        pdfFileLocation = pdfFileLocation.replaceFirst(".ditamap", ".pdf");
        antProperties.put("pdflocation", pdfFileLocation);
        workingCopy.setAttribute("process_factory_id", "org.eclipse.ant.ui.remoteAntProcessFactory");
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "org.eclipse.ant.internal.ui.antsupport.InternalAntRunner");
        workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", ditaProject.getLocation().toOSString());
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, jvmArguments.toString());
        workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_TARGETS", antTargets);
        workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_PROPERTIES", antProperties);
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, classpath);
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
        workingCopy.setAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_PROCESS", false);
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER, "org.eclipse.ant.ui.AntClasspathProvider");
        workingCopy.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", true);
        workingCopy.setAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_ENCODING", "UTF-8");
        workingCopy.migrate();
        return workingCopy.launch("run", null, false, true);
    }

    private static String getFileNameFromMap(String ditaMapPath) {
        StringBuffer fileName = new StringBuffer();
        try {
            FileInputStream ditaMapStream = new FileInputStream(ditaMapPath);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            factory.setFeature("http://xml.org/sax/features/namespaces", false);
            factory.setFeature("http://xml.org/sax/features/validation", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            Document doc = null;
            XPathExpression expr = null;
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(new InputSource(ditaMapStream));
            XPathFactory xFactory = XPathFactory.newInstance();
            XPath xpath = xFactory.newXPath();
            expr = xpath.compile("//bookmap/bookmeta/prodinfo/prodname");
            Node prodNameNode = (Node)expr.evaluate(doc, XPathConstants.NODE);
            if (prodNameNode != null) {
                NodeList versions;
                fileName.append(prodNameNode.getTextContent());
                expr = xpath.compile("//bookmap/bookmeta/prodinfo/vrmlist");
                Element vrmlistNode = (Element)expr.evaluate(doc, XPathConstants.NODE);
                if (vrmlistNode != null && (versions = vrmlistNode.getElementsByTagName("vrm")).getLength() > 0) {
                    Attr versionAttr;
                    NamedNodeMap versionAttributes = versions.item(0).getAttributes();
                    Attr releaseAttr = (Attr)versionAttributes.getNamedItem("release");
                    if (releaseAttr != null) {
                        fileName.append(String.format("_%s", releaseAttr.getValue()));
                    }
                    if ((versionAttr = (Attr)versionAttributes.getNamedItem("version")) != null) {
                        fileName.append(String.format("_%s", versionAttr.getValue()));
                    }
                }
            } else {
                expr = xpath.compile("/bookmap");
                prodNameNode = (Node)expr.evaluate(doc, XPathConstants.NODE);
                if (prodNameNode != null) {
                    Node node = prodNameNode.getAttributes().getNamedItem("id");
                    if (node != null) {
                        fileName.append(node.getTextContent());
                    }
                } else {
                    Node node;
                    expr = xpath.compile("/map");
                    prodNameNode = (Node)expr.evaluate(doc, XPathConstants.NODE);
                    if (prodNameNode != null && (node = prodNameNode.getAttributes().getNamedItem("title")) != null) {
                        fileName.append(node.getTextContent());
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println();
        }
        return fileName.toString();
    }
}

