/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.term.ui.notation;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.mdht.uml.common.notation.INotationProvider;
import org.eclipse.mdht.uml.common.util.UMLUtil;
import org.eclipse.mdht.uml.term.core.profile.CodeSystemVersion;
import org.eclipse.mdht.uml.term.core.profile.ValueSetCode;
import org.eclipse.mdht.uml.term.core.profile.ValueSetVersion;
import org.eclipse.mdht.uml.term.core.util.TermProfileUtil;
import org.eclipse.mdht.uml.term.ui.notation.TermPropertyNotation;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Property;

public class TermAnnotationProvider
implements INotationProvider,
IExecutableExtension {
    public static final int TERM_PROPERTY_ANNOTATION = 640;

    public String getAnnotation(Element element) {
        Property navigableEnd;
        String annotation = null;
        if (element instanceof Enumeration) {
            annotation = TermAnnotationProvider.getMetadata((Enumeration)element);
        } else if (element instanceof EnumerationLiteral) {
            annotation = TermAnnotationProvider.getMetadata((EnumerationLiteral)element);
        } else if (element instanceof Property) {
            annotation = TermPropertyNotation.getCustomLabel((Property)element, 640);
        } else if (element instanceof Association && (navigableEnd = UMLUtil.getNavigableEnd((Association)((Association)element))) != null) {
            annotation = TermPropertyNotation.getCustomLabel(navigableEnd, 640);
        }
        return annotation;
    }

    public Object getAnnotationImage(Element element) {
        return null;
    }

    public Object getElementImage(Element element) {
        return null;
    }

    public String getPrintString(Element element) {
        String printString = null;
        if (element instanceof Property) {
            printString = TermPropertyNotation.getCustomLabel((Property)element, 764);
        }
        return printString;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    private static String getMetadata(Enumeration enumeration) {
        StringBuffer value = new StringBuffer();
        CodeSystemVersion codeSystemVersion = TermProfileUtil.getCodeSystemVersion((Enumeration)enumeration);
        ValueSetVersion valueSetVersion = TermProfileUtil.getValueSetVersion((Enumeration)enumeration);
        String identifier = null;
        if (codeSystemVersion != null) {
            identifier = codeSystemVersion.getIdentifier();
        } else if (valueSetVersion != null) {
            identifier = valueSetVersion.getIdentifier();
        }
        if (identifier != null) {
            value.append(identifier);
        }
        return value.toString();
    }

    private static String getMetadata(EnumerationLiteral literal) {
        StringBuffer value = new StringBuffer();
        ValueSetCode valueSetCode = TermProfileUtil.getValueSetCode((EnumerationLiteral)literal);
        if (valueSetCode != null && valueSetCode.getConceptName() != null) {
            value.append(valueSetCode.getConceptName());
        }
        return value.toString();
    }
}

