/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.term.ui.notation;

import org.eclipse.mdht.uml.common.notation.PropertyNotationUtil;
import org.eclipse.mdht.uml.common.util.MultiplicityElementUtil;
import org.eclipse.mdht.uml.common.util.NamedElementUtil;
import org.eclipse.mdht.uml.term.core.profile.CodeSystemConstraint;
import org.eclipse.mdht.uml.term.core.profile.CodeSystemVersion;
import org.eclipse.mdht.uml.term.core.profile.ConceptDomainConstraint;
import org.eclipse.mdht.uml.term.core.profile.ValueSetConstraint;
import org.eclipse.mdht.uml.term.core.profile.ValueSetVersion;
import org.eclipse.mdht.uml.term.core.util.TermProfileUtil;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;

public class TermPropertyNotation
extends PropertyNotationUtil {
    public static String getCustomLabel(Property property, int style) {
        String termMetadata;
        String modifiers;
        String multiplicity;
        StringBuffer buffer = new StringBuffer();
        if ((style & 2) != 0) {
            buffer.append(NamedElementUtil.getVisibilityAsSign((NamedElement)property));
        }
        if ((style & 4) != 0 && property.isDerived()) {
            buffer.append("/");
        }
        if ((style & 8) != 0) {
            buffer.append(" ");
            buffer.append(property.getName());
        }
        if ((style & 0x10) != 0) {
            if (property.getType() != null) {
                buffer.append(" : " + property.getType().getName());
            } else {
                buffer.append(" : <Undefined>");
            }
        }
        if ((style & 0x20) != 0 && !(multiplicity = MultiplicityElementUtil.getMultiplicityAsString((MultiplicityElement)property)).trim().equals("[1]")) {
            buffer.append(multiplicity);
        }
        if ((style & 0x40) != 0 && property.getDefault() != null) {
            buffer.append(" = ");
            buffer.append(property.getDefault());
        }
        boolean multiLine = (style & 0x100000) != 0;
        StringBuffer annotations = new StringBuffer();
        if ((style & 0x80) != 0 && !(modifiers = PropertyNotationUtil.getModifiersAsString((Property)property, (boolean)multiLine)).equals("")) {
            annotations.append(modifiers);
        }
        if ((termMetadata = TermPropertyNotation.getTerminologyAnnotations(property, style)).length() > 0) {
            if (annotations.length() > 0) {
                annotations.append(", ");
            }
            annotations.append(termMetadata);
        }
        if (annotations.length() > 0) {
            if (multiLine) {
                buffer.append("\n");
            }
            boolean showBrackets = buffer.length() > 0;
            buffer.append(showBrackets ? " {" : "");
            buffer.append(annotations);
            buffer.append(showBrackets ? "}" : "");
        }
        return buffer.toString().trim();
    }

    public static String getTerminologyAnnotations(Property property, int style) {
        StringBuffer buffer = new StringBuffer();
        if ((style & 0x200) != 0) {
            String vocab = null;
            if (TermProfileUtil.getConceptDomainConstraint((Property)property) != null) {
                vocab = TermPropertyNotation.getConceptDomainAnnotation(property);
            } else if (TermProfileUtil.getCodeSystemConstraint((Property)property) != null) {
                vocab = TermPropertyNotation.getCodeSystemAnnotation(property);
            } else if (TermProfileUtil.getValueSetConstraint((Property)property) != null) {
                vocab = TermPropertyNotation.getValueSetAnnotation(property);
            }
            if (vocab != null && vocab.length() > 0) {
                if (buffer.length() > 0) {
                    buffer.append(" ");
                }
                buffer.append(vocab);
            }
        }
        return buffer.toString();
    }

    private static String getConceptDomainAnnotation(Property property) {
        String name;
        String id;
        StringBuffer annotation;
        StringBuffer value = new StringBuffer();
        ConceptDomainConstraint conceptDomainConstraint = TermProfileUtil.getConceptDomainConstraint((Property)property);
        if (conceptDomainConstraint != null && (annotation = TermPropertyNotation.getVocabularyString(id = conceptDomainConstraint.getIdentifier(), name = conceptDomainConstraint.getName(), null, null)) != null) {
            value.append("CD:" + annotation);
        }
        return value.toString();
    }

    private static String getCodeSystemAnnotation(Property property) {
        StringBuffer annotation;
        StringBuffer value = new StringBuffer();
        CodeSystemConstraint codeSystemConstraint = TermProfileUtil.getCodeSystemConstraint((Property)property);
        String id = null;
        String name = null;
        String code = null;
        String version = null;
        if (codeSystemConstraint != null) {
            if (codeSystemConstraint.getReference() != null) {
                CodeSystemVersion codeSystemVersion = codeSystemConstraint.getReference();
                id = codeSystemVersion.getIdentifier();
                name = codeSystemVersion.getBase_Enumeration() != null ? codeSystemVersion.getEnumerationName() : "Error:No Base Enumeration";
                version = codeSystemVersion.getVersion();
            } else {
                id = codeSystemConstraint.getIdentifier();
                name = codeSystemConstraint.getName();
                version = codeSystemConstraint.getVersion();
            }
            code = codeSystemConstraint.getCode();
        }
        if ((annotation = TermPropertyNotation.getVocabularyString(id, name, version, code)) != null && annotation.length() > 0) {
            value.append("C:" + annotation);
        }
        return value.toString();
    }

    private static String getValueSetAnnotation(Property property) {
        StringBuffer annotation;
        StringBuffer value = new StringBuffer();
        ValueSetConstraint valueSetConstraint = TermProfileUtil.getValueSetConstraint((Property)property);
        String id = null;
        String name = null;
        String version = null;
        if (valueSetConstraint != null) {
            if (valueSetConstraint.getReference() != null) {
                ValueSetVersion valueSetVersion = valueSetConstraint.getReference();
                id = valueSetVersion.getIdentifier();
                name = valueSetVersion.getEnumerationName();
                version = valueSetVersion.getVersion();
            } else {
                id = valueSetConstraint.getIdentifier();
                name = valueSetConstraint.getName();
                version = valueSetConstraint.getVersion();
            }
        }
        if ((annotation = TermPropertyNotation.getVocabularyString(id, name, version, null)) != null && annotation.length() > 0) {
            value.append("V:" + annotation);
        }
        return value.toString();
    }

    private static StringBuffer getVocabularyString(String id, String name, String version, String code) {
        StringBuffer value = new StringBuffer();
        if (name != null) {
            value.append(name);
        } else if (id != null) {
            value.append(id);
        }
        if (code != null) {
            value.append("#" + code);
        }
        return value;
    }
}

