/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.term.ui.properties;

import java.util.ArrayList;
import java.util.function.Consumer;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mdht.uml.term.core.profile.ContextToValueSet;
import org.eclipse.mdht.uml.term.core.profile.TermFactory;
import org.eclipse.mdht.uml.term.core.profile.ValueSetConstraints;
import org.eclipse.mdht.uml.term.core.util.TermProfileUtil;
import org.eclipse.mdht.uml.term.ui.TerminologyService;
import org.eclipse.mdht.uml.ui.properties.sections.ResettableModelerPropertySection;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class ValueSetConstraintsSection
extends ResettableModelerPropertySection {
    private Property property;
    private static String[] CONTEXTS = null;
    private static final String CONTEXT_PROPERTY = "context";
    private static final String URI_PROPERTY = "uri";
    private TableViewer viewer;
    Table table = null;
    Enumeration enumeration = null;

    protected void resetFields() {
    }

    private void attachLabelProvider(TableViewer viewer) {
        viewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                EditableTableItem tableItem = (EditableTableItem)element;
                switch (columnIndex) {
                    case 1: {
                        return tableItem.constraint;
                    }
                    case 0: {
                        return tableItem.context;
                    }
                }
                return "Invalid column: " + columnIndex;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener lpl) {
            }
        });
    }

    private void attachContentProvider(TableViewer viewer) {
        viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return (Object[])inputElement;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
    }

    private TableViewer buildAndLayoutTable(Composite composite, Table table) {
        TableViewer tableViewer = new TableViewer(table);
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(10, pixelConverter.convertWidthInCharsToPixels(40), true));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(10, pixelConverter.convertWidthInCharsToPixels(40), true));
        table.setLayout((Layout)layout);
        TableColumn contextColumn = new TableColumn(table, 0x1000000);
        contextColumn.setText("Context");
        TableColumn uriColumn = new TableColumn(table, 0x1000000);
        uriColumn.setText("URI");
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        return tableViewer;
    }

    private void attachCellEditors(final TableViewer viewer, Composite parent) {
        viewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return true;
            }

            public Object getValue(Object element, String property) {
                EditableTableItem tableItem = (EditableTableItem)element;
                if (ValueSetConstraintsSection.CONTEXT_PROPERTY.equals(property)) {
                    int result = ArrayUtils.indexOf((Object[])CONTEXTS, (Object)tableItem.context);
                    if (result != -1) {
                        return new Integer(result);
                    }
                    return new Integer(0);
                }
                return tableItem.constraint != null ? tableItem.constraint : "xxxx";
            }

            public void modify(Object element, String property, Object value) {
                TableItem tableItem = (TableItem)element;
                EditableTableItem data = (EditableTableItem)tableItem.getData();
                if (ValueSetConstraintsSection.CONTEXT_PROPERTY.equals(property)) {
                    String context = CONTEXTS[(Integer)value];
                    data.context = ValueSetConstraintsSection.this.enumeration.getOwnedLiteral(context).getName();
                } else {
                    data.constraint = (String)value;
                }
                ValueSetConstraintsSection.this.modifyFields(data);
                viewer.refresh((Object)data);
            }
        });
        MyComboBoxViewerCellEditor uriComboBox = new MyComboBoxViewerCellEditor(parent);
        uriComboBox.setContentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint ep = reg.getExtensionPoint("org.eclipse.mdht.uml.term.ui.service");
        IExtension[] extensions = ep.getExtensions();
        TerminologyService ts = null;
        try {
            ts = (TerminologyService)extensions[0].getConfigurationElements()[0].createExecutableExtension("service");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (ts != null && !ts.getValueSets().isEmpty()) {
            uriComboBox.setInput(ts.getValueSets().toArray(new String[0]));
        } else {
            uriComboBox.setInput(new String[]{""});
        }
        viewer.setCellEditors(new CellEditor[]{new ComboBoxCellEditor(parent, CONTEXTS), uriComboBox});
        viewer.setColumnProperties(new String[]{CONTEXT_PROPERTY, URI_PROPERTY});
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        EObject element = this.getEObject();
        Assert.isTrue((boolean)(element instanceof NamedElement));
        this.property = (Property)element;
    }

    public void dispose() {
        super.dispose();
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Shell shell = new Shell();
        GC gc = new GC((Drawable)shell);
        gc.setFont(shell.getFont());
        Point point = gc.textExtent("");
        int buttonHeight = point.y + 10;
        gc.dispose();
        shell.dispose();
        Group composite = this.getWidgetFactory().createGroup(parent, "Value Sets");
        FormLayout layout = new FormLayout();
        layout.marginWidth = 7;
        layout.marginHeight = 4;
        layout.spacing = 7;
        composite.setLayout((Layout)layout);
        this.table = this.getWidgetFactory().createTable((Composite)composite, 67584);
        this.table.setLinesVisible(true);
        this.viewer = this.buildAndLayoutTable((Composite)composite, this.table);
        this.attachContentProvider(this.viewer);
        this.attachLabelProvider(this.viewer);
        MenuManager popupMenu = new MenuManager();
        NewRowAction newRowAction = new NewRowAction();
        popupMenu.add((IAction)newRowAction);
        Menu menu = popupMenu.createContextMenu((Control)this.table);
        this.table.setMenu(menu);
        FormData data = null;
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.width = pixelConverter.convertWidthInCharsToPixels(150);
        data.height = 400;
        this.table.setLayoutData((Object)data);
        composite.layout();
    }

    public void refresh() {
        ValueSetConstraints valueSetConstraints = TermProfileUtil.getValueSetConstraints((Property)this.property);
        if (this.property != null) {
            for (Element e : this.property.getNearestPackage().allOwnedElements()) {
                if (!(e instanceof Enumeration) || TermProfileUtil.getContext((Enumeration)((Enumeration)e)) == null) continue;
                this.enumeration = (Enumeration)e;
                ArrayList<String> literals = new ArrayList<String>();
                for (EnumerationLiteral el : this.enumeration.getOwnedLiterals()) {
                    literals.add(el.getName());
                }
                CONTEXTS = literals.toArray(new String[0]);
            }
        }
        final ArrayList list = new ArrayList();
        Consumer<ContextToValueSet> action = new Consumer<ContextToValueSet>(){

            @Override
            public void accept(ContextToValueSet t) {
                list.add(new EditableTableItem(t));
            }
        };
        valueSetConstraints.getConstraints().forEach((Consumer)action);
        this.viewer.setInput((Object)list.toArray());
        this.viewer.getControl().getParent().layout(true);
        this.attachCellEditors(this.viewer, (Composite)this.table);
        super.refresh();
    }

    private void modifyFields(final EditableTableItem update) {
        try {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.property);
            AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, "temp"){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                    Profile ctsProfile = TermProfileUtil.getTerminologyProfile((ResourceSet)ValueSetConstraintsSection.this.property.eResource().getResourceSet());
                    if (ctsProfile == null) {
                        return Status.CANCEL_STATUS;
                    }
                    Stereotype stereotype = TermProfileUtil.getAppliedStereotype((Element)ValueSetConstraintsSection.this.property, (String)"ValueSetConstraints");
                    if (stereotype == null) {
                        return Status.CANCEL_STATUS;
                    }
                    ValueSetConstraints valueSetConstraints = (ValueSetConstraints)ValueSetConstraintsSection.this.property.getStereotypeApplication(stereotype);
                    if (update.ctov == null) {
                        ContextToValueSet contextToValueSet = TermFactory.eINSTANCE.createContextToValueSet();
                        contextToValueSet.setKey(update.context);
                        contextToValueSet.setValue(update.constraint);
                        update.ctov = contextToValueSet;
                        valueSetConstraints.getConstraints().add((Object)contextToValueSet);
                    } else {
                        int index = valueSetConstraints.getConstraints().indexOf((Object)update.ctov);
                        ((ContextToValueSet)valueSetConstraints.getConstraints().get(index)).setKey(update.context);
                        ((ContextToValueSet)valueSetConstraints.getConstraints().get(index)).setValue(update.constraint);
                    }
                    return Status.OK_STATUS;
                }
            };
            this.execute((IUndoableOperation)operation);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    class EditableTableItem {
        private String context = "";
        private String constraint = "";
        ContextToValueSet ctov;

        public EditableTableItem(ContextToValueSet ctov) {
            this.ctov = ctov;
            if (this.ctov != null) {
                this.context = ctov.getKey();
                this.constraint = ctov.getValue();
            }
        }
    }

    class MyComboBoxViewerCellEditor
    extends ComboBoxViewerCellEditor {
        public MyComboBoxViewerCellEditor(Composite parent) {
            super(parent);
        }

        public MyComboBoxViewerCellEditor(Composite parent, int style) {
            super(parent, style);
        }

        protected Object doGetValue() {
            Object result = super.doGetValue();
            if (result == null) {
                result = this.getViewer().getCCombo().getText();
            }
            return result;
        }
    }

    private class NewRowAction
    extends Action {
        public NewRowAction() {
            super("Insert New Row");
        }

        public void run() {
            EditableTableItem newItem = new EditableTableItem(null);
            ValueSetConstraintsSection.this.modifyFields(newItem);
            ValueSetConstraintsSection.this.viewer.add((Object)newItem);
            ValueSetConstraintsSection.this.viewer.getControl().getParent().layout(true);
        }
    }
}

