/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.context.tck.cdi;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.eclipse.microprofile.context.ManagedExecutor;
import org.eclipse.microprofile.context.tck.cdi.TransactionalBean;

@ApplicationScoped
class TransactionalService {
    @Inject
    private TransactionalBean bean;

    TransactionalService() {
    }

    int getValue() {
        return this.bean.getValue();
    }

    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    void requiresNew() {
        this.bean.incrementValue();
    }

    @Transactional(value=Transactional.TxType.REQUIRED)
    void required() {
        this.bean.incrementValue();
    }

    @Transactional(value=Transactional.TxType.MANDATORY)
    void mandatory() {
        System.out.printf("%s: Transactional.TxType.MANDATORY%n", Thread.currentThread());
        this.bean.incrementValue();
    }

    @Transactional(value=Transactional.TxType.NEVER)
    void never() {
        this.bean.incrementValue();
    }

    @Transactional(value=Transactional.TxType.NOT_SUPPORTED)
    void notSupported() {
        this.bean.incrementValue();
    }

    @Transactional(value=Transactional.TxType.SUPPORTS)
    void supports() {
        this.bean.incrementValue();
    }

    @Transactional(value=Transactional.TxType.REQUIRED)
    int testAsync(ManagedExecutor executor) {
        CompletableFuture stage;
        int currentValue = this.bean.getValue();
        try {
            stage = executor.runAsync(this::required);
        }
        catch (IllegalStateException x) {
            System.out.println("Propagation of active transactions is not supported. Skipping test.");
            return -1000;
        }
        try {
            stage.join();
        }
        catch (CompletionException x) {
            if (x.getCause() instanceof IllegalStateException) {
                System.out.println("Propagation of active transactions to multiple threads in parallel is not supported. Skipping test.");
                return -1000;
            }
            throw x;
        }
        return this.bean.getValue() - currentValue;
    }

    @Transactional(value=Transactional.TxType.REQUIRED)
    int testConcurrentTransactionPropagation(ManagedExecutor executor) {
        CompletableFuture stage0;
        int currentValue = this.bean.getValue();
        try {
            stage0 = executor.runAsync(this::required);
        }
        catch (IllegalStateException x) {
            System.out.println("Propagation of active transactions is not supported. Skipping test.");
            return -1000;
        }
        CompletableFuture stage1 = executor.runAsync(this::required);
        try {
            CompletableFuture.allOf(stage0, stage1).join();
        }
        catch (CompletionException x) {
            if (x.getCause() instanceof IllegalStateException) {
                System.out.println("Propagation of active transactions to multiple threads in parallel is not supported. Skipping test.");
                return -1000;
            }
            throw x;
        }
        return this.bean.getValue() - currentValue;
    }
}

