/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.graphql.tck.apps.superhero.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Initialized;
import javax.enterprise.event.Observes;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.JsonbException;
import org.eclipse.microprofile.graphql.tck.apps.superhero.db.DuplicateSidekickException;
import org.eclipse.microprofile.graphql.tck.apps.superhero.db.UnknownSidekickException;
import org.eclipse.microprofile.graphql.tck.apps.superhero.model.Sidekick;

@ApplicationScoped
public class SidekickDatabase {
    private final Map<String, Sidekick> allSidekicks = new HashMap<String, Sidekick>();

    private void init(@Observes @Initialized(value=ApplicationScoped.class) Object init) {
        try {
            Jsonb jsonb = JsonbBuilder.create();
            String mapJson = SidekickDatabase.getInitalJson();
            this.addSidekicks((Collection)jsonb.fromJson(mapJson, new ArrayList<Sidekick>(){}.getClass().getGenericSuperclass()));
        }
        catch (JsonbException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Sidekick getSidekick(String name) throws UnknownSidekickException {
        Sidekick sidekick = this.allSidekicks.get(name);
        if (sidekick == null) {
            throw new UnknownSidekickException(name);
        }
        return sidekick;
    }

    public Collection<Sidekick> getAllSidekicks() {
        return this.allSidekicks.values();
    }

    public int addSidekicks(Collection<Sidekick> sidekicks) {
        int count = 0;
        for (Sidekick sidekick : sidekicks) {
            try {
                this.addSidekick(sidekick);
                ++count;
            }
            catch (DuplicateSidekickException ex) {
                System.out.println("Already added : " + sidekick.getName());
            }
        }
        return count;
    }

    public void addSidekick(Sidekick sidekick) throws DuplicateSidekickException {
        this.allSidekicks.put(sidekick.getName(), sidekick);
    }

    public Sidekick removeSidekick(String sidekickName) throws UnknownSidekickException {
        Sidekick sidekick = this.allSidekicks.remove(sidekickName);
        if (sidekick == null) {
            throw new UnknownSidekickException(sidekickName);
        }
        return sidekick;
    }

    private static String getInitalJson() {
        return "[{\"superHeroSidekicked\":{\"name\":\"Iron Man\"},\"name\":\"James Rhodes\"},{\"superHeroSidekicked\":{\"name\":\"Spider Man\"},\"name\":\"Andy Maguire\"}]";
    }
}

