/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.graphql.tck.apps.superhero.api;

import jakarta.inject.Inject;
import jakarta.json.bind.annotation.JsonbDateFormat;
import jakarta.json.bind.annotation.JsonbNumberFormat;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.microprofile.graphql.DateFormat;
import org.eclipse.microprofile.graphql.DefaultValue;
import org.eclipse.microprofile.graphql.Description;
import org.eclipse.microprofile.graphql.GraphQLApi;
import org.eclipse.microprofile.graphql.GraphQLException;
import org.eclipse.microprofile.graphql.Mutation;
import org.eclipse.microprofile.graphql.Name;
import org.eclipse.microprofile.graphql.NumberFormat;
import org.eclipse.microprofile.graphql.Query;
import org.eclipse.microprofile.graphql.Source;
import org.eclipse.microprofile.graphql.tck.apps.superhero.api.CsvIOException;
import org.eclipse.microprofile.graphql.tck.apps.superhero.api.FlawNotFoundException;
import org.eclipse.microprofile.graphql.tck.apps.superhero.api.SuperHeroLookupException;
import org.eclipse.microprofile.graphql.tck.apps.superhero.api.WeaknessNotFoundException;
import org.eclipse.microprofile.graphql.tck.apps.superhero.db.DuplicateSuperHeroException;
import org.eclipse.microprofile.graphql.tck.apps.superhero.db.HeroDatabase;
import org.eclipse.microprofile.graphql.tck.apps.superhero.db.HeroLocator;
import org.eclipse.microprofile.graphql.tck.apps.superhero.db.SidekickDatabase;
import org.eclipse.microprofile.graphql.tck.apps.superhero.db.UnknownHeroException;
import org.eclipse.microprofile.graphql.tck.apps.superhero.db.UnknownSidekickException;
import org.eclipse.microprofile.graphql.tck.apps.superhero.db.UnknownTeamException;
import org.eclipse.microprofile.graphql.tck.apps.superhero.model.Character;
import org.eclipse.microprofile.graphql.tck.apps.superhero.model.Item;
import org.eclipse.microprofile.graphql.tck.apps.superhero.model.Sidekick;
import org.eclipse.microprofile.graphql.tck.apps.superhero.model.SuperHero;
import org.eclipse.microprofile.graphql.tck.apps.superhero.model.Team;
import org.eclipse.microprofile.graphql.tck.apps.superhero.model.Token;
import org.eclipse.microprofile.graphql.tck.apps.superhero.model.UnknownCharacterException;

@GraphQLApi
public class HeroFinder {
    private static final Logger LOG = Logger.getLogger(HeroFinder.class.getName());
    @Inject
    private HeroDatabase heroDB;
    @Inject
    private SidekickDatabase sidekickDB;
    @Inject
    private HeroLocator heroLocator;

    @Query
    public Character character(@Name(value="name") String name) throws UnknownCharacterException {
        LOG.log(Level.INFO, "character invoked [{0}]", name);
        try {
            SuperHero superHero = this.heroDB.getHero(name);
            return superHero;
        }
        catch (UnknownHeroException e) {
            try {
                Sidekick sidekick = this.sidekickDB.getSidekick(name);
                return sidekick;
            }
            catch (UnknownSidekickException ex) {
                throw new UnknownCharacterException(name);
            }
        }
    }

    @Query
    public SuperHero superHero(@Name(value="name") @Description(value="Super hero name, not real name") String name) throws UnknownHeroException {
        LOG.log(Level.INFO, "superHero invoked [{0}]", name);
        return Optional.ofNullable(this.heroDB.getHero(name)).orElseThrow(() -> new UnknownHeroException(name));
    }

    @Query
    @Description(value="Testing the blacklist of Checked Exceptions")
    public SuperHero exportToFile(@Name(value="name") @Description(value="Super hero name, not real name") String name) throws IOException {
        LOG.log(Level.INFO, "exportToFile invoked [{0}]", name);
        throw new IOException("No you can not do this.");
    }

    @Query
    @Description(value="Testing the blacklist of transitive Checked Exceptions")
    public SuperHero exportToCSVFile(@Name(value="name") @Description(value="Super hero name, not real name") String name) throws CsvIOException {
        LOG.log(Level.INFO, "exportToCSVFile invoked [{0}]", name);
        throw new CsvIOException("No you can not do this.");
    }

    @Query
    @Description(value="Testing the default blacklist for Runtime Exceptions")
    public SuperHero villian(@Name(value="name") @Description(value="Super hero name, not real name") String name) {
        LOG.log(Level.INFO, "villian invoked [{0}]", name);
        throw new RuntimeException("SuperHero can not be a villian");
    }

    @Query
    @Description(value="Testing the whitelist for Runtime Exceptions")
    public SuperHero weakness(@Name(value="name") @Description(value="Super hero name, not real name") String name) {
        LOG.log(Level.INFO, "weakness invoked [{0}]", name);
        throw new WeaknessNotFoundException("Superhero has no weakness");
    }

    @Query
    @Description(value="Testing the whitelist for transitive Runtime Exceptions")
    public SuperHero findFlaw(@Name(value="name") @Description(value="Super hero name, not real name") String name) {
        LOG.log(Level.INFO, "findFlaw invoked [{0}]", name);
        throw new FlawNotFoundException("Superhero has no flaw");
    }

    @Query
    @Description(value="Testing Errors, as in Java Error")
    public SuperHero wreakHavoc(@Name(value="name") @Description(value="Super hero name, not real name") String name) {
        LOG.log(Level.INFO, "wreakHavoc invoked [{0}]", name);
        throw new OutOfMemoryError("a SuperHero has used all the memory");
    }

    @Query
    @Description(value="List all super heroes in the database")
    public Collection<SuperHero> allHeroes() {
        LOG.info("allHeroes invoked");
        return this.heroDB.getAllHeroes();
    }

    @Query
    public Collection<SuperHero> allHeroesIn(@DefaultValue(value="New York, NY") @Name(value="city") String city) {
        LOG.log(Level.INFO, "allHeroesIn invoked [{0}]", city);
        return this.allHeroesByFilter(hero -> city.equals(hero.getPrimaryLocation()));
    }

    @Query
    public Collection<SuperHero> allHeroesWithPower(@Name(value="power") String power) {
        LOG.log(Level.INFO, "allHeroesWithPower invoked [{0}]", power);
        return this.allHeroesByFilter(hero -> hero.getSuperPowers().contains(power));
    }

    @Query
    public Collection<SuperHero> allHeroesInTeam(@Name(value="team") String teamName) throws UnknownTeamException {
        LOG.log(Level.INFO, "allHeroesInTeam invoked [{0}]", teamName);
        return this.heroDB.getTeam(teamName).getMembers();
    }

    @Query
    public Team getTeam(@Name(value="team") String teamName) throws UnknownTeamException {
        LOG.log(Level.INFO, "getTeam invoked [{0}]", teamName);
        return this.heroDB.getTeam(teamName);
    }

    @Query
    public Collection<Team> allTeams() {
        LOG.info("allTeams invoked");
        return this.heroDB.getAllTeams();
    }

    @Mutation
    public SuperHero createNewHero(@Name(value="hero") SuperHero newHero) throws DuplicateSuperHeroException, UnknownHeroException {
        LOG.log(Level.INFO, "createNewHero invoked [{0}]", newHero);
        this.heroDB.addHero(newHero);
        return this.heroDB.getHero(newHero.getName());
    }

    @Mutation
    public Collection<SuperHero> createNewHeroes(@Name(value="heroes") List<SuperHero> newHeroes) throws DuplicateSuperHeroException, UnknownHeroException {
        LOG.log(Level.INFO, "createNewHeroes invoked [{0}]", newHeroes);
        this.heroDB.addHeroes(newHeroes);
        return newHeroes;
    }

    @Mutation
    public SuperHero[] createNewHeroesWithArray(@Name(value="heroes") SuperHero[] newHeroes) throws DuplicateSuperHeroException, UnknownHeroException {
        LOG.log(Level.INFO, "createNewHeroesWithArray invoked [{0}]", newHeroes);
        List<SuperHero> asList = Arrays.asList(newHeroes);
        this.heroDB.addHeroes(asList);
        return newHeroes;
    }

    @Mutation
    @Description(value="Adds a hero to the specified team and returns the updated team.")
    public Team addHeroToTeam(@Name(value="hero") String heroName, @Name(value="team") String teamName) throws UnknownTeamException, UnknownHeroException {
        LOG.log(Level.INFO, "addHeroToTeam invoked [{0}],[{1}]", new Object[]{heroName, teamName});
        return this.heroDB.getTeam(teamName).addMembers(this.heroDB.getHero(heroName));
    }

    @Mutation
    @Description(value="Removes a hero to the specified team and returns the updated team.")
    public Team removeHeroFromTeam(@Name(value="hero") String heroName, @Name(value="team") String teamName) throws UnknownTeamException, UnknownHeroException {
        LOG.log(Level.INFO, "removeHeroFromTeam invoked [{0}],[{1}]", new Object[]{heroName, teamName});
        return this.heroDB.getTeam(teamName).removeMembers(this.heroDB.getHero(heroName));
    }

    @Mutation
    @Description(value="Removes a hero... permanently...")
    public Collection<SuperHero> removeHero(@Name(value="hero") String heroName) throws UnknownHeroException {
        LOG.log(Level.INFO, "removeHero invoked [{0}]", heroName);
        if (this.heroDB.removeHero(heroName) == null) {
            throw new UnknownHeroException(heroName);
        }
        return this.allHeroes();
    }

    @Mutation
    @Description(value="Gives a hero new equipment")
    public SuperHero provisionHero(@Name(value="hero") String heroName, @DefaultValue(value="{   \"id\": 1000,   \"name\": \"Cape\",   \"powerLevel\": 3,   \"height\": 1.2,   \"weight\": 0.3,   \"supernatural\": false,   \"dateCreated\": \"19 February 1900 at 12:00 in Africa/Johannesburg\",   \"dateLastUsed\": \"29 Jan 2020 at 09:45 in zone +0200\"}") @Name(value="item") Item item) throws UnknownHeroException {
        LOG.log(Level.INFO, "provisionHero invoked [{0}],[{1}]", new Object[]{heroName, item});
        SuperHero hero = this.heroDB.getHero(heroName);
        if (hero == null) {
            throw new UnknownHeroException(heroName);
        }
        hero.getEquipment().add(item);
        return hero;
    }

    @Mutation
    @Description(value="Removes equipment from a hero")
    public SuperHero removeItemFromHero(@Name(value="hero") String heroName, @Name(value="itemID") long itemID) throws UnknownHeroException {
        LOG.log(Level.INFO, "removeItemFromHero invoked [{0}],[{1}]", new Object[]{heroName, itemID});
        SuperHero hero = this.heroDB.getHero(heroName);
        if (hero == null) {
            throw new UnknownHeroException(heroName);
        }
        hero.getEquipment().removeIf(i -> i.getId() == itemID);
        return hero;
    }

    @Mutation
    @Description(value="Update an item's powerLevel")
    public Item updateItemPowerLevel(@Name(value="itemID") long itemID, @DefaultValue(value="5") @Name(value="powerLevel") int newLevel) {
        LOG.log(Level.INFO, "updateItemPowerLevel invoked [{0}],[{1}]", new Object[]{itemID, newLevel});
        Item item = null;
        for (SuperHero hero : this.allHeroes()) {
            for (Item i : hero.getEquipment()) {
                if (i.getId() != itemID) continue;
                item = i;
                item.setPowerLevel(newLevel);
            }
        }
        return item;
    }

    @Mutation
    @Description(value="Update a hero's bank account")
    public SuperHero updateBankBalance(@Name(value="name") String name, @Name(value="bankBalance") double bankBalance) throws UnknownHeroException {
        LOG.log(Level.INFO, "updateBankBalance invoked [{0}],[{1}]", new Object[]{name, bankBalance});
        SuperHero superHero = this.heroDB.getHero(name);
        if (superHero != null) {
            superHero.setBankBalance(bankBalance);
        }
        return superHero;
    }

    @Mutation
    @Description(value="Update a hero's bank account in US Dollar")
    public SuperHero updateBankBalanceInUS(@Name(value="name") String name, @JsonbNumberFormat(value="\u00a4 ###,###.##", locale="en-US") @Name(value="bankBalance") Double bankBalance) throws UnknownHeroException {
        LOG.log(Level.INFO, "updateBankBalance invoked [{0}],[{1}]", new Object[]{name, bankBalance});
        SuperHero superHero = this.heroDB.getHero(name);
        if (superHero != null) {
            superHero.setBankBalance(bankBalance);
        }
        return superHero;
    }

    @Mutation
    @Description(value="Update a hero's favourite drink size")
    public SuperHero favouriteDrinkSize(@Name(value="name") String name, @Name(value="size") float size) throws UnknownHeroException {
        LOG.log(Level.INFO, "favouriteDrinkSize invoked [{0}],[{1}]", new Object[]{name, Float.valueOf(size)});
        SuperHero superHero = this.heroDB.getHero(name);
        if (superHero != null) {
            superHero.setFavouriteDrinkSize(Float.valueOf(size));
        }
        return superHero;
    }

    @Mutation
    @Description(value="Update a hero's favourite drink size in milliliters")
    public SuperHero favouriteDrinkSizeInML(@Name(value="name") String name, @JsonbNumberFormat(value="000.00 'kl'") @NumberFormat(value="###.## 'ml'", locale="en-GB") @Name(value="size") @NumberFormat(value="###.## 'ml'", locale="en-GB") Float size) throws UnknownHeroException {
        LOG.log(Level.INFO, "favouriteDrinkSizeInML invoked [{0}],[{1}]", new Object[]{name, size});
        SuperHero superHero = this.heroDB.getHero(name);
        if (superHero != null) {
            superHero.setFavouriteDrinkSize(size);
        }
        return superHero;
    }

    @Mutation
    @Description(value="Update a hero's net worth")
    public SuperHero updateNetWorth(@Name(value="name") String name, @Name(value="netWorth") BigDecimal netWorth) throws UnknownHeroException {
        LOG.log(Level.INFO, "updateNetWorth invoked [{0}],[{1}]", new Object[]{name, netWorth});
        SuperHero superHero = this.heroDB.getHero(name);
        if (superHero != null) {
            superHero.setNetWorth(netWorth);
        }
        return superHero;
    }

    @Mutation
    @Description(value="Update a hero's back account in USD")
    public SuperHero updateNetWorthInUSD(@Name(value="name") String name, @JsonbNumberFormat(value="\u00a4 000.00", locale="en-US") @Name(value="netWorth") BigDecimal netWorth) throws UnknownHeroException {
        LOG.log(Level.INFO, "updateBankBalance invoked [{0}],[{1}]", new Object[]{name, netWorth});
        SuperHero superHero = this.heroDB.getHero(name);
        if (superHero != null) {
            superHero.setNetWorth(netWorth);
        }
        return superHero;
    }

    @Mutation
    @Description(value="All the places this hero has been")
    public SuperHero beenThere(@Name(value="name") String name, @Name(value="places") Set<String> places) throws UnknownHeroException {
        LOG.log(Level.INFO, "beenThere invoked [{0}],[{1}]", new Object[]{name, places});
        SuperHero superHero = this.heroDB.getHero(name);
        if (superHero != null) {
            superHero.setBeenThere(places);
        }
        return superHero;
    }

    @Mutation
    @Description(value="Log the last place the hero was seen")
    public SuperHero logLocation(@Name(value="name") String name, @Name(value="coordinates") LinkedList<BigDecimal> coordinates) throws UnknownHeroException {
        LOG.log(Level.INFO, "logLocation invoked [{0}],[{1}]", new Object[]{name, coordinates});
        SuperHero superHero = this.heroDB.getHero(name);
        if (superHero != null) {
            superHero.setLastKnownCoordinates(coordinates);
        }
        return superHero;
    }

    @Mutation
    @Description(value="Log the last place the hero was seen (Long Lat)")
    public SuperHero logLocationLongLat(@Name(value="name") String name, @JsonbNumberFormat(value="00.0000000 longlat", locale="en-GB") @Name(value="coordinates") List<BigDecimal> coordinates) throws UnknownHeroException {
        LOG.log(Level.INFO, "logLocationLongLat invoked [{0}],[{1}]", new Object[]{name, coordinates});
        SuperHero superHero = this.heroDB.getHero(name);
        if (superHero != null) {
            superHero.setLastKnownCoordinates(coordinates);
        }
        return superHero;
    }

    @Mutation
    @Description(value="Log the last few places the hero was seen")
    public SuperHero trackHero(@Name(value="name") String name, @Name(value="coordinates") List<List<BigDecimal>> coordinates) throws UnknownHeroException {
        LOG.log(Level.INFO, "trackHero invoked [{0}],[{1}]", new Object[]{name, coordinates});
        SuperHero superHero = this.heroDB.getHero(name);
        if (superHero != null) {
            superHero.setTrack(coordinates);
        }
        return superHero;
    }

    @Mutation
    @Description(value="Log the last few places the hero was seen (Long Lat)")
    public SuperHero trackHeroLongLat(@Name(value="name") String name, @JsonbNumberFormat(value="00.0000000 'latlong'") @Name(value="coordinates") List<List<@NumberFormat(value="00.0000000 longlat", locale="en-GB") BigDecimal>> coordinates) throws UnknownHeroException {
        LOG.log(Level.INFO, "trackHeroLongLat invoked [{0}],[{1}]", new Object[]{name, coordinates});
        SuperHero superHero = this.heroDB.getHero(name);
        if (superHero != null) {
            superHero.setTrack(coordinates);
        }
        return superHero;
    }

    @Mutation
    @Description(value="Log the last place the hero was seen (using an array)")
    public SuperHero logLocationWithArray(@Name(value="name") String name, @Name(value="coordinates") BigDecimal[] coordinates) throws UnknownHeroException {
        LOG.log(Level.INFO, "logLocationWithArray invoked [{0}],[{1}]", new Object[]{name, coordinates});
        SuperHero superHero = this.heroDB.getHero(name);
        if (superHero != null) {
            superHero.setLastKnownCoordinates(Arrays.asList(coordinates));
        }
        return superHero;
    }

    @Mutation
    @Description(value="Log the last place the hero was seen (Long Lat) using an array")
    public SuperHero logLocationLongLatWithArray(@Name(value="name") String name, @JsonbNumberFormat(value="00.0000000 longlat", locale="en-GB") @Name(value="coordinates") BigDecimal[] coordinates) throws UnknownHeroException {
        LOG.log(Level.INFO, "logLocationLongLatWithArray invoked [{0}],[{1}]", new Object[]{name, coordinates});
        SuperHero superHero = this.heroDB.getHero(name);
        if (superHero != null) {
            superHero.setLastKnownCoordinates(Arrays.asList(coordinates));
        }
        return superHero;
    }

    @Mutation
    @Description(value="Update an item's powerLevel in percentage")
    public Item updateItemPowerLevelPercentage(@Name(value="itemID") long itemID, @JsonbNumberFormat(value="##'%'") @Name(value="powerLevel") int newLevel) {
        LOG.log(Level.INFO, "updateItemPowerLevelPercentage invoked [{0}],[{1}]", new Object[]{itemID, newLevel});
        Item item = null;
        for (SuperHero hero : this.allHeroes()) {
            for (Item i : hero.getEquipment()) {
                if (i.getId() != itemID) continue;
                item = i;
                item.setPowerLevel(newLevel / 20);
            }
        }
        return item;
    }

    @Mutation
    @Description(value="Check in a superhero")
    public SuperHero checkIn(@Name(value="name") String name, @Name(value="date") LocalDate localDate) throws UnknownHeroException {
        LOG.log(Level.INFO, "checkIn invoked [{0}],[{1}]", new Object[]{name, localDate});
        SuperHero superHero = this.heroDB.getHero(name);
        if (superHero != null) {
            superHero.setDateOfLastCheckin(localDate);
        }
        return superHero;
    }

    @Mutation
    @Description(value="Check in a superhero")
    public SuperHero checkInWithCorrectDateFormat(@Name(value="name") String name, @JsonbDateFormat(value="yy dd MM") @DateFormat(value="MM/dd/yyyy") @Name(value="date") @DateFormat(value="MM/dd/yyyy") LocalDate localDate) throws UnknownHeroException {
        LOG.log(Level.INFO, "checkInWithCorrectDateFormat invoked [{0}],[{1}]", new Object[]{name, localDate});
        SuperHero superHero = this.heroDB.getHero(name);
        if (superHero != null) {
            superHero.setDateOfLastCheckin(localDate);
        }
        return superHero;
    }

    @Mutation
    @Description(value="Set all the important dates for a certain hero")
    public SuperHero importantDates(@Name(value="name") String name, @Name(value="dates") List<LocalDate> localDates) throws UnknownHeroException {
        LOG.log(Level.INFO, "importantDates invoked [{0}],[{1}]", new Object[]{name, localDates});
        SuperHero superHero = this.heroDB.getHero(name);
        if (superHero != null) {
            superHero.setImportantDates(localDates);
        }
        return superHero;
    }

    @Mutation
    @Description(value="Set all the important dates (US format) for a certain hero")
    public SuperHero importantDatesUS(@Name(value="name") String name, @JsonbDateFormat(value="yy dd MM") @Name(value="dates") List<@DateFormat(value="MM/dd/yyyy") LocalDate> localDates) throws UnknownHeroException {
        LOG.log(Level.INFO, "importantDatesUS invoked [{0}],[{1}]", new Object[]{name, localDates});
        SuperHero superHero = this.heroDB.getHero(name);
        if (superHero != null) {
            superHero.setImportantDates(localDates);
        }
        return superHero;
    }

    @Mutation
    @Description(value="Set the time a hero started patrolling")
    public SuperHero startPatrolling(@Name(value="name") String name, @Name(value="time") LocalTime localTime) throws UnknownHeroException {
        LOG.log(Level.INFO, "startPatrolling invoked [{0}],[{1}]", new Object[]{name, localTime});
        SuperHero superHero = this.heroDB.getHero(name);
        if (superHero != null) {
            superHero.setPatrolStartTime(localTime);
        }
        return superHero;
    }

    @Mutation
    @Description(value="Set the time a hero started patrolling (using formatted time)")
    public SuperHero startPatrollingWithCorrectDateFormat(@Name(value="name") String name, @JsonbDateFormat(value="HH:mm") @Name(value="time") LocalTime localTime) throws UnknownHeroException {
        LOG.log(Level.INFO, "startPatrollingWithCorrectDateFormat invoked [{0}],[{1}]", new Object[]{name, localTime});
        SuperHero superHero = this.heroDB.getHero(name);
        if (superHero != null) {
            superHero.setPatrolStartTime(localTime);
        }
        return superHero;
    }

    @Mutation
    @Description(value="Start a battle")
    public SuperHero battle(@Name(value="name") String name, @Name(value="dateTime") LocalDateTime localDateTime) throws UnknownHeroException {
        LOG.log(Level.INFO, "battle invoked [{0}],[{1}]", new Object[]{name, localDateTime});
        SuperHero superHero = this.heroDB.getHero(name);
        if (superHero != null) {
            superHero.setTimeOfLastBattle(localDateTime);
        }
        return superHero;
    }

    @Mutation
    @Description(value="Start a battle")
    public SuperHero battleWithCorrectDateFormat(@Name(value="name") String name, @JsonbDateFormat(value="HH:mm:ss dd-MM-yyyy") @Name(value="dateTime") LocalDateTime localDateTime) throws UnknownHeroException {
        LOG.log(Level.INFO, "battleWithCorrectDateFormat invoked [{0}],[{1}]", new Object[]{name, localDateTime});
        SuperHero superHero = this.heroDB.getHero(name);
        if (superHero != null) {
            superHero.setTimeOfLastBattle(localDateTime);
        }
        return superHero;
    }

    @Mutation
    @Description(value="Set the ID Number for a hero")
    public SuperHero idNumber(@Name(value="name") String name, @Name(value="id") Long idNumber) throws UnknownHeroException {
        LOG.log(Level.INFO, "idNumber invoked [{0}],[{1}]", new Object[]{name, idNumber});
        SuperHero superHero = this.heroDB.getHero(name);
        if (superHero != null) {
            superHero.setIdNumber(idNumber);
        }
        return superHero;
    }

    @Mutation
    @Description(value="Set the ID Number for a hero")
    public SuperHero idNumberWithCorrectFormat(@Name(value="name") String name, @JsonbNumberFormat(value="ID-00000000") @Name(value="id") Long idNumber) throws UnknownHeroException {
        LOG.log(Level.INFO, "idNumberWithCorrectFormat invoked [{0}],[{1}]", new Object[]{name, idNumber});
        SuperHero superHero = this.heroDB.getHero(name);
        if (superHero != null) {
            superHero.setIdNumber(idNumber);
        }
        return superHero;
    }

    @Query
    public String getCurrentLocation(@Name(value="superHero") @Source SuperHero hero) throws GraphQLException {
        LOG.log(Level.INFO, "currentLocation invoked [{0}]", hero);
        String heroName = hero.getName();
        return this.heroLocator.getHeroLocation(heroName).orElseThrow(() -> new GraphQLException("Cannot find location for " + heroName, GraphQLException.ExceptionType.DataFetchingException));
    }

    @Name(value="secretToken")
    public Token generateSecretToken(@Source SuperHero hero, @DefaultValue(value="true") @Name(value="maskFirstPart") boolean maskFirstPart) throws GraphQLException {
        LOG.log(Level.INFO, "generateSecretToken invoked [{0}],[{1}]", new Object[]{hero, maskFirstPart});
        String uuid = UUID.randomUUID().toString();
        if (maskFirstPart) {
            return new Token(uuid.substring(0, uuid.length() - 4).replaceAll("[A-Za-z0-9]", "*") + uuid.substring(uuid.length() - 4, uuid.length()));
        }
        return new Token(uuid);
    }

    @Mutation(value="setRivalTeam")
    public Team setRivalTeam(@Name(value="teamName") String teamName, @Name(value="rivalTeam") Team rivalTeam) throws UnknownTeamException {
        LOG.log(Level.INFO, "setRivalTeam invoked [{0}],[{1}]", new Object[]{teamName, rivalTeam});
        Team team = this.heroDB.getTeam(teamName);
        team.setRivalTeam(rivalTeam);
        return team;
    }

    @Query
    public Collection<SuperHero> allHeroesWithError() throws GraphQLException {
        LOG.info("allHeroesWithError invoked");
        ArrayList<SuperHero> partialHeroes = new ArrayList<SuperHero>();
        for (SuperHero hero : this.heroDB.getAllHeroes()) {
            if ("Starlord".equals(hero.getName())) {
                partialHeroes.add(null);
                continue;
            }
            partialHeroes.add(hero);
        }
        throw new GraphQLException("Failed to find one or more heroes", partialHeroes);
    }

    @Query
    public Collection<SuperHero> allHeroesWithSpecificError() throws SuperHeroLookupException {
        LOG.info("allHeroesWithSpecificError invoked");
        ArrayList<SuperHero> partialHeroes = new ArrayList<SuperHero>();
        for (SuperHero hero : this.heroDB.getAllHeroes()) {
            if ("Spider Man".equals(hero.getName())) continue;
            partialHeroes.add(hero);
        }
        throw new SuperHeroLookupException("Failed to find one or more heroes", partialHeroes);
    }

    @Query
    public Item getItemById(@Name(value="id") long id) {
        LOG.log(Level.INFO, "getItemById invoked [{0}]", id);
        for (SuperHero hero : this.allHeroes()) {
            for (Item item : hero.getEquipment()) {
                if (id != item.getId()) continue;
                return item;
            }
        }
        return null;
    }

    @Mutation
    public Team createNewTeam(@Name(value="newTeam") Team newTeam) {
        LOG.log(Level.INFO, "createNewTeam invoked [{0}]", newTeam);
        List<SuperHero> members = newTeam.getMembers();
        Team team = this.heroDB.createNewTeam(newTeam.getName(), new SuperHero[0]);
        if (members != null && members.size() > 0) {
            team.setMembers(members);
        }
        team.setRivalTeam(newTeam.getRivalTeam());
        return team;
    }

    @Mutation
    public Team removeTeam(@Name(value="teamName") String teamName) throws UnknownTeamException {
        LOG.log(Level.INFO, "removeTeam invoked [{0}]", teamName);
        return this.heroDB.removeTeam(teamName);
    }

    private Collection<SuperHero> allHeroesByFilter(Predicate<SuperHero> predicate) {
        return this.heroDB.getAllHeroes().stream().filter(predicate).collect(Collectors.toCollection(ArrayList::new));
    }
}

