/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.jwt.tck.container.jaxrs;

import java.util.Optional;
import java.util.Set;
import javax.annotation.security.RolesAllowed;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.eclipse.microprofile.jwt.Claim;
import org.eclipse.microprofile.jwt.ClaimValue;
import org.eclipse.microprofile.jwt.Claims;

@Path(value="/endp")
@RolesAllowed(value={"Echoer", "Tester"})
@RequestScoped
public class ClaimValueInjectionEndpoint {
    @Inject
    @Claim(value="raw_token")
    private ClaimValue<String> rawToken;
    @Inject
    @Claim(value="iss")
    private ClaimValue<String> issuer;
    @Inject
    @Claim(value="jti")
    private ClaimValue<String> jti;
    @Inject
    @Claim(value="aud")
    private ClaimValue<Set<String>> aud;
    @Inject
    @Claim(value="iat")
    private ClaimValue<Long> issuedAt;
    @Inject
    @Claim(value="sub")
    private ClaimValue<Optional<String>> optSubject;
    @Inject
    @Claim(value="auth_time")
    private ClaimValue<Optional<Long>> authTime;
    @Inject
    @Claim(value="custom-missing")
    private ClaimValue<Optional<Long>> custom;
    @Inject
    @Claim(value="customString")
    private ClaimValue<String> customString;
    @Inject
    @Claim(value="customInteger")
    private ClaimValue<JsonNumber> customInteger;
    @Inject
    @Claim(value="customDouble")
    private ClaimValue<JsonNumber> customDouble;
    @Inject
    @Claim(value="customBoolean")
    private ClaimValue<Boolean> customBoolean;
    @Inject
    @Claim(standard=Claims.raw_token)
    private ClaimValue<String> rawTokenStandard;
    @Inject
    @Claim(standard=Claims.iss)
    private ClaimValue<String> issuerStandard;
    @Inject
    @Claim(standard=Claims.jti)
    private ClaimValue<String> jtiStandard;
    @Inject
    @Claim(standard=Claims.aud)
    private ClaimValue<Set<String>> audStandard;
    @Inject
    @Claim(standard=Claims.iat)
    private ClaimValue<Long> issuedAtStandard;
    @Inject
    @Claim(standard=Claims.sub)
    private ClaimValue<String> subStandard;
    @Inject
    @Claim(standard=Claims.auth_time)
    private ClaimValue<Long> authTimeStandard;

    @GET
    @Path(value="/verifyInjectedIssuer")
    @Produces(value={"application/json"})
    public JsonObject verifyInjectedIssuer(@QueryParam(value="iss") String iss) {
        String msg;
        boolean pass = false;
        String issValue = (String)this.issuer.getValue();
        if (issValue == null || issValue.length() == 0) {
            msg = Claims.iss.name() + "value is null or empty, FAIL";
        } else if (issValue.equals(iss)) {
            msg = Claims.iss.name() + " PASS";
            pass = true;
        } else {
            msg = String.format("%s: %s != %s", Claims.iss.name(), issValue, iss);
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }

    @GET
    @Path(value="/verifyInjectedIssuerStandard")
    @Produces(value={"application/json"})
    public JsonObject verifyInjectedIssuerStandard(@QueryParam(value="iss") String iss) {
        String msg;
        boolean pass = false;
        String issValue = (String)this.issuerStandard.getValue();
        if (issValue == null || issValue.length() == 0) {
            msg = Claims.iss.name() + "value is null or empty, FAIL";
        } else if (issValue.equals(iss)) {
            msg = Claims.iss.name() + " PASS";
            pass = true;
        } else {
            msg = String.format("%s: %s != %s", Claims.iss.name(), issValue, iss);
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }

    @GET
    @Path(value="/verifyInjectedRawToken")
    @Produces(value={"application/json"})
    public JsonObject verifyInjectedRawToken(@QueryParam(value="raw_token") String rt) {
        String msg;
        boolean pass = false;
        String rawTokenValue = (String)this.rawToken.getValue();
        if (rawTokenValue == null || rawTokenValue.length() == 0) {
            msg = Claims.raw_token.name() + "value is null or empty, FAIL";
        } else if (rawTokenValue.equals(rt)) {
            msg = Claims.raw_token.name() + " PASS";
            pass = true;
        } else {
            msg = String.format("%s: %s != %s", Claims.raw_token.name(), rawTokenValue, rt);
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }

    @GET
    @Path(value="/verifyInjectedRawTokenStandard")
    @Produces(value={"application/json"})
    public JsonObject verifyInjectedRawTokenStandard(@QueryParam(value="raw_token") String rt) {
        String msg;
        boolean pass = false;
        String rawTokenValue = (String)this.rawTokenStandard.getValue();
        if (rawTokenValue == null || rawTokenValue.length() == 0) {
            msg = Claims.raw_token.name() + "value is null or empty, FAIL";
        } else if (rawTokenValue.equals(rt)) {
            msg = Claims.raw_token.name() + " PASS";
            pass = true;
        } else {
            msg = String.format("%s: %s != %s", Claims.raw_token.name(), rawTokenValue, rt);
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }

    @GET
    @Path(value="/verifyInjectedJTI")
    @Produces(value={"application/json"})
    public JsonObject verifyInjectedJTI(@QueryParam(value="jti") String jwtID) {
        String msg;
        boolean pass = false;
        String jtiValue = (String)this.jti.getValue();
        if (jtiValue == null || jtiValue.length() == 0) {
            msg = Claims.jti.name() + "value is null or empty, FAIL";
        } else if (jtiValue.equals(jwtID)) {
            msg = Claims.jti.name() + " PASS";
            pass = true;
        } else {
            msg = String.format("%s: %s != %s", Claims.jti.name(), jtiValue, jwtID);
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }

    @GET
    @Path(value="/verifyInjectedJTIStandard")
    @Produces(value={"application/json"})
    public JsonObject verifyInjectedJTIStandard(@QueryParam(value="jti") String jwtID) {
        String msg;
        boolean pass = false;
        String jtiValue = (String)this.jtiStandard.getValue();
        if (jtiValue == null || jtiValue.length() == 0) {
            msg = Claims.jti.name() + "value is null or empty, FAIL";
        } else if (jtiValue.equals(jwtID)) {
            msg = Claims.jti.name() + " PASS";
            pass = true;
        } else {
            msg = String.format("%s: %s != %s", Claims.jti.name(), jtiValue, jwtID);
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }

    @GET
    @Path(value="/verifyInjectedAudience")
    @Produces(value={"application/json"})
    public JsonObject verifyInjectedAudience(@QueryParam(value="aud") String audience) {
        String msg;
        boolean pass = false;
        Set audValue = (Set)this.aud.getValue();
        if (audValue == null || audValue.size() == 0) {
            msg = Claims.aud.name() + "value is null or empty, FAIL";
        } else if (audValue.contains(audience)) {
            msg = Claims.aud.name() + " PASS";
            pass = true;
        } else {
            msg = String.format("%s: %s != %s", Claims.aud.name(), audValue, audience);
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }

    @GET
    @Path(value="/verifyInjectedAudienceStandard")
    @Produces(value={"application/json"})
    public JsonObject verifyInjectedAudienceStandard(@QueryParam(value="aud") String audience) {
        String msg;
        boolean pass = false;
        Set audValue = (Set)this.audStandard.getValue();
        if (audValue == null || audValue.size() == 0) {
            msg = Claims.aud.name() + "value is null or empty, FAIL";
        } else if (audValue.contains(audience)) {
            msg = Claims.aud.name() + " PASS";
            pass = true;
        } else {
            msg = String.format("%s: %s != %s", Claims.aud.name(), audValue, audience);
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }

    @GET
    @Path(value="/verifyInjectedIssuedAt")
    @Produces(value={"application/json"})
    public JsonObject verifyInjectedIssuedAt(@QueryParam(value="iat") Long iat) {
        String msg;
        boolean pass = false;
        Long iatValue = (Long)this.issuedAt.getValue();
        if (iatValue == null || iatValue.intValue() == 0) {
            msg = Claims.iat.name() + "value is null or empty, FAIL";
        } else if (iatValue.equals(iat)) {
            msg = Claims.iat.name() + " PASS";
            pass = true;
        } else {
            msg = String.format("%s: %s != %s", Claims.iat.name(), iatValue, iat);
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }

    @GET
    @Path(value="/verifyInjectedIssuedAtStandard")
    @Produces(value={"application/json"})
    public JsonObject verifyInjectedIssuedAtStandard(@QueryParam(value="iat") Long iat) {
        String msg;
        boolean pass = false;
        Long iatValue = (Long)this.issuedAtStandard.getValue();
        if (iatValue == null || iatValue.intValue() == 0) {
            msg = Claims.iat.name() + "value is null or empty, FAIL";
        } else if (iatValue.equals(iat)) {
            msg = Claims.iat.name() + " PASS";
            pass = true;
        } else {
            msg = String.format("%s: %s != %s", Claims.iat.name(), iatValue, iat);
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }

    @GET
    @Path(value="/verifyInjectedOptionalSubject")
    @Produces(value={"application/json"})
    public JsonObject verifyInjectedOptionalSubject(@QueryParam(value="sub") String subject) {
        String msg;
        boolean pass = false;
        Optional optSubValue = (Optional)this.optSubject.getValue();
        if (optSubValue == null || !optSubValue.isPresent()) {
            msg = Claims.sub.name() + " value is null or missing, FAIL";
        } else if (((String)optSubValue.get()).equals(subject)) {
            msg = Claims.sub.name() + " PASS";
            pass = true;
        } else {
            msg = String.format("%s: %s != %s", Claims.sub.name(), optSubValue, subject);
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }

    @GET
    @Path(value="/verifyInjectedSubjectStandard")
    @Produces(value={"application/json"})
    public JsonObject verifyInjectedSubjectStandard(@QueryParam(value="sub") String subject) {
        String msg;
        boolean pass = false;
        String subValue = (String)this.subStandard.getValue();
        if (subValue == null || subValue.length() == 0) {
            msg = Claims.sub.name() + " value is null or missing, FAIL";
        } else if (subValue.equals(subject)) {
            msg = Claims.sub.name() + " PASS";
            pass = true;
        } else {
            msg = String.format("%s: %s != %s", Claims.sub.name(), subValue, subject);
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }

    @GET
    @Path(value="/verifyInjectedOptionalAuthTime")
    @Produces(value={"application/json"})
    public JsonObject verifyInjectedOptionalAuthTime(@QueryParam(value="auth_time") Long authTime) {
        String msg;
        boolean pass = false;
        Optional optAuthTimeValue = (Optional)this.authTime.getValue();
        if (optAuthTimeValue == null || !optAuthTimeValue.isPresent()) {
            msg = Claims.auth_time.name() + " value is null or missing, FAIL";
        } else if (((Long)optAuthTimeValue.get()).equals(authTime)) {
            msg = Claims.auth_time.name() + " PASS";
            pass = true;
        } else {
            msg = String.format("%s: %s != %s", Claims.auth_time.name(), optAuthTimeValue, authTime);
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }

    @GET
    @Path(value="/verifyInjectedAuthTimeStandard")
    @Produces(value={"application/json"})
    public JsonObject verifyInjectedAuthTimeStandard(@QueryParam(value="auth_time") Long authTime) {
        String msg;
        boolean pass = false;
        Long authTimeValue = (Long)this.authTimeStandard.getValue();
        if (authTimeValue == null || authTimeValue == 0L) {
            msg = Claims.auth_time.name() + " value is null or zero, FAIL";
        } else if (authTimeValue.equals(authTime)) {
            msg = Claims.auth_time.name() + " PASS";
            pass = true;
        } else {
            msg = String.format("%s: %s != %s", Claims.auth_time.name(), authTimeValue, authTime);
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }

    @GET
    @Path(value="/verifyInjectedOptionalCustomMissing")
    @Produces(value={"application/json"})
    public JsonObject verifyInjectedOptionalCustomMissing() {
        String msg;
        boolean pass = false;
        Optional customValue = (Optional)this.custom.getValue();
        if (customValue == null) {
            msg = "custom-missing value is null, FAIL";
        } else if (!customValue.isPresent()) {
            msg = "custom-missing PASS";
            pass = true;
        } else {
            msg = String.format("custom: %s != %s", null, customValue.get());
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }

    @GET
    @Path(value="/verifyInjectedCustomString")
    @Produces(value={"application/json"})
    public JsonObject verifyInjectedCustomString(@QueryParam(value="value") String value) {
        String msg;
        boolean pass = false;
        String customValue = (String)this.customString.getValue();
        if (customValue == null || customValue.length() == 0) {
            msg = "customString value is null or empty, FAIL";
        } else if (customValue.equals(value)) {
            msg = "customString PASS";
            pass = true;
        } else {
            msg = String.format("customString: %s != %s", customValue, value);
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }

    @GET
    @Path(value="/verifyInjectedCustomInteger")
    @Produces(value={"application/json"})
    public JsonObject verifyInjectedCustomInteger(@QueryParam(value="value") Long value) {
        String msg;
        Class<?>[] ifaces;
        boolean pass = false;
        Object test = this.customInteger.getValue();
        System.out.printf("+++ verifyInjectedCustomInteger, JsonNumber.class.CL: %s\n", JsonNumber.class.getClassLoader());
        System.out.printf("+++ customInteger.CL: %s\n", test.getClass().getClassLoader());
        for (Class<?> iface : ifaces = test.getClass().getInterfaces()) {
            System.out.printf("%s: %s\n", iface, iface.getClassLoader());
        }
        JsonNumber customValue = (JsonNumber)JsonNumber.class.cast(test);
        if (customValue == null || !customValue.isIntegral()) {
            msg = "customInteger value is null or not integral, FAIL";
        } else if (customValue.longValueExact() == value.longValue()) {
            msg = "customInteger PASS";
            pass = true;
        } else {
            msg = String.format("customInteger: %d != %d", customValue, value);
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }

    @GET
    @Path(value="/verifyInjectedCustomDouble")
    @Produces(value={"application/json"})
    public JsonObject verifyInjectedCustomDouble(@QueryParam(value="value") Double value) {
        String msg;
        boolean pass = false;
        JsonNumber customValue = (JsonNumber)this.customDouble.getValue();
        if (customValue == null) {
            msg = "customDouble value is null, FAIL";
        } else if (Math.abs(customValue.doubleValue() - value) < 1.0E-5) {
            msg = "customDouble PASS";
            pass = true;
        } else {
            msg = String.format("customDouble: %s != %.8f", customValue, value);
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }

    @GET
    @Path(value="/verifyInjectedCustomBoolean")
    @Produces(value={"application/json"})
    public JsonObject verifyInjectedCustomBoolean(@QueryParam(value="value") String value) {
        String msg;
        boolean pass = false;
        Boolean customValue = (Boolean)this.customBoolean.getValue();
        if (customValue == null) {
            msg = "customBoolean value is null, FAIL";
        } else if (customValue == Boolean.valueOf(value)) {
            msg = "customBoolean PASS";
            pass = true;
        } else {
            msg = String.format("customBoolean: %s != %s", customValue, value);
        }
        return Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
    }
}

