/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.jwt.tck.container.jaxrs;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.HashMap;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.jwt.Claims;
import org.eclipse.microprofile.jwt.tck.container.jaxrs.PrimitiveInjectionEndpoint;
import org.eclipse.microprofile.jwt.tck.container.jaxrs.TCKApplication;
import org.eclipse.microprofile.jwt.tck.util.MpJwtTestVersion;
import org.eclipse.microprofile.jwt.tck.util.TokenUtils;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.Reporter;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class PrimitiveInjectionTest
extends Arquillian {
    private static String token;
    private static Long iatClaim;
    private static Long authTimeClaim;
    private static Long expClaim;
    @ArquillianResource
    private URL baseURL;

    @Deployment(testable=true)
    public static WebArchive createDeployment() throws IOException {
        URL config = PrimitiveInjectionTest.class.getResource("/META-INF/microprofile-config-publickey-location.properties");
        URL publicKey = PrimitiveInjectionTest.class.getResource("/publicKey.pem");
        WebArchive webArchive = (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"PrimitiveInjectionTest.war")).addAsManifestResource((Asset)new StringAsset(MpJwtTestVersion.MPJWT_V_1_0.name()), "MPJWTTESTVERSION")).addAsResource(publicKey, "/publicKey.pem")).addClass(PrimitiveInjectionEndpoint.class)).addClass(TCKApplication.class)).addAsWebInfResource("beans.xml", "beans.xml")).addAsManifestResource(config, "microprofile-config.properties");
        System.out.printf("WebArchive: %s\n", webArchive.toString(true));
        return webArchive;
    }

    @BeforeClass(alwaysRun=true)
    public static void generateToken() throws Exception {
        HashMap timeClaims = new HashMap();
        token = TokenUtils.generateTokenString((String)"/Token1.json", null, timeClaims);
        iatClaim = (Long)timeClaims.get(Claims.iat.name());
        authTimeClaim = (Long)timeClaims.get(Claims.auth_time.name());
        expClaim = (Long)timeClaims.get(Claims.exp.name());
    }

    @RunAsClient
    @Test(groups={"cdi-provider"}, description="Verify that the injected token issuer claim is as expected")
    public void verifyIssuerClaim() throws Exception {
        Reporter.log((String)"Begin verifyIssuerClaim");
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedIssuer";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam(Claims.iss.name(), new Object[]{"https://server.example.com"}).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"cdi-provider"}, description="Verify that the injected raw token claim is as expected")
    public void verifyInjectedRawToken() throws Exception {
        Reporter.log((String)"Begin verifyInjectedRawToken\n");
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedRawToken";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam(Claims.raw_token.name(), new Object[]{token}).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"cdi-provider"}, description="Verify that the injected jti claim is as expected")
    public void verifyInjectedJTI() throws Exception {
        Reporter.log((String)"Begin verifyInjectedJTI\n");
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedJTI";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam(Claims.jti.name(), new Object[]{"a-123"}).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"cdi-provider"}, description="Verify that the injected upn claim is as expected")
    public void verifyInjectedUPN() throws Exception {
        Reporter.log((String)"Begin verifyInjectedUPN\n");
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedUPN";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam(Claims.upn.name(), new Object[]{"jdoe@example.com"}).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"cdi-provider"}, description="Verify that the injected sub claim is as expected")
    public void verifyInjectedSUB() throws Exception {
        Reporter.log((String)"Begin verifyInjectedSUB\n");
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedSUB";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam(Claims.sub.name(), new Object[]{"24400320"}).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"cdi-provider"}, description="Verify that the injected aud claim is as expected")
    public void verifyInjectedAudience() throws Exception {
        Reporter.log((String)"Begin verifyInjectedAudience\n");
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedAudience";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam(Claims.aud.name(), (Object[])new String[]{"s6BhdRkqt3"}).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"cdi-provider"}, description="Verify that the injected groups claim is as expected")
    public void verifyInjectedGroups() throws Exception {
        Reporter.log((String)"Begin verifyInjectedGroups\n");
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedGroups";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam(Claims.groups.name(), (Object[])new String[]{"Echoer", "Tester", "group1", "group2"}).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"cdi-provider"}, description="Verify that the injected iat claim is as expected")
    public void verifyInjectedIssuedAt() throws Exception {
        Reporter.log((String)"Begin verifyInjectedIssuedAt\n");
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedIssuedAt";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam(Claims.iat.name(), new Object[]{iatClaim}).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"cdi-provider"}, description="Verify that the injected exp claim is as expected")
    public void verifyInjectedExpiration() throws Exception {
        Reporter.log((String)"Begin verifyInjectedExpiration\n");
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedExpiration";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam(Claims.exp.name(), new Object[]{expClaim}).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"cdi-provider"}, description="Verify that the injected customString claim is as expected")
    public void verifyInjectedCustomString() throws Exception {
        Reporter.log((String)"Begin verifyInjectedCustomString\n");
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedCustomString";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam("value", new Object[]{"customStringValue"}).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"cdi-provider"}, description="Verify that the injected customBoolean claim is as expected")
    public void verifyInjectedCustomBoolean() {
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedCustomBoolean";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam("value", new Object[]{"true"});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }
}

