/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.jwt.tck.config;

import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URL;
import java.util.Properties;
import org.eclipse.microprofile.jwt.tck.container.jaxrs.InvalidTokenTest;
import org.eclipse.microprofile.jwt.tck.container.jaxrs.RolesEndpoint;
import org.eclipse.microprofile.jwt.tck.container.jaxrs.TCKApplication;
import org.eclipse.microprofile.jwt.tck.util.MpJwtTestVersion;
import org.eclipse.microprofile.jwt.tck.util.TokenUtils;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TokenAsCookieTest
extends Arquillian {
    @ArquillianResource
    private URL baseURL;

    @Deployment
    public static WebArchive createDeployment() throws IOException {
        Properties configProps = new Properties();
        configProps.setProperty("mp.jwt.verify.publickey.location", "/publicKey.pem");
        configProps.setProperty("mp.jwt.verify.issuer", "https://server.example.com");
        configProps.setProperty("mp.jwt.token.header", "Cookie");
        StringWriter configSW = new StringWriter();
        configProps.store(configSW, "TokenAsCookie microprofile-config.properties");
        StringAsset config = new StringAsset(configSW.toString());
        URL publicKey = InvalidTokenTest.class.getResource("/publicKey.pem");
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"TokenAsCookie.war")).addAsManifestResource((Asset)new StringAsset(MpJwtTestVersion.MPJWT_V_1_2.name()), "MPJWTTESTVERSION")).addAsResource(publicKey, "/publicKey.pem")).addClass(TCKApplication.class)).addClass(RolesEndpoint.class)).addAsWebInfResource("beans.xml", "beans.xml")).addAsManifestResource((Asset)config, "microprofile-config.properties");
    }

    @RunAsClient
    @Test(groups={"jaxrs"}, description="Validate a request with a valid JWT in a Cookie with default name")
    public void validJwt() throws Exception {
        String token = TokenUtils.generateTokenString((String)"/Token1.json");
        String uri = this.baseURL.toExternalForm() + "endp/echo";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam("input", new Object[]{"hello"});
        Response response = echoEndpointTarget.request(new String[]{"text/plain"}).cookie("Bearer", token).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String reply = (String)response.readEntity(String.class);
        Assert.assertEquals((String)reply, (String)"hello, user=jdoe@example.com");
    }
}

