/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.jwt.tck.container.jacc;

import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.net.URL;
import org.eclipse.microprofile.jwt.tck.container.jacc.SubjectEndpoint;
import org.eclipse.microprofile.jwt.tck.container.jaxrs.TCKApplication;
import org.eclipse.microprofile.jwt.tck.util.MpJwtTestVersion;
import org.eclipse.microprofile.jwt.tck.util.TokenUtils;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class SubjectTest
extends Arquillian {
    private static String token;
    @ArquillianResource
    private URL baseURL;

    @Deployment(testable=true)
    public static WebArchive createDeployment() throws IOException {
        URL publicKey = SubjectTest.class.getResource("/publicKey.pem");
        WebArchive webArchive = (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"SubjectTest.war")).addAsManifestResource((Asset)new StringAsset(MpJwtTestVersion.MPJWT_V_1_0.name()), "MPJWTTESTVERSION")).addAsResource(publicKey, "/publicKey.pem")).addClass(SubjectEndpoint.class)).addClass(TCKApplication.class)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        System.out.printf("WebArchive: %s\n", webArchive.toString(true));
        return webArchive;
    }

    @BeforeClass(alwaysRun=true)
    public static void generateToken() throws Exception {
        token = TokenUtils.generateTokenString((String)"/Token1.json");
    }

    @RunAsClient
    @Test(groups={"jacc-optional"}, description="Validate a request with MP-JWT PolicyContext.getContext(jakarta.security.auth.Subject.containe) has a JsonWebToken")
    public void getSubjectClass() throws Exception {
        String uri = this.baseURL.toExternalForm() + "endp/getSubjectClass";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri);
        Response response = echoEndpointTarget.request(new String[]{"text/plain"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String reply = (String)response.readEntity(String.class);
        System.out.println(reply);
    }
}

