/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.jwt.tck.container.servlet;

import jakarta.ejb.EJB;
import jakarta.security.jacc.PolicyContext;
import jakarta.security.jacc.PolicyContextException;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.HttpConstraint;
import jakarta.servlet.annotation.ServletSecurity;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import org.eclipse.microprofile.jwt.JsonWebToken;
import org.eclipse.microprofile.jwt.tck.container.ejb.IService;

@ServletSecurity(value=@HttpConstraint(rolesAllowed={"Tester"}))
@WebServlet(value={"/ServiceServlet/*"})
public class ServiceServlet
extends HttpServlet {
    @EJB
    private IService serviceEJB;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Principal user = req.getUserPrincipal();
        String pathInfo = req.getPathInfo();
        System.out.printf("pathInfo=%s\n", pathInfo);
        String result = "";
        if (pathInfo.endsWith("/getSubject")) {
            System.out.printf("Calling getSubject\n", new Object[0]);
            result = this.getSubject(resp);
        } else {
            System.out.printf("Calling getPrincipalClass\n", new Object[0]);
            result = this.getPrincipalClass(user);
        }
        resp.getWriter().write(result);
    }

    private String getPrincipalClass(Principal user) {
        Object tmp;
        HashSet<Object> interfaces = new HashSet<Object>();
        Class<?> current = user.getClass();
        while (!current.equals(Object.class)) {
            for (Object c : tmp = current.getInterfaces()) {
                interfaces.add(c);
            }
            current = current.getSuperclass();
        }
        tmp = new StringBuilder();
        for (Class clazz : interfaces) {
            ((StringBuilder)tmp).append(clazz.getTypeName());
            ((StringBuilder)tmp).append(',');
        }
        ((StringBuilder)tmp).setLength(((StringBuilder)tmp).length() - 1);
        return ((StringBuilder)tmp).toString();
    }

    private String getSubject(HttpServletResponse response) throws IOException {
        try {
            Subject subject = (Subject)PolicyContext.getContext((String)"javax.security.auth.Subject.container");
            Set<JsonWebToken> principalSet = subject.getPrincipals(JsonWebToken.class);
            if (principalSet.size() > 0) {
                return "subject.getPrincipals(JsonWebToken.class) ok";
            }
            response.sendError(500, "subject.getPrincipals(JsonWebToken.class) == 0");
        }
        catch (PolicyContextException e) {
            e.printStackTrace();
            response.sendError(500, e.getMessage());
        }
        throw new IllegalStateException("subject.getPrincipals(JsonWebToken.class) == 0");
    }

    private String callEJB(HttpServletResponse response) throws IOException {
        return "";
    }
}

