/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.tck.metrics;

import jakarta.inject.Inject;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class GaugeTest {
    @Inject
    private MetricRegistry metrics;
    private final AtomicInteger value = new AtomicInteger(0);

    @Deployment
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    public void testManualGauge() {
        MetricID supplierGaugeMetricID = new MetricID("tck.gaugetest.supplierGaugeManual");
        MetricID toDoubleFunctiongaugeMetricID = new MetricID("tck.gaugetest.toDoubleFunctionGaugeManual");
        Gauge sGauge = this.metrics.getGauge(supplierGaugeMetricID);
        Gauge fGauge = this.metrics.getGauge(toDoubleFunctiongaugeMetricID);
        Assert.assertNull((Object)sGauge);
        Assert.assertNull((Object)fGauge);
        this.gaugeMe();
        sGauge = this.metrics.getGauge(supplierGaugeMetricID);
        fGauge = this.metrics.getGauge(toDoubleFunctiongaugeMetricID);
        Assert.assertEquals((Object)0, (Object)sGauge.getValue());
        Assert.assertEquals((Object)1, (Object)fGauge.getValue());
        Assert.assertEquals((Object)2, (Object)sGauge.getValue());
        Assert.assertEquals((Object)3, (Object)fGauge.getValue());
    }

    public void gaugeMe() {
        this.metrics.gauge("tck.gaugetest.supplierGaugeManual", this.value::getAndIncrement, null);
        this.metrics.gauge("tck.gaugetest.toDoubleFunctionGaugeManual", (Object)this.value, atomicInteger -> {
            AtomicInteger myAtomicInteger = atomicInteger;
            return myAtomicInteger.getAndIncrement();
        }, null);
    }
}

