/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.tck.metrics;

import jakarta.inject.Inject;
import java.util.Set;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.tck.metrics.MultipleMetricsMethodBean;
import org.eclipse.microprofile.metrics.tck.util.MetricsUtil;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class MultipleMetricsMethodBeanTest {
    private static final String[] METRIC_NAMES = new String[]{"counter", "gauge", "meter", "timer"};
    @Inject
    private MetricRegistry registry;
    @Inject
    private MultipleMetricsMethodBean bean;

    private Set<String> absoluteMetricNames() {
        return MetricsUtil.absoluteMetricNames(MultipleMetricsMethodBean.class, METRIC_NAMES);
    }

    private String absoluteMetricName(String name) {
        return MetricsUtil.absoluteMetricName(MultipleMetricsMethodBean.class, name);
    }

    @Deployment
    static Archive<?> createTestArchive() {
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClasses(new Class[]{MultipleMetricsMethodBean.class, MetricsUtil.class})).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Before
    public void instantiateApplicationScopedBean() {
        this.bean.toString();
    }

    @Test
    @InSequence(value=1)
    public void metricsMethodNotCalledYet() {
        Assert.assertThat((String)"Metrics are not registered correctly", (Object)this.registry.getMetricIDs(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(MetricsUtil.createMetricIDs(this.absoluteMetricNames()))));
    }

    @Test
    @InSequence(value=2)
    public void callMetricsMethodOnce() {
        Assert.assertThat((String)"Metrics are not registered correctly", (Object)this.registry.getMetricIDs(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(MetricsUtil.createMetricIDs(this.absoluteMetricNames()))));
        this.bean.metricsMethod();
        Assert.assertThat((String)"Counter count is incorrect", (Object)this.registry.getCounter(new MetricID(this.absoluteMetricName("counter"))).getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1L)));
        Assert.assertThat((String)"Meter count is incorrect", (Object)this.registry.getMeter(new MetricID(this.absoluteMetricName("meter"))).getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1L)));
        Assert.assertThat((String)"Timer count is incorrect", (Object)this.registry.getTimer(new MetricID(this.absoluteMetricName("timer"))).getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1L)));
        Assert.assertThat((String)"Gauge value is incorrect", (Object)this.registry.getGauge(new MetricID(this.absoluteMetricName("gauge"))).getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1234L)));
    }
}

