/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.tck;

import jakarta.inject.Inject;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.annotation.RegistryScope;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class MetricRegistryTest {
    private static final String CUSTOM_SCOPE = "customScope";
    @Inject
    @org.eclipse.microprofile.metrics.annotation.Metric(name="nameTest", absolute=true)
    private Counter nameTest;
    @Inject
    private MetricRegistry metrics;
    @Inject
    @RegistryScope(scope="base")
    private MetricRegistry baseMetrics;
    @Inject
    @RegistryScope(scope="vendor")
    private MetricRegistry vendorMetrics;
    @Inject
    @RegistryScope(scope="customScope")
    private MetricRegistry customScope;

    @Deployment
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    @InSequence(value=1)
    public void nameTest() {
        Assert.assertNotNull((Object)this.metrics);
        Assert.assertNotNull((Object)this.metrics.getMetadata("nameTest"));
    }

    @Test
    @InSequence(value=3)
    public void removeTest() {
        this.metrics.remove("nameTest");
        Assert.assertNull((Object)this.metrics.getMetadata("nameTest"));
    }

    @Test
    @InSequence(value=4)
    public void useExistingMetaDataTest() {
        String metricName = "counterFoo";
        Tag orangeTag = new Tag("colour", "orange");
        Tag purpleTag = new Tag("colour", "purple");
        this.metrics.counter(Metadata.builder().withName(metricName).withType(MetricType.COUNTER).build(), new Tag[]{orangeTag});
        this.metrics.counter(metricName, new Tag[]{purpleTag});
        this.assertExists(Counter.class, new MetricID(metricName, new Tag[]{orangeTag}));
        this.assertExists(Counter.class, new MetricID(metricName, new Tag[]{purpleTag}));
    }

    @Test
    @InSequence(value=5)
    public void testMetricRegistryScope() {
        Assert.assertEquals((Object)"application", (Object)this.metrics.getScope());
        Assert.assertEquals((Object)"base", (Object)this.baseMetrics.getScope());
        Assert.assertEquals((Object)"vendor", (Object)this.vendorMetrics.getScope());
        Assert.assertEquals((Object)CUSTOM_SCOPE, (Object)this.customScope.getScope());
    }

    private void assertExists(Class<? extends Metric> expected, MetricID metricID) {
        Assert.assertNotNull((String)("Metric expected to exist but was undefined: " + metricID), (Object)this.metrics.getMetric(metricID, expected));
    }

    @Test
    @InSequence(value=6)
    public void sanitizeMetadataTest() {
        Metadata metadata = Metadata.builder().withName("metric1").build();
        this.metrics.counter(metadata);
        Metadata actualMetadata = this.metrics.getMetadata("metric1");
        Assert.assertEquals((Object)MetricType.COUNTER, (Object)actualMetadata.getTypeRaw());
    }

    @Test(expected=Exception.class)
    @InSequence(value=7)
    public void conflictingMetadataTest() {
        Metadata metadata = Metadata.builder().withName("metric1").withType(MetricType.COUNTER).build();
        this.metrics.timer(metadata);
    }
}

