/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.test.optional;

import io.restassured.RestAssured;
import io.restassured.builder.ResponseBuilder;
import io.restassured.http.Header;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@RunWith(value=Arquillian.class)
public class MPMetricBaseMetricsTest {
    private static final String TEXT_PLAIN = "text/plain";
    private static final String PROM_APP_LABEL_REGEX = "mp_app=\"[-/A-Za-z0-9]+\"";
    private static final String DEFAULT_PROTOCOL = "http";
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 8080;
    public static final double TOLERANCE = 0.025;

    private static String filterOutAppLabelPromMetrics(String responseBody) {
        return responseBody.replaceAll(PROM_APP_LABEL_REGEX, "").replaceAll("\\{,", "{").replaceAll(",\\}", "}");
    }

    @BeforeClass
    public static void setup() throws MalformedURLException {
        String serverUrl = System.getProperty("test.url");
        String protocol = DEFAULT_PROTOCOL;
        String host = DEFAULT_HOST;
        int port = 8080;
        if (serverUrl != null) {
            URL url = new URL(serverUrl);
            protocol = url.getProtocol();
            host = url.getHost();
            port = url.getPort() == -1 ? 8080 : url.getPort();
        }
        RestAssured.baseURI = protocol + "://" + host;
        RestAssured.port = port;
        String userName = System.getProperty("test.user");
        String password = System.getProperty("test.pwd");
        if (userName != null && password != null) {
            RestAssured.authentication = RestAssured.basic((String)userName, (String)password);
            RestAssured.useRelaxedHTTPSValidation();
        }
    }

    @Deployment
    public static WebArchive createDeployment() {
        WebArchive jar = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        System.out.println(jar.toString(true));
        return jar;
    }

    @Test
    @RunAsClient
    @InSequence(value=1)
    public void testBasePromMetrics() {
        Assume.assumeFalse((boolean)Boolean.getBoolean("skip.base.metric.tests"));
        Response resp = (Response)RestAssured.given().header("Accept", (Object)TEXT_PLAIN, new Object[0]).get("/metrics?scope=base", new Object[0]);
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(MPMetricBaseMetricsTest.filterOutAppLabelPromMetrics(resp.getBody().asString()));
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).and()).contentType(TEXT_PLAIN)).and()).body(CoreMatchers.containsString((String)"# TYPE thread_max_count"), new Matcher[0])).body(CoreMatchers.containsString((String)"thread_max_count{mp_scope=\"base\",tier=\"integration\"}"), new Matcher[0]);
    }

    @Test
    @RunAsClient
    @InSequence(value=2)
    public void testBaseAttributePromMetrics() {
        Assume.assumeFalse((boolean)Boolean.getBoolean("skip.base.metric.tests"));
        Response resp = (Response)RestAssured.given().header("Accept", (Object)TEXT_PLAIN, new Object[0]).get("/metrics?scope=base&name=thread.max.count", new Object[0]);
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(MPMetricBaseMetricsTest.filterOutAppLabelPromMetrics(resp.getBody().asString()));
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).and()).contentType(TEXT_PLAIN)).and()).body(CoreMatchers.containsString((String)"# TYPE thread_max_count"), new Matcher[]{CoreMatchers.containsString((String)"thread_max_count{mp_scope=\"base\",tier=\"integration\"}")});
    }

    @Test
    @RunAsClient
    @InSequence(value=3)
    public void testPromMetricsFormatNoBadChars() {
        String[] lines;
        Assume.assumeFalse((boolean)Boolean.getBoolean("skip.base.metric.tests"));
        Header wantPromMetricsFormat = new Header("Accept", TEXT_PLAIN);
        String data = ((Response)RestAssured.given().header(wantPromMetricsFormat).get("/metrics?scope=base", new Object[0])).asString();
        for (String line : lines = data.split("\n")) {
            if (line.startsWith("#")) continue;
            String nameAndTagsPart = line.substring(0, line.lastIndexOf(" "));
            String namePart = nameAndTagsPart.contains("{") ? nameAndTagsPart.substring(0, nameAndTagsPart.lastIndexOf("{")) : nameAndTagsPart;
            Assert.assertFalse((String)("Name has illegal chars " + line), (boolean)namePart.matches(".*[-.].*"));
            Assert.assertFalse((String)("Found __ in " + line), (boolean)line.matches(".*__.*"));
        }
    }

    @Test
    @RunAsClient
    @InSequence(value=4)
    public void testBaseMetadataSingluarItemsPromMetrics() {
        Assume.assumeFalse((boolean)Boolean.getBoolean("skip.base.metric.tests"));
        Header wantPromMetricsFormat = new Header("Accept", TEXT_PLAIN);
        String data = ((Response)RestAssured.given().header(wantPromMetricsFormat).get("/metrics?scope=base", new Object[0])).asString();
        String[] lines = data.split("\n");
        Map<String, MiniMeta> expectedMetadata = this.getExpectedMetadataFromXmlFile("base");
        for (MiniMeta mm : expectedMetadata.values()) {
            boolean found = false;
            if (mm.name.startsWith("gc.") || expectedMetadata.get(mm.name).optional) continue;
            for (String line : lines) {
                if (!line.startsWith("# TYPE")) continue;
                String promName = mm.toPromString();
                String[] tmp = line.split(" ");
                Assert.assertEquals((String)("Bad entry: " + line), (long)tmp.length, (long)4L);
                if (!tmp[2].startsWith(promName)) continue;
                found = true;
                Assert.assertEquals((String)("Expected [" + mm.toString() + "] got [" + line + "]"), (Object)tmp[3], (Object)mm.type);
            }
            Assert.assertTrue((String)("Not found [" + mm.toString() + "]"), (boolean)found);
        }
    }

    @Test
    @RunAsClient
    @InSequence(value=5)
    public void testOptionalBaseMetrics() {
        Assume.assumeFalse((boolean)Boolean.getBoolean("skip.base.metric.tests"));
        Header wantPromMetricsFormat = new Header("Accept", TEXT_PLAIN);
        String data = ((Response)RestAssured.given().header(wantPromMetricsFormat).get("/metrics?scope=base", new Object[0])).asString();
        String[] lines = data.split("\n");
        Map<String, MiniMeta> names = this.getExpectedMetadataFromXmlFile("base");
        for (String line : lines) {
            for (MiniMeta item : names.values()) {
                if (!line.contains("# TYPE " + item.toPromString()) || !names.get(item.name).optional) continue;
                MatcherAssert.assertThat((String)("Wrong metric type. Should be " + item.type), (Object)line, (Matcher)CoreMatchers.containsString((String)item.type));
            }
        }
    }

    @Test
    @RunAsClient
    @InSequence(value=6)
    public void testGcCountMetrics() {
        Assume.assumeFalse((boolean)Boolean.getBoolean("skip.base.metric.tests"));
        Header wantPromMetricsFormat = new Header("Accept", TEXT_PLAIN);
        String data = ((Response)RestAssured.given().header(wantPromMetricsFormat).get("/metrics?scope=base", new Object[0])).asString();
        Map<String, MiniMeta> baseNames = this.getExpectedMetadataFromXmlFile("base");
        MiniMeta gcCountMetricMeta = baseNames.get("gc.total");
        Set expectedTags = gcCountMetricMeta.tags.keySet();
        String[] lines = data.split("\n");
        boolean found = false;
        for (String line : lines) {
            if (!line.contains("gc_total{")) continue;
            Pattern gcTotalPattern = Pattern.compile("(gc_total\\{.*?\\}) (\\d+\\.\\d+)");
            MatcherAssert.assertThat((String)"Line format should be gc_total\\{.*?\\} \\d+\\.\\d+", (boolean)gcTotalPattern.matcher(line).matches());
            String metricID = gcTotalPattern.matcher(line).replaceAll("$1");
            String tags = metricID.replaceAll("^gc_total\\{", "").replaceAll("\\}$", "");
            for (String expectedTag : expectedTags) {
                MatcherAssert.assertThat((String)("The metric should contain a " + expectedTag + " tag"), (Object)tags, (Matcher)CoreMatchers.containsString((String)(expectedTag + "=")));
            }
            String value = gcTotalPattern.matcher(line).replaceAll("$2");
            Assert.assertTrue((String)"gc.total value should be numeric and not negative", (Double.valueOf(value) >= 0.0 ? 1 : 0) != 0);
            found = true;
        }
        Assert.assertTrue((String)"At least one metric named gc.total is expected", (boolean)found);
    }

    @Test
    @RunAsClient
    @InSequence(value=7)
    public void testGcTimeMetrics() {
        Assume.assumeFalse((boolean)Boolean.getBoolean("skip.base.metric.tests"));
        Header wantPromMetricsFormat = new Header("Accept", TEXT_PLAIN);
        String data = ((Response)RestAssured.given().header(wantPromMetricsFormat).get("/metrics?scope=base", new Object[0])).asString();
        Map<String, MiniMeta> baseNames = this.getExpectedMetadataFromXmlFile("base");
        MiniMeta gcCountMetricMeta = baseNames.get("gc.time");
        Set expectedTags = gcCountMetricMeta.tags.keySet();
        String[] lines = data.split("\n");
        boolean found = false;
        for (String line : lines) {
            if (!line.contains("gc_time_seconds_total{")) continue;
            Pattern gcTimeTotalPattern = Pattern.compile("(gc_time_seconds_total\\{.*?\\}) (\\d+\\.\\d+)");
            MatcherAssert.assertThat((String)"Line format should be gc_time_seconds_total\\{.*?\\} \\d+\\.\\d+", (boolean)gcTimeTotalPattern.matcher(line).matches());
            String metricID = gcTimeTotalPattern.matcher(line).replaceAll("$1");
            String tags = metricID.replaceAll("^gc_time_seconds_total\\{", "").replaceAll("\\}$", "");
            for (String expectedTag : expectedTags) {
                MatcherAssert.assertThat((String)("The metric should contain a " + expectedTag + " tag"), (Object)tags, (Matcher)CoreMatchers.containsString((String)(expectedTag + "=")));
            }
            String value = gcTimeTotalPattern.matcher(line).replaceAll("$2");
            Assert.assertTrue((String)"gc.time.seconds.total value should be numeric and not negative", (Double.valueOf(value) >= 0.0 ? 1 : 0) != 0);
            found = true;
        }
        Assert.assertTrue((String)"At least one metric named gc.time.seconds.total is expected", (boolean)found);
    }

    private Map<String, MiniMeta> getExpectedMetadataFromXmlFile(String scope) {
        Document document;
        String fileName;
        ClassLoader cl = this.getClass().getClassLoader();
        switch (scope) {
            case "base": {
                fileName = "base_metrics.xml";
                break;
            }
            case "application": {
                fileName = "application_metrics.xml";
                break;
            }
            default: {
                throw new IllegalArgumentException("No definitions for " + scope + " supported");
            }
        }
        InputStream is = cl.getResourceAsStream(fileName);
        DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = fac.newDocumentBuilder();
            document = builder.parse(is);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException(e);
        }
        Element root = (Element)document.getElementsByTagName("config").item(0);
        NodeList metrics = root.getElementsByTagName("metric");
        HashMap<String, MiniMeta> metaMap = new HashMap<String, MiniMeta>(metrics.getLength());
        for (int i = 0; i < metrics.getLength(); ++i) {
            Element metric = (Element)metrics.item(i);
            MiniMeta mm = new MiniMeta();
            mm.multi = Boolean.parseBoolean(metric.getAttribute("multi"));
            mm.name = metric.getAttribute("name");
            mm.type = metric.getAttribute("type");
            mm.unit = metric.getAttribute("unit");
            mm.description = metric.getAttribute("description");
            mm.optional = Boolean.parseBoolean(metric.getAttribute("optional"));
            String tags = metric.getAttribute("tags");
            if (tags != null && tags.length() != 0) {
                for (String tag : tags.split(",")) {
                    String[] str = tag.split("=");
                    mm.tags.put(str[0], str[1]);
                }
            }
            metaMap.put(mm.name, mm);
        }
        return metaMap;
    }

    private static class MiniMeta {
        private String name;
        private String type;
        private String unit;
        private String description;
        private boolean multi;
        private boolean optional;
        private Map<String, String> tags = new TreeMap<String, String>();

        public MiniMeta() {
            this.tags.put("tier", "integration");
        }

        String toPromString() {
            String out = this.name.replace('-', '_').replace('.', '_').replace(' ', '_');
            if (!this.unit.equals("none")) {
                out = out + "_" + this.unit;
            }
            out = out.replace("__", "_");
            out = out.replace(":_", ":");
            return out;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("MiniMeta{");
            sb.append("name='").append(this.name).append('\'');
            sb.append(", type='").append(this.type).append('\'');
            sb.append(", unit='").append(this.unit).append('\'');
            sb.append(", multi=").append(this.multi);
            sb.append(", optional=").append(this.optional);
            sb.append(", description=").append(this.description);
            sb.append('}');
            return sb.toString();
        }
    }
}

