/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.tck.metrics;

import jakarta.inject.Inject;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.tck.metrics.GaugeMethodBean;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class GaugeMethodBeanTest {
    private static final String GAUGE_NAME = MetricRegistry.name(GaugeMethodBean.class, (String[])new String[]{"gaugeMethod"});
    private static final String PRIVATE_GAUGE_NAME = MetricRegistry.name(GaugeMethodBean.class, (String[])new String[]{"privateGaugeMethod"});
    private static MetricID gaugeMID;
    private static MetricID privateGaugeMID;
    @Inject
    private MetricRegistry registry;
    @Inject
    private GaugeMethodBean bean;

    @Deployment
    public static Archive<?> createTestArchive() {
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClass(GaugeMethodBean.class)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Before
    public void instantiateApplicationScopedBeanAndTest() {
        this.bean.getGauge();
        gaugeMID = new MetricID(GAUGE_NAME);
        privateGaugeMID = new MetricID(PRIVATE_GAUGE_NAME);
    }

    @Test
    @InSequence(value=1)
    public void gaugeCalledWithDefaultValue() {
        Gauge gauge = this.registry.getGauge(gaugeMID);
        Assert.assertThat((String)"Gauge is not registered correctly", (Object)gauge, (Matcher)Matchers.notNullValue());
        Assert.assertThat((String)"Gauge value is incorrect", (Object)gauge.getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0L)));
    }

    @Test
    @InSequence(value=2)
    public void callGaugeAfterSetterCall() {
        Gauge gauge = this.registry.getGauge(gaugeMID);
        Assert.assertThat((String)"Gauge is not registered correctly", (Object)gauge, (Matcher)Matchers.notNullValue());
        long value = Math.round(Math.random() * 9.223372036854776E18);
        this.bean.setGauge(value);
        Assert.assertThat((String)"Gauge value is incorrect", (Object)gauge.getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)value)));
    }

    @Test
    @InSequence(value=3)
    public void privateGaugeCalledWithDefaultValue() {
        Gauge gauge = this.registry.getGauge(privateGaugeMID);
        Assert.assertThat((String)"Gauge is not registered correctly", (Object)gauge, (Matcher)Matchers.notNullValue());
        Assert.assertThat((String)"Gauge value is incorrect", (Object)gauge.getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0L)));
    }

    @Test
    @InSequence(value=4)
    public void callPrivateGaugeAfterSetterCall() {
        Gauge gauge = this.registry.getGauge(privateGaugeMID);
        Assert.assertThat((String)"Gauge is not registered correctly", (Object)gauge, (Matcher)Matchers.notNullValue());
        long value = Math.round(Math.random() * 9.223372036854776E18);
        this.bean.setPrivateGauge(value);
        Assert.assertThat((String)"Gauge value is incorrect", (Object)gauge.getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)value)));
    }
}

