/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.tck.cdi.stereotype;

import jakarta.inject.Inject;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.tck.cdi.stereotype.StereotypeCountedClassBean;
import org.eclipse.microprofile.metrics.tck.cdi.stereotype.StereotypeCountedClassBeanWithSpecifiedMetadata;
import org.eclipse.microprofile.metrics.tck.cdi.stereotype.stereotypes.CountMe;
import org.eclipse.microprofile.metrics.tck.cdi.stereotype.stereotypes.CountMeWithSpecifiedMetadata;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class StereotypeCountedClassBeanTest {
    @Inject
    private MetricRegistry metricRegistry;
    @Inject
    private StereotypeCountedClassBean bean;
    @Inject
    private StereotypeCountedClassBeanWithSpecifiedMetadata beanWithSpecifiedMetadata;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addAsWebInfResource("META-INF/beans.xml", "beans.xml")).addClasses(new Class[]{StereotypeCountedClassBean.class, StereotypeCountedClassBeanWithSpecifiedMetadata.class, CountMe.class, CountMeWithSpecifiedMetadata.class});
    }

    @Test
    public void testPlainAnnotation() {
        MetricID constructorMetricId = new MetricID(StereotypeCountedClassBean.class.getName() + ".StereotypeCountedClassBean");
        Assert.assertNotNull((Object)this.metricRegistry.getCounter(constructorMetricId));
        MetricID methodMetricId = new MetricID(StereotypeCountedClassBean.class.getName() + ".foo");
        Assert.assertNotNull((Object)this.metricRegistry.getCounter(methodMetricId));
        this.bean.foo();
        Assert.assertEquals((long)1L, (long)this.metricRegistry.getCounter(methodMetricId).getCount());
    }

    @Test
    public void testWithMetadata() {
        String constructorMetricName = "org.eclipse.microprofile.metrics.tck.cdi.stereotype.bloop.StereotypeCountedClassBeanWithSpecifiedMetadata";
        MetricID constructorMetricId = new MetricID(constructorMetricName);
        Assert.assertNotNull((Object)this.metricRegistry.getCounter(constructorMetricId));
        Metadata constructorMetadata = this.metricRegistry.getMetadata(constructorMetricName);
        Assert.assertEquals((Object)"description", constructorMetadata.description().orElse(null));
        String methodMetricName = "org.eclipse.microprofile.metrics.tck.cdi.stereotype.bloop.foo";
        MetricID methodMetricId = new MetricID(methodMetricName);
        Assert.assertNotNull((Object)this.metricRegistry.getCounter(methodMetricId));
        Metadata methodMetadata = this.metricRegistry.getMetadata(methodMetricName);
        Assert.assertEquals((Object)"description", methodMetadata.description().orElse(null));
        this.beanWithSpecifiedMetadata.foo();
        Assert.assertEquals((long)1L, (long)this.metricRegistry.getCounter(methodMetricId).getCount());
    }
}

