/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.test;

import io.restassured.RestAssured;
import io.restassured.builder.ResponseBuilder;
import io.restassured.http.Header;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import jakarta.inject.Inject;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.microprofile.metrics.test.MetricAppBean;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class MpMetricTest {
    private static final String TEXT_PLAIN = "text/plain";
    private static final String PROM_APP_LABEL_REGEX = "mp_app=\"[-/A-Za-z0-9]+\"";
    private static final String DEFAULT_PROTOCOL = "http";
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 8080;
    public static final double TOLERANCE = 0.025;
    @Inject
    private MetricAppBean metricAppBean;

    private static String filterOutAppLabelPromMetrics(String responseBody) {
        return responseBody.replaceAll(PROM_APP_LABEL_REGEX, "").replaceAll("\\{,", "{").replaceAll(",\\}", "}");
    }

    @BeforeClass
    public static void setup() throws MalformedURLException {
        String serverUrl = System.getProperty("test.url");
        String protocol = DEFAULT_PROTOCOL;
        String host = DEFAULT_HOST;
        int port = 8080;
        if (serverUrl != null) {
            URL url = new URL(serverUrl);
            protocol = url.getProtocol();
            host = url.getHost();
            port = url.getPort() == -1 ? 8080 : url.getPort();
        }
        RestAssured.baseURI = protocol + "://" + host;
        RestAssured.port = port;
        String userName = System.getProperty("test.user");
        String password = System.getProperty("test.pwd");
        if (userName != null && password != null) {
            RestAssured.authentication = RestAssured.basic((String)userName, (String)password);
            RestAssured.useRelaxedHTTPSValidation();
        }
    }

    @Deployment
    public static WebArchive createDeployment() {
        WebArchive jar = (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClass(MetricAppBean.class)).addAsWebInfResource("META-INF/beans.xml", "beans.xml");
        System.out.println(jar.toString(true));
        return jar;
    }

    @Test
    @RunAsClient
    @InSequence(value=1)
    public void testTextPlainResponseContentType() {
        Header acceptHeader = new Header("Accept", TEXT_PLAIN);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header(acceptHeader).when().get("/metrics", new Object[0])).then()).statusCode(200)).and()).contentType(TEXT_PLAIN);
    }

    @Test
    @RunAsClient
    @InSequence(value=2)
    public void testRequestPathReturn404() {
        ((ValidatableResponse)((Response)RestAssured.when().get("/metrics/bad-tree", new Object[0])).then()).statusCode(404);
    }

    @Test
    @RunAsClient
    @InSequence(value=3)
    public void testBadScopeReturn404() {
        ((ValidatableResponse)((Response)RestAssured.when().get("/metrics?scope=fakescope", new Object[0])).then()).statusCode(404);
    }

    @Test
    @InSequence(value=10)
    public void testSetupApplicationMetrics() {
        this.metricAppBean.countMe();
        this.metricAppBean.countMeA();
        this.metricAppBean.countMeB();
        this.metricAppBean.gaugeMe();
        this.metricAppBean.gaugeMeA();
        this.metricAppBean.gaugeMeB();
        this.metricAppBean.gaugeMeTagged();
        this.metricAppBean.gaugeMeTaggedOne();
        this.metricAppBean.gaugeMeTaggedTwo();
        this.metricAppBean.histogramMe();
        this.metricAppBean.timeMe();
        this.metricAppBean.timeMeA();
    }

    @Test
    @RunAsClient
    @InSequence(value=11)
    public void testApplicationMetricsPrometheus() {
        Header wantPrometheus = new Header("Accept", TEXT_PLAIN);
        Response resp = (Response)RestAssured.given().header(wantPrometheus).get("/metrics?scope=application", new Object[0]);
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(MpMetricTest.filterOutAppLabelPromMetrics(resp.getBody().asString()));
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).body(CoreMatchers.containsString((String)"# TYPE org_eclipse_microprofile_metrics_test_MetricAppBean_redCount_total counter"), new Matcher[0])).body(CoreMatchers.containsString((String)"# HELP org_eclipse_microprofile_metrics_test_MetricAppBean_redCount_total red-description"), new Matcher[0])).body(CoreMatchers.containsString((String)"org_eclipse_microprofile_metrics_test_MetricAppBean_redCount_total{mp_scope=\"application\",tier=\"integration\"} 0"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE org_eclipse_microprofile_metrics_test_MetricAppBean_blue_total counter"), new Matcher[0])).body(CoreMatchers.containsString((String)"# HELP org_eclipse_microprofile_metrics_test_MetricAppBean_blue_total"), new Matcher[0])).body(CoreMatchers.containsString((String)"org_eclipse_microprofile_metrics_test_MetricAppBean_blue_total{mp_scope=\"application\",tier=\"integration\"} 0"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE greenCount_total counter"), new Matcher[0])).body(CoreMatchers.containsString((String)"# HELP greenCount_total"), new Matcher[0])).body(CoreMatchers.containsString((String)"greenCount_total{mp_scope=\"application\",tier=\"integration\"} 0"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE purple_total counter"), new Matcher[0])).body(CoreMatchers.containsString((String)"# HELP purple_total"), new Matcher[0])).body(CoreMatchers.containsString((String)"purple_total{app=\"myShop\",mp_scope=\"application\",tier=\"integration\"} 0"), new Matcher[0])).body(CoreMatchers.containsString((String)"# HELP metricTest_test1_count_total"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE metricTest_test1_count_total counter"), new Matcher[0])).body(CoreMatchers.containsString((String)"metricTest_test1_count_total{mp_scope=\"application\",tier=\"integration\"} 1"), new Matcher[0])).body(CoreMatchers.containsString((String)"# HELP metricTest_test1_countMeA_total count-me-a-description"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE metricTest_test1_countMeA_total counter"), new Matcher[0])).body(CoreMatchers.containsString((String)"metricTest_test1_countMeA_total{mp_scope=\"application\",tier=\"integration\"} 1"), new Matcher[0])).body(CoreMatchers.containsString((String)"# HELP metricTest_test1_countMeB_jellybean_total"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE metricTest_test1_countMeB_jellybean_total counter"), new Matcher[0])).body(CoreMatchers.containsString((String)"metricTest_test1_countMeB_jellybean_total{mp_scope=\"application\",tier=\"integration\"} 1"), new Matcher[0])).body(CoreMatchers.containsString((String)"# HELP metricTest_test1_gauge_gigabytes"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE metricTest_test1_gauge_gigabytes gauge"), new Matcher[0])).body(CoreMatchers.containsString((String)"metricTest_test1_gauge_gigabytes{mp_scope=\"application\",tier=\"integration\"} 19"), new Matcher[0])).body(CoreMatchers.containsString((String)"# HELP org_eclipse_microprofile_metrics_test_MetricAppBean_gaugeMeA_kibibits gauge-me-a-description"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE org_eclipse_microprofile_metrics_test_MetricAppBean_gaugeMeA_kibibits gauge"), new Matcher[0])).body(CoreMatchers.containsString((String)"org_eclipse_microprofile_metrics_test_MetricAppBean_gaugeMeA_kibibits{mp_scope=\"application\",tier=\"integration\"} 1000"), new Matcher[0])).body(CoreMatchers.containsString((String)"# HELP org_eclipse_microprofile_metrics_test_MetricAppBean_gaugeMeB_hands"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE org_eclipse_microprofile_metrics_test_MetricAppBean_gaugeMeB_hands gauge"), new Matcher[0])).body(CoreMatchers.containsString((String)"org_eclipse_microprofile_metrics_test_MetricAppBean_gaugeMeB_hands{mp_scope=\"application\",tier=\"integration\"} 7777777"), new Matcher[0])).body(CoreMatchers.containsString((String)"# HELP metricTest_test1_histogram_bytes"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE metricTest_test1_histogram_bytes summary"), new Matcher[0])).body(CoreMatchers.containsString((String)"metricTest_test1_histogram_bytes{mp_scope=\"application\",tier=\"integration\",quantile=\"0.5\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"metricTest_test1_histogram_bytes{mp_scope=\"application\",tier=\"integration\",quantile=\"0.75\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"metricTest_test1_histogram_bytes{mp_scope=\"application\",tier=\"integration\",quantile=\"0.95\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"metricTest_test1_histogram_bytes{mp_scope=\"application\",tier=\"integration\",quantile=\"0.98\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"metricTest_test1_histogram_bytes{mp_scope=\"application\",tier=\"integration\",quantile=\"0.99\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"metricTest_test1_histogram_bytes{mp_scope=\"application\",tier=\"integration\",quantile=\"0.999\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"metricTest_test1_histogram_bytes_count{mp_scope=\"application\",tier=\"integration\"} 1000"), new Matcher[0])).body(CoreMatchers.containsString((String)"metricTest_test1_histogram_bytes_sum{mp_scope=\"application\",tier=\"integration\"} 499500"), new Matcher[0])).body(CoreMatchers.containsString((String)"# HELP metricTest_test1_histogram_bytes_max"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE metricTest_test1_histogram_bytes_max gauge"), new Matcher[0])).body(CoreMatchers.containsString((String)"metricTest_test1_histogram_bytes_max{mp_scope=\"application\",tier=\"integration\"} 999"), new Matcher[0])).body(CoreMatchers.containsString((String)"# HELP metricTest_test1_timer_seconds"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE metricTest_test1_timer_seconds summary"), new Matcher[0])).body(CoreMatchers.containsString((String)"metricTest_test1_timer_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.5\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"metricTest_test1_timer_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.75\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"metricTest_test1_timer_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.95\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"metricTest_test1_timer_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.98\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"metricTest_test1_timer_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.99\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"metricTest_test1_timer_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.999\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"metricTest_test1_timer_seconds_count{mp_scope=\"application\",tier=\"integration\"} 1"), new Matcher[0])).body(CoreMatchers.containsString((String)"metricTest_test1_timer_seconds_sum{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"# HELP metricTest_test1_timer_seconds_max"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE metricTest_test1_timer_seconds_max gauge"), new Matcher[0])).body(CoreMatchers.containsString((String)"metricTest_test1_timer_seconds_max{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"# HELP org_eclipse_microprofile_metrics_test_MetricAppBean_timeMeA_seconds"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE org_eclipse_microprofile_metrics_test_MetricAppBean_timeMeA_seconds summary"), new Matcher[0])).body(CoreMatchers.containsString((String)"org_eclipse_microprofile_metrics_test_MetricAppBean_timeMeA_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.5\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"org_eclipse_microprofile_metrics_test_MetricAppBean_timeMeA_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.75\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"org_eclipse_microprofile_metrics_test_MetricAppBean_timeMeA_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.95\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"org_eclipse_microprofile_metrics_test_MetricAppBean_timeMeA_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.98\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"org_eclipse_microprofile_metrics_test_MetricAppBean_timeMeA_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.99\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"org_eclipse_microprofile_metrics_test_MetricAppBean_timeMeA_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.999\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"org_eclipse_microprofile_metrics_test_MetricAppBean_timeMeA_seconds_count{mp_scope=\"application\",tier=\"integration\"} 1"), new Matcher[0])).body(CoreMatchers.containsString((String)"org_eclipse_microprofile_metrics_test_MetricAppBean_timeMeA_seconds_sum{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"# HELP org_eclipse_microprofile_metrics_test_MetricAppBean_timeMeA_seconds_max"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE org_eclipse_microprofile_metrics_test_MetricAppBean_timeMeA_seconds_max gauge"), new Matcher[0])).body(CoreMatchers.containsString((String)"org_eclipse_microprofile_metrics_test_MetricAppBean_timeMeA_seconds_max{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0]);
    }

    @Test
    @RunAsClient
    @InSequence(value=12)
    public void testMetricNameAcrossScopes() {
        Response resp = (Response)RestAssured.given().header("Accept", (Object)TEXT_PLAIN, new Object[0]).get("/metrics?name=sharedMetricName", new Object[0]);
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(MpMetricTest.filterOutAppLabelPromMetrics(resp.getBody().asString()));
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).body(CoreMatchers.containsString((String)"# TYPE sharedMetricName_total counter"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE sharedMetricName_seconds_max gauge"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE sharedMetricName_seconds summary"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE sharedMetricName_jelly gauge"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE sharedMetricName_marshmallow_max gauge"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE sharedMetricName_marshmallow summary"), new Matcher[0]);
    }

    @Test
    @RunAsClient
    @InSequence(value=13)
    public void testApplicationTagPromMetrics() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Accept", (Object)TEXT_PLAIN, new Object[0]).when().get("/metrics?scope=application&name=purple", new Object[0])).then()).statusCode(200)).and()).body(CoreMatchers.containsString((String)"tier=\"integration\""), new Matcher[0])).body(CoreMatchers.containsString((String)"app=\"myShop\""), new Matcher[0]);
    }

    @Test
    @RunAsClient
    @InSequence(value=14)
    public void testApplicationTimerUnitPromMetrics() {
        String prefix = "org_eclipse_microprofile_metrics_test_MetricAppBean_timeMeA_";
        Response resp = (Response)RestAssured.given().header("Accept", (Object)TEXT_PLAIN, new Object[0]).get("/metrics?scope=application&name=org.eclipse.microprofile.metrics.test.MetricAppBean.timeMeA", new Object[0]);
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(MpMetricTest.filterOutAppLabelPromMetrics(resp.getBody().asString()));
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).and()).body(CoreMatchers.containsString((String)("# TYPE " + prefix + "seconds summary")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "seconds_count")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "seconds_sum")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.5\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.75\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.95\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.98\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.99\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.999\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)("# TYPE " + prefix + "seconds_max gauge")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "seconds_max")), new Matcher[0]);
    }

    @Test
    @RunAsClient
    @InSequence(value=15)
    public void testApplicationHistogramUnitBytesPromMetrics() {
        String prefix = "metricTest_test1_histogram_";
        Response resp = (Response)RestAssured.given().header("Accept", (Object)TEXT_PLAIN, new Object[0]).get("/metrics?scope=application&name=metricTest.test1.histogram", new Object[0]);
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(MpMetricTest.filterOutAppLabelPromMetrics(resp.getBody().asString()));
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).and()).body(CoreMatchers.containsString((String)("# TYPE " + prefix + "bytes summary")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "bytes_count")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "bytes_sum")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "bytes{mp_scope=\"application\",tier=\"integration\",quantile=\"0.5\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "bytes{mp_scope=\"application\",tier=\"integration\",quantile=\"0.75\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "bytes{mp_scope=\"application\",tier=\"integration\",quantile=\"0.95\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "bytes{mp_scope=\"application\",tier=\"integration\",quantile=\"0.98\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "bytes{mp_scope=\"application\",tier=\"integration\",quantile=\"0.99\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "bytes{mp_scope=\"application\",tier=\"integration\",quantile=\"0.999\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)("# TYPE " + prefix + "bytes_max gauge")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "bytes_max")), new Matcher[0]);
    }

    @Test
    @RunAsClient
    @InSequence(value=16)
    public void testApplicationHistogramUnitNonePromMetrics() {
        String prefix = "metricTest_test1_histogram2";
        Response resp = (Response)RestAssured.given().header("Accept", (Object)TEXT_PLAIN, new Object[0]).get("/metrics?scope=application&name=metricTest.test1.histogram2", new Object[0]);
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(MpMetricTest.filterOutAppLabelPromMetrics(resp.getBody().asString()));
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).and()).body(CoreMatchers.containsString((String)("# TYPE " + prefix + " summary")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "_count")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "_sum")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "{mp_scope=\"application\",tier=\"integration\",quantile=\"0.5\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "{mp_scope=\"application\",tier=\"integration\",quantile=\"0.75\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "{mp_scope=\"application\",tier=\"integration\",quantile=\"0.95\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "{mp_scope=\"application\",tier=\"integration\",quantile=\"0.98\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "{mp_scope=\"application\",tier=\"integration\",quantile=\"0.99\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "{mp_scope=\"application\",tier=\"integration\",quantile=\"0.999\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)("# TYPE " + prefix + "_max gauge")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "_max")), new Matcher[0]);
    }

    @Test
    @RunAsClient
    @InSequence(value=17)
    public void testPromMetrics405NotGET() {
        ((ValidatableResponse)((Response)RestAssured.given().header("Accept", (Object)TEXT_PLAIN, new Object[0]).when().options("/metrics/application/metricTest.test1.histogram2", new Object[0])).then()).statusCode(405);
    }

    @Test
    @RunAsClient
    @InSequence(value=18)
    public void testNonStandardUnitsPromMetrics() {
        String prefix = "jellybeanHistogram_";
        Header wantPromMetricsFormat = new Header("Accept", TEXT_PLAIN);
        Response resp = (Response)RestAssured.given().header(wantPromMetricsFormat).get("/metrics?scope=application&name=jellybeanHistogram", new Object[0]);
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(MpMetricTest.filterOutAppLabelPromMetrics(resp.getBody().asString()));
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).and()).body(CoreMatchers.containsString((String)("# TYPE " + prefix + "jellybeans summary")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "jellybeans_count")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "jellybeans_sum")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "jellybeans{mp_scope=\"application\",tier=\"integration\",quantile=\"0.5\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "jellybeans{mp_scope=\"application\",tier=\"integration\",quantile=\"0.75\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "jellybeans{mp_scope=\"application\",tier=\"integration\",quantile=\"0.95\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "jellybeans{mp_scope=\"application\",tier=\"integration\",quantile=\"0.98\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "jellybeans{mp_scope=\"application\",tier=\"integration\",quantile=\"0.99\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "jellybeans{mp_scope=\"application\",tier=\"integration\",quantile=\"0.999\"}")), new Matcher[0])).body(CoreMatchers.containsString((String)("# TYPE " + prefix + "jellybeans_max gauge")), new Matcher[0])).body(CoreMatchers.containsString((String)(prefix + "jellybeans_max")), new Matcher[0]);
    }

    @Test
    @InSequence(value=19)
    public void testSetupPromNoBadCharsInNames() {
        this.metricAppBean.createPromMetrics();
    }

    @Test
    @RunAsClient
    @InSequence(value=20)
    public void testPromNoBadCharsInNames() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Accept", (Object)TEXT_PLAIN, new Object[0]).when().get("/metrics?scope=application", new Object[0])).then()).statusCode(200)).and()).body(CoreMatchers.containsString((String)"pm_counter_with_dashes"), new Matcher[0])).body(CoreMatchers.containsString((String)"pm_counter_hash_x_y_"), new Matcher[0])).body(CoreMatchers.containsString((String)"pm_counter_umlaut_"), new Matcher[0])).body(CoreMatchers.containsString((String)"pm_counter_accent_"), new Matcher[0]);
    }

    @Test
    @RunAsClient
    @InSequence(value=21)
    public void testAccept1() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Accept", (Object)"application/json;q=0.5,text/plain;q=0.5", new Object[0]).when().get("/metrics?scope=application", new Object[0])).then()).statusCode(200)).and()).contentType(TEXT_PLAIN);
    }

    @Test
    @RunAsClient
    @InSequence(value=22)
    public void testAccept2() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Accept", (Object)"application/json;q=0.1,text/plain;q=0.9", new Object[0]).when().get("/metrics?scope=application", new Object[0])).then()).statusCode(200)).and()).contentType(TEXT_PLAIN);
    }

    @Test
    @RunAsClient
    @InSequence(value=23)
    public void testAccept3() {
        ((ValidatableResponse)((Response)RestAssured.given().header("Accept", (Object)"image/png,image/jpeg", new Object[0]).when().get("/metrics?scope=application", new Object[0])).then()).statusCode(406);
    }

    @Test
    @RunAsClient
    @InSequence(value=24)
    public void testAccept4() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Accept", (Object)"*/*", new Object[0]).when().get("/metrics?scope=application", new Object[0])).then()).statusCode(200)).and()).contentType(TEXT_PLAIN);
    }

    @Test
    @RunAsClient
    @InSequence(value=25)
    public void testAccept5() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Accept", (Object)"image/png;q=1,*/*;q=0.1", new Object[0]).when().get("/metrics?scope=application", new Object[0])).then()).statusCode(200)).and()).contentType(TEXT_PLAIN);
    }

    @Test
    @RunAsClient
    @InSequence(value=26)
    public void testNoAcceptHeader() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/metrics?scope=application", new Object[0])).then()).statusCode(200)).and()).contentType(TEXT_PLAIN);
    }

    @Test
    @RunAsClient
    @InSequence(value=27)
    public void testCustomUnitAppendToGaugeName() {
        Header wantPromMetricsFormat = new Header("Accept", TEXT_PLAIN);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header(wantPromMetricsFormat).get("/metrics?scope=application", new Object[0])).then()).statusCode(200)).and()).body(CoreMatchers.containsString((String)"TYPE org_eclipse_microprofile_metrics_test_MetricAppBean_gaugeMeB_hands gauge"), new Matcher[0]);
    }

    @Test
    @RunAsClient
    @InSequence(value=28)
    public void testCustomUnitForCounter() {
        Header wantPromMetricsFormat = new Header("Accept", TEXT_PLAIN);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header(wantPromMetricsFormat).get("/metrics?scope=application", new Object[0])).then()).statusCode(200)).and()).body((Matcher)Matchers.anyOf((Matcher)CoreMatchers.containsString((String)"TYPE metricTest_test1_countMeB_jellybean_total counter"), (Matcher)CoreMatchers.containsString((String)"TYPE metricTest_test1_countMeB_jellybean counter")), new Matcher[0]);
    }

    @Test
    @RunAsClient
    @InSequence(value=29)
    public void testMultipleTaggedMetricsProm() {
        Header wantPrometheus = new Header("Accept", TEXT_PLAIN);
        Response resp = (Response)RestAssured.given().header(wantPrometheus).get("/metrics?scope=application", new Object[0]);
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(MpMetricTest.filterOutAppLabelPromMetrics(resp.getBody().asString()));
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).body(CoreMatchers.containsString((String)"# HELP org_eclipse_microprofile_metrics_test_MetricAppBean_noTagCounter_total"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE org_eclipse_microprofile_metrics_test_MetricAppBean_noTagCounter_total counter"), new Matcher[0])).body(CoreMatchers.containsString((String)"org_eclipse_microprofile_metrics_test_MetricAppBean_noTagCounter_total{mp_scope=\"application\",tier=\"integration\"} 0"), new Matcher[0])).body(CoreMatchers.containsString((String)"# HELP org_eclipse_microprofile_metrics_test_MetricAppBean_taggedCounter_total"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE org_eclipse_microprofile_metrics_test_MetricAppBean_taggedCounter_total counter"), new Matcher[0])).body(CoreMatchers.containsString((String)"org_eclipse_microprofile_metrics_test_MetricAppBean_taggedCounter_total{mp_scope=\"application\",number=\"one\",tier=\"integration\"} 0"), new Matcher[0])).body(CoreMatchers.containsString((String)"org_eclipse_microprofile_metrics_test_MetricAppBean_taggedCounter_total{mp_scope=\"application\",number=\"two\",tier=\"integration\"} 0"), new Matcher[0])).body(CoreMatchers.containsString((String)"# HELP taggedGauge"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE taggedGauge gauge"), new Matcher[0])).body(CoreMatchers.containsString((String)"taggedGauge{mp_scope=\"application\",number=\"one\",tier=\"integration\"} 1000"), new Matcher[0])).body(CoreMatchers.containsString((String)"taggedGauge{mp_scope=\"application\",number=\"two\",tier=\"integration\"} 1000"), new Matcher[0])).body(CoreMatchers.containsString((String)"# HELP noTagHistogram_marshmallow"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE noTagHistogram_marshmallow summary"), new Matcher[0])).body(CoreMatchers.containsString((String)"noTagHistogram_marshmallow{mp_scope=\"application\",tier=\"integration\",quantile=\"0.5\"} "), new Matcher[0])).body(CoreMatchers.containsString((String)"noTagHistogram_marshmallow{mp_scope=\"application\",tier=\"integration\",quantile=\"0.75\"} "), new Matcher[0])).body(CoreMatchers.containsString((String)"noTagHistogram_marshmallow{mp_scope=\"application\",tier=\"integration\",quantile=\"0.95\"} "), new Matcher[0])).body(CoreMatchers.containsString((String)"noTagHistogram_marshmallow{mp_scope=\"application\",tier=\"integration\",quantile=\"0.98\"} "), new Matcher[0])).body(CoreMatchers.containsString((String)"noTagHistogram_marshmallow{mp_scope=\"application\",tier=\"integration\",quantile=\"0.99\"} "), new Matcher[0])).body(CoreMatchers.containsString((String)"noTagHistogram_marshmallow{mp_scope=\"application\",tier=\"integration\",quantile=\"0.999\"} "), new Matcher[0])).body(CoreMatchers.containsString((String)"noTagHistogram_marshmallow_count{mp_scope=\"application\",tier=\"integration\"} 0"), new Matcher[0])).body(CoreMatchers.containsString((String)"noTagHistogram_marshmallow_sum{mp_scope=\"application\",tier=\"integration\"} "), new Matcher[0])).body(CoreMatchers.containsString((String)"# HELP noTagHistogram_marshmallow_max"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE noTagHistogram_marshmallow_max gauge"), new Matcher[0])).body(CoreMatchers.containsString((String)"noTagHistogram_marshmallow_max{mp_scope=\"application\",tier=\"integration\"} "), new Matcher[0])).body(CoreMatchers.containsString((String)"# HELP taggedHistogram_marshmallow"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE taggedHistogram_marshmallow summary"), new Matcher[0])).body(CoreMatchers.containsString((String)"taggedHistogram_marshmallow{mp_scope=\"application\",number=\"one\",tier=\"integration\",quantile=\"0.5\"} "), new Matcher[0])).body(CoreMatchers.containsString((String)"taggedHistogram_marshmallow{mp_scope=\"application\",number=\"one\",tier=\"integration\",quantile=\"0.75\"} "), new Matcher[0])).body(CoreMatchers.containsString((String)"taggedHistogram_marshmallow{mp_scope=\"application\",number=\"one\",tier=\"integration\",quantile=\"0.95\"} "), new Matcher[0])).body(CoreMatchers.containsString((String)"taggedHistogram_marshmallow{mp_scope=\"application\",number=\"one\",tier=\"integration\",quantile=\"0.98\"} "), new Matcher[0])).body(CoreMatchers.containsString((String)"taggedHistogram_marshmallow{mp_scope=\"application\",number=\"one\",tier=\"integration\",quantile=\"0.99\"} "), new Matcher[0])).body(CoreMatchers.containsString((String)"taggedHistogram_marshmallow{mp_scope=\"application\",number=\"one\",tier=\"integration\",quantile=\"0.999\"} "), new Matcher[0])).body(CoreMatchers.containsString((String)"taggedHistogram_marshmallow_count{mp_scope=\"application\",number=\"one\",tier=\"integration\"} 0"), new Matcher[0])).body(CoreMatchers.containsString((String)"taggedHistogram_marshmallow_sum{mp_scope=\"application\",number=\"one\",tier=\"integration\"} "), new Matcher[0])).body(CoreMatchers.containsString((String)"# HELP taggedHistogram_marshmallow_max"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE taggedHistogram_marshmallow_max gauge"), new Matcher[0])).body(CoreMatchers.containsString((String)"taggedHistogram_marshmallow_max{mp_scope=\"application\",number=\"one\",tier=\"integration\"} "), new Matcher[0])).body(CoreMatchers.containsString((String)"taggedHistogram_marshmallow{mp_scope=\"application\",number=\"two\",tier=\"integration\",quantile=\"0.5\"} "), new Matcher[0])).body(CoreMatchers.containsString((String)"taggedHistogram_marshmallow{mp_scope=\"application\",number=\"two\",tier=\"integration\",quantile=\"0.75\"} "), new Matcher[0])).body(CoreMatchers.containsString((String)"taggedHistogram_marshmallow{mp_scope=\"application\",number=\"two\",tier=\"integration\",quantile=\"0.95\"} "), new Matcher[0])).body(CoreMatchers.containsString((String)"taggedHistogram_marshmallow{mp_scope=\"application\",number=\"two\",tier=\"integration\",quantile=\"0.98\"} "), new Matcher[0])).body(CoreMatchers.containsString((String)"taggedHistogram_marshmallow{mp_scope=\"application\",number=\"two\",tier=\"integration\",quantile=\"0.99\"} "), new Matcher[0])).body(CoreMatchers.containsString((String)"taggedHistogram_marshmallow{mp_scope=\"application\",number=\"two\",tier=\"integration\",quantile=\"0.999\"} "), new Matcher[0])).body(CoreMatchers.containsString((String)"taggedHistogram_marshmallow_count{mp_scope=\"application\",number=\"two\",tier=\"integration\"} 0"), new Matcher[0])).body(CoreMatchers.containsString((String)"taggedHistogram_marshmallow_sum{mp_scope=\"application\",number=\"two\",tier=\"integration\"} "), new Matcher[0])).body(CoreMatchers.containsString((String)"taggedHistogram_marshmallow_max{mp_scope=\"application\",number=\"two\",tier=\"integration\"} "), new Matcher[0])).body(CoreMatchers.containsString((String)"# HELP noTagTimer_seconds"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE noTagTimer_seconds summary"), new Matcher[0])).body(CoreMatchers.containsString((String)"noTagTimer_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.5\"} "), new Matcher[0])).body(CoreMatchers.containsString((String)"noTagTimer_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.75\"} "), new Matcher[0])).body(CoreMatchers.containsString((String)"noTagTimer_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.95\"} "), new Matcher[0])).body(CoreMatchers.containsString((String)"noTagTimer_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.98\"} "), new Matcher[0])).body(CoreMatchers.containsString((String)"noTagTimer_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.99\"} "), new Matcher[0])).body(CoreMatchers.containsString((String)"noTagTimer_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.999\"} "), new Matcher[0])).body(CoreMatchers.containsString((String)"noTagTimer_seconds_count{mp_scope=\"application\",tier=\"integration\"} 0"), new Matcher[0])).body(CoreMatchers.containsString((String)"noTagTimer_seconds_sum{mp_scope=\"application\",tier=\"integration\"} "), new Matcher[0])).body(CoreMatchers.containsString((String)"# HELP noTagTimer_seconds_max"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE noTagTimer_seconds_max gauge"), new Matcher[0])).body(CoreMatchers.containsString((String)"noTagTimer_seconds_max{mp_scope=\"application\",tier=\"integration\"} "), new Matcher[0])).body(CoreMatchers.containsString((String)"# HELP taggedTimer_seconds"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE taggedTimer_seconds summary"), new Matcher[0])).body(CoreMatchers.containsString((String)"taggedTimer_seconds{mp_scope=\"application\",number=\"one\",tier=\"integration\",quantile=\"0.5\"} "), new Matcher[0])).body(CoreMatchers.containsString((String)"taggedTimer_seconds{mp_scope=\"application\",number=\"one\",tier=\"integration\",quantile=\"0.75\"} "), new Matcher[0])).body(CoreMatchers.containsString((String)"taggedTimer_seconds{mp_scope=\"application\",number=\"one\",tier=\"integration\",quantile=\"0.95\"} "), new Matcher[0])).body(CoreMatchers.containsString((String)"taggedTimer_seconds{mp_scope=\"application\",number=\"one\",tier=\"integration\",quantile=\"0.98\"} "), new Matcher[0])).body(CoreMatchers.containsString((String)"taggedTimer_seconds{mp_scope=\"application\",number=\"one\",tier=\"integration\",quantile=\"0.99\"} "), new Matcher[0])).body(CoreMatchers.containsString((String)"taggedTimer_seconds{mp_scope=\"application\",number=\"one\",tier=\"integration\",quantile=\"0.999\"} "), new Matcher[0])).body(CoreMatchers.containsString((String)"taggedTimer_seconds_count{mp_scope=\"application\",number=\"one\",tier=\"integration\"} 0"), new Matcher[0])).body(CoreMatchers.containsString((String)"taggedTimer_seconds_sum{mp_scope=\"application\",number=\"one\",tier=\"integration\"} "), new Matcher[0])).body(CoreMatchers.containsString((String)"# HELP taggedTimer_seconds_max"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE taggedTimer_seconds_max gauge"), new Matcher[0])).body(CoreMatchers.containsString((String)"taggedTimer_seconds_max{mp_scope=\"application\",number=\"one\",tier=\"integration\"} "), new Matcher[0])).body(CoreMatchers.containsString((String)"taggedTimer_seconds{mp_scope=\"application\",number=\"two\",tier=\"integration\",quantile=\"0.5\"} "), new Matcher[0])).body(CoreMatchers.containsString((String)"taggedTimer_seconds{mp_scope=\"application\",number=\"two\",tier=\"integration\",quantile=\"0.75\"} "), new Matcher[0])).body(CoreMatchers.containsString((String)"taggedTimer_seconds{mp_scope=\"application\",number=\"two\",tier=\"integration\",quantile=\"0.95\"} "), new Matcher[0])).body(CoreMatchers.containsString((String)"taggedTimer_seconds{mp_scope=\"application\",number=\"two\",tier=\"integration\",quantile=\"0.98\"} "), new Matcher[0])).body(CoreMatchers.containsString((String)"taggedTimer_seconds{mp_scope=\"application\",number=\"two\",tier=\"integration\",quantile=\"0.99\"} "), new Matcher[0])).body(CoreMatchers.containsString((String)"taggedTimer_seconds{mp_scope=\"application\",number=\"two\",tier=\"integration\",quantile=\"0.999\"} "), new Matcher[0])).body(CoreMatchers.containsString((String)"taggedTimer_seconds_count{mp_scope=\"application\",number=\"two\",tier=\"integration\"} 0"), new Matcher[0])).body(CoreMatchers.containsString((String)"taggedTimer_seconds_sum{mp_scope=\"application\",number=\"two\",tier=\"integration\"} "), new Matcher[0])).body(CoreMatchers.containsString((String)"taggedTimer_seconds_max{mp_scope=\"application\",number=\"two\",tier=\"integration\"} "), new Matcher[0]);
    }
}

