/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.openapi.tck;

import io.restassured.response.ValidatableResponse;
import org.eclipse.microprofile.openapi.apps.scanconfig.ScanConfigApplication;
import org.eclipse.microprofile.openapi.apps.scanconfig.a.AResource;
import org.eclipse.microprofile.openapi.apps.scanconfig.a.b.BResource;
import org.eclipse.microprofile.openapi.apps.scanconfig.a.b.c.CResource;
import org.eclipse.microprofile.openapi.apps.scanconfig.x.y.YResource;
import org.eclipse.microprofile.openapi.tck.AppTestBase;
import org.eclipse.microprofile.openapi.tck.utils.ConfigAsset;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.annotations.Test;

public class OASScanConfigTests {
    private static WebArchive scanConfigApp(String name, ConfigAsset config) {
        return (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)name)).addPackages(true, new Package[]{ScanConfigApplication.class.getPackage()})).addAsManifestResource((Asset)config, "microprofile-config.properties");
    }

    private static void assertPaths(ValidatableResponse vr, String ... paths) {
        for (String path : paths) {
            vr.body("paths", Matchers.hasKey((Object)path), new Object[0]);
        }
        vr.body("paths", Matchers.aMapWithSize((int)paths.length), new Object[0]);
    }

    public static class ScanConfigPartialPackage
    extends AppTestBase {
        @Deployment
        public static WebArchive deployment() {
            ConfigAsset config = new ConfigAsset().put("mp.openapi.scan.packages", "a.b.c");
            return OASScanConfigTests.scanConfigApp("scanConfigPartialPackage.war", config);
        }

        @RunAsClient
        @Test(dataProvider="formatProvider")
        public void testPartialPackage(String type) {
            OASScanConfigTests.assertPaths(this.callEndpoint(type), new String[0]);
        }
    }

    public static class ScanConfigPackageIncludeClassExclude
    extends AppTestBase {
        @Deployment
        public static WebArchive deployment() {
            ConfigAsset config = new ConfigAsset().put("mp.openapi.scan.packages", AResource.class.getPackage().getName()).put("mp.openapi.scan.exclude.classes", AResource.class.getName());
            return OASScanConfigTests.scanConfigApp("scanConfigPackageIncludeClassExclude.war", config);
        }

        @RunAsClient
        @Test(dataProvider="formatProvider")
        public void testPackageIncludeClassExclude(String type) {
            OASScanConfigTests.assertPaths(this.callEndpoint(type), new String[]{"/b", "/c"});
        }
    }

    public static class ScanConfigPackageExcludeClassInclude
    extends AppTestBase {
        @Deployment
        public static WebArchive deployment() {
            ConfigAsset config = new ConfigAsset().put("mp.openapi.scan.classes", AResource.class.getName()).put("mp.openapi.scan.exclude.packages", AResource.class.getPackage().getName());
            return OASScanConfigTests.scanConfigApp("scanConfigPackageExcludeClassInclude.war", config);
        }

        @RunAsClient
        @Test(dataProvider="formatProvider")
        public void testPackageExcludeClassInclude(String type) {
            OASScanConfigTests.assertPaths(this.callEndpoint(type), new String[]{"/a"});
        }
    }

    public static class ScanConfigPackageExcludesAroundInclude
    extends AppTestBase {
        @Deployment
        public static WebArchive deployment() {
            ConfigAsset config = new ConfigAsset().put("mp.openapi.scan.packages", BResource.class.getPackage().getName()).put("mp.openapi.scan.exclude.packages", AResource.class.getPackage().getName(), CResource.class.getPackage().getName());
            return OASScanConfigTests.scanConfigApp("scanConfigPackageExcludesAroundInclude.war", config);
        }

        @RunAsClient
        @Test(dataProvider="formatProvider")
        public void testPackageExcludesAroundInclude(String type) {
            OASScanConfigTests.assertPaths(this.callEndpoint(type), new String[]{"/b"});
        }
    }

    public static class ScanConfigPackageIncludesAroundExcludes
    extends AppTestBase {
        @Deployment
        public static WebArchive deployment() {
            ConfigAsset config = new ConfigAsset().put("mp.openapi.scan.packages", AResource.class.getPackage().getName(), CResource.class.getPackage().getName()).put("mp.openapi.scan.exclude.packages", BResource.class.getPackage().getName());
            return OASScanConfigTests.scanConfigApp("scanConfigPackageIncludesAroundExcludes.war", config);
        }

        @RunAsClient
        @Test(dataProvider="formatProvider")
        public void testPackageIncludesAroundExcludes(String type) {
            OASScanConfigTests.assertPaths(this.callEndpoint(type), new String[]{"/a", "/c"});
        }
    }

    public static class ScanConfigPackageExcludeMultiple
    extends AppTestBase {
        @Deployment
        public static WebArchive deployment() {
            ConfigAsset config = new ConfigAsset().put("mp.openapi.scan.exclude.packages", BResource.class.getPackage().getName(), YResource.class.getPackage().getName());
            return OASScanConfigTests.scanConfigApp("scanConfigPackageExcludeMultiple.war", config);
        }

        @RunAsClient
        @Test(dataProvider="formatProvider")
        public void testPackageExcludeMultiple(String type) {
            OASScanConfigTests.assertPaths(this.callEndpoint(type), new String[]{"/a", "/x"});
        }
    }

    public static class ScanConfigPackageExcludeOnly
    extends AppTestBase {
        @Deployment
        public static WebArchive deployment() {
            ConfigAsset config = new ConfigAsset().put("mp.openapi.scan.exclude.packages", BResource.class.getPackage().getName());
            return OASScanConfigTests.scanConfigApp("scanConfigPackageExcludeOnly.war", config);
        }

        @RunAsClient
        @Test(dataProvider="formatProvider")
        public void testPackageExcludeOnly(String type) {
            OASScanConfigTests.assertPaths(this.callEndpoint(type), new String[]{"/a", "/x", "/y"});
        }
    }

    public static class ScanConfigExcludeMultiple
    extends AppTestBase {
        @Deployment
        public static WebArchive deployment() {
            ConfigAsset config = new ConfigAsset().put("mp.openapi.scan.exclude.classes", BResource.class.getName(), YResource.class.getName());
            return OASScanConfigTests.scanConfigApp("scanConfigExcludeMultiple.war", config);
        }

        @RunAsClient
        @Test(dataProvider="formatProvider")
        public void testExcludeMultiple(String type) {
            OASScanConfigTests.assertPaths(this.callEndpoint(type), new String[]{"/a", "/c", "/x"});
        }
    }

    public static class ScanConfigExcludeOnly
    extends AppTestBase {
        @Deployment
        public static WebArchive deployment() {
            ConfigAsset config = new ConfigAsset().put("mp.openapi.scan.exclude.classes", BResource.class.getName());
            return OASScanConfigTests.scanConfigApp("scanConfigExcludeOnly.war", config);
        }

        @RunAsClient
        @Test(dataProvider="formatProvider")
        public void testExcludeOnly(String type) {
            OASScanConfigTests.assertPaths(this.callEndpoint(type), new String[]{"/a", "/c", "/x", "/y"});
        }
    }

    public static class ScanConfigPackageIncludeMultiple
    extends AppTestBase {
        @Deployment
        public static WebArchive deployment() {
            ConfigAsset config = new ConfigAsset().put("mp.openapi.scan.packages", BResource.class.getPackage().getName(), YResource.class.getPackage().getName());
            return OASScanConfigTests.scanConfigApp("scanConfigPackageIncludeMultiple.war", config);
        }

        @RunAsClient
        @Test(dataProvider="formatProvider")
        public void testPackageIncludeMultiple(String type) {
            OASScanConfigTests.assertPaths(this.callEndpoint(type), new String[]{"/b", "/c", "/y"});
        }
    }

    public static class ScanConfigPackageIncludeOnly
    extends AppTestBase {
        @Deployment
        public static WebArchive deployment() {
            ConfigAsset config = new ConfigAsset().put("mp.openapi.scan.packages", BResource.class.getPackage().getName());
            return OASScanConfigTests.scanConfigApp("scanConfigPackageIncludeOnly.war", config);
        }

        @RunAsClient
        @Test(dataProvider="formatProvider")
        public void testPackageIncludeOnly(String type) {
            OASScanConfigTests.assertPaths(this.callEndpoint(type), new String[]{"/b", "/c"});
        }
    }

    public static class ScanConfigIncludeMultiple
    extends AppTestBase {
        @Deployment
        public static WebArchive deployment() {
            ConfigAsset config = new ConfigAsset().put("mp.openapi.scan.classes", BResource.class.getName(), YResource.class.getName());
            return OASScanConfigTests.scanConfigApp("scanConfigIncludeMultiple.war", config);
        }

        @RunAsClient
        @Test(dataProvider="formatProvider")
        public void testIncludeMultiple(String type) {
            OASScanConfigTests.assertPaths(this.callEndpoint(type), new String[]{"/b", "/y"});
        }
    }

    public static class ScanConfigIncludeOnly
    extends AppTestBase {
        @Deployment
        public static WebArchive deployment() {
            ConfigAsset config = new ConfigAsset().put("mp.openapi.scan.classes", BResource.class.getName());
            return OASScanConfigTests.scanConfigApp("scanConfigIncludeOnly.war", config);
        }

        @RunAsClient
        @Test(dataProvider="formatProvider")
        public void testIncludeOnly(String type) {
            OASScanConfigTests.assertPaths(this.callEndpoint(type), new String[]{"/b"});
        }
    }
}

