/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.openapi.tck;

import io.restassured.response.ValidatableResponse;
import org.eclipse.microprofile.openapi.tck.AppTestBase;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsMapWithSize;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.annotations.Test;

public class StaticDocumentTest
extends AppTestBase {
    @Deployment(name="static", testable=false)
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"static.war")).addAsManifestResource("simpleapi.yaml", "openapi.yaml");
    }

    @Test(dataProvider="formatProvider")
    public void testStaticDocument(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        vr.body("openapi", Matchers.startsWith((String)"3.0."), new Object[0]);
        vr.body("servers", Matchers.hasSize((int)1), new Object[0]);
        vr.body("servers.find{ it.description == 'MySimpleAPI' }.url", Matchers.equalTo((Object)"https:///MySimpleAPI/1.0.0"), new Object[0]);
        vr.body("info.description", Matchers.equalTo((Object)"This is a simple API"), new Object[0]);
        vr.body("info.version", Matchers.equalTo((Object)"1.0.0"), new Object[0]);
        vr.body("info.title", Matchers.equalTo((Object)"Simple Inventory API"), new Object[0]);
        vr.body("info.contact.email", Matchers.equalTo((Object)"you@your-company.com"), new Object[0]);
        vr.body("info.license.name", Matchers.equalTo((Object)"Apache 2.0"), new Object[0]);
        vr.body("info.license.url", Matchers.equalTo((Object)"http://www.apache.org/licenses/LICENSE-2.0.html"), new Object[0]);
        vr.body("tags", Matchers.hasSize((int)2), new Object[0]);
        vr.body("tags.find{ it.name == 'admins' }.description", Matchers.equalTo((Object)"Secured Admin-only calls"), new Object[0]);
        vr.body("tags.find{ it.name == 'developers' }.description", Matchers.equalTo((Object)"Operations available to regular developers"), new Object[0]);
        String inventoryPathGet = "paths.'/inventory'.get";
        vr.body("paths.'/inventory'.get.tags", (Matcher)Matchers.both((Matcher)Matchers.hasSize((int)1)).and(Matchers.contains((Object[])new Object[]{"developers"})), new Object[0]);
        vr.body("paths.'/inventory'.get.summary", Matchers.equalTo((Object)"searches inventory"), new Object[0]);
        vr.body("paths.'/inventory'.get.operationId", Matchers.equalTo((Object)"searchInventory"), new Object[0]);
        vr.body("paths.'/inventory'.get.description", (Matcher)Matchers.both((Matcher)Matchers.containsString((String)"By passing in the appropriate options, you can search for")).and(Matchers.containsString((String)"available inventory in the system")), new Object[0]);
        vr.body("paths.'/inventory'.get.parameters", Matchers.hasSize((int)3), new Object[0]);
        vr.body("paths.'/inventory'.get.parameters.find{ it.name == 'searchString' }.description", Matchers.equalTo((Object)"pass an optional search string for looking up inventory"), new Object[0]);
        vr.body("paths.'/inventory'.get.parameters.find{ it.name == 'skip' }.description", Matchers.equalTo((Object)"number of records to skip for pagination"), new Object[0]);
        vr.body("paths.'/inventory'.get.parameters.find{ it.name == 'limit' }.description", Matchers.equalTo((Object)"maximum number of records to return"), new Object[0]);
        vr.body("paths.'/inventory'.get.responses", IsMapWithSize.aMapWithSize((int)2), new Object[0]);
        vr.body("paths.'/inventory'.get.responses.'200'.description", Matchers.equalTo((Object)"search results matching criteria"), new Object[0]);
        vr.body("paths.'/inventory'.get.responses.'400'.description", Matchers.equalTo((Object)"bad input parameter"), new Object[0]);
        String inventoryPathPost = "paths.'/inventory'.post";
        vr.body("paths.'/inventory'.post.tags", (Matcher)Matchers.both((Matcher)Matchers.hasSize((int)1)).and(Matchers.contains((Object[])new Object[]{"admins"})), new Object[0]);
        vr.body("paths.'/inventory'.post.summary", Matchers.equalTo((Object)"adds an inventory item"), new Object[0]);
        vr.body("paths.'/inventory'.post.operationId", Matchers.equalTo((Object)"addInventory"), new Object[0]);
        vr.body("paths.'/inventory'.post.description", Matchers.equalTo((Object)"Adds an item to the system"), new Object[0]);
        vr.body("paths.'/inventory'.post.responses", IsMapWithSize.aMapWithSize((int)3), new Object[0]);
        vr.body("paths.'/inventory'.post.responses.'201'.description", Matchers.equalTo((Object)"item created"), new Object[0]);
        vr.body("paths.'/inventory'.post.responses.'400'.description", Matchers.equalTo((Object)"invalid input, object invalid"), new Object[0]);
        vr.body("paths.'/inventory'.post.responses.'409'.description", Matchers.equalTo((Object)"an existing item already exists"), new Object[0]);
        String inventoryPathPut = "paths.'/inventory'.put";
        vr.body("paths.'/inventory'.put.summary", Matchers.equalTo((Object)"put operation"), new Object[0]);
        vr.body("paths.'/inventory'.put.operationId", Matchers.equalTo((Object)"putInventory"), new Object[0]);
        vr.body("paths.'/inventory'.put.description", Matchers.equalTo((Object)"tests the put operation"), new Object[0]);
        String inventoryPathDelete = "paths.'/inventory'.delete";
        vr.body("paths.'/inventory'.delete.summary", Matchers.equalTo((Object)"delete operation"), new Object[0]);
        vr.body("paths.'/inventory'.delete.operationId", Matchers.equalTo((Object)"deleteInventory"), new Object[0]);
        vr.body("paths.'/inventory'.delete.description", Matchers.equalTo((Object)"tests the delete operation"), new Object[0]);
        String inventoryPathOptions = "paths.'/inventory'.options";
        vr.body("paths.'/inventory'.options.summary", Matchers.equalTo((Object)"options operation"), new Object[0]);
        vr.body("paths.'/inventory'.options.operationId", Matchers.equalTo((Object)"optionsInventory"), new Object[0]);
        vr.body("paths.'/inventory'.options.description", Matchers.equalTo((Object)"tests the options operation"), new Object[0]);
        String inventoryPathHead = "paths.'/inventory'.head";
        vr.body("paths.'/inventory'.head.summary", Matchers.equalTo((Object)"head operation"), new Object[0]);
        vr.body("paths.'/inventory'.head.operationId", Matchers.equalTo((Object)"headInventory"), new Object[0]);
        vr.body("paths.'/inventory'.head.description", Matchers.equalTo((Object)"tests the head operation"), new Object[0]);
        String inventoryPathPatch = "paths.'/inventory'.patch";
        vr.body("paths.'/inventory'.patch.summary", Matchers.equalTo((Object)"patch operation"), new Object[0]);
        vr.body("paths.'/inventory'.patch.operationId", Matchers.equalTo((Object)"patchInventory"), new Object[0]);
        vr.body("paths.'/inventory'.patch.description", Matchers.equalTo((Object)"tests the patch operation"), new Object[0]);
        String inventoryPathTrace = "paths.'/inventory'.trace";
        vr.body("paths.'/inventory'.trace.summary", Matchers.equalTo((Object)"trace operation"), new Object[0]);
        vr.body("paths.'/inventory'.trace.operationId", Matchers.equalTo((Object)"traceInventory"), new Object[0]);
        vr.body("paths.'/inventory'.trace.description", Matchers.equalTo((Object)"tests the trace operation"), new Object[0]);
    }
}

