/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.messaging.tck.metrics;

import java.util.ServiceLoader;
import java.util.SortedMap;
import javax.inject.Inject;
import org.awaitility.Awaitility;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.annotation.RegistryType;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.messaging.spi.Connector;
import org.eclipse.microprofile.reactive.messaging.tck.ArchiveExtender;
import org.eclipse.microprofile.reactive.messaging.tck.metrics.ConfigAsset;
import org.eclipse.microprofile.reactive.messaging.tck.metrics.MetricsTestBean;
import org.eclipse.microprofile.reactive.messaging.tck.metrics.TestConnector;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class MetricsTest {
    @Inject
    @Connector(value="test-connector")
    private TestConnector testConnector;
    @Inject
    @RegistryType(type=MetricRegistry.Type.BASE)
    private MetricRegistry metricRegistry;
    @Inject
    private MetricsTestBean testBean;

    @Deployment
    public static JavaArchive deployment() {
        ConfigAsset config = new ConfigAsset().put("mp.messaging.incoming.channel-connector-in.connector", "test-connector").put("mp.messaging.outgoing.channel-connector-out.connector", "test-connector");
        JavaArchive archive = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{MetricsTestBean.class, TestConnector.class})).addAsResource((Asset)config, "META-INF/microprofile-config.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        ServiceLoader.load(ArchiveExtender.class).iterator().forEachRemaining(ext -> ext.extend(archive));
        return archive;
    }

    @Test
    public void testMetricsConnector() {
        this.testConnector.send("channel-connector-in", (Message<String>)Message.of((Object)"one"));
        this.testConnector.send("channel-connector-in", (Message<String>)Message.of((Object)"two"));
        Assert.assertEquals((Object)"one-test-1", (Object)this.testConnector.get("channel-connector-out").getPayload());
        Assert.assertEquals((Object)"one-test-2", (Object)this.testConnector.get("channel-connector-out").getPayload());
        Assert.assertEquals((Object)"two-test-1", (Object)this.testConnector.get("channel-connector-out").getPayload());
        Assert.assertEquals((Object)"two-test-2", (Object)this.testConnector.get("channel-connector-out").getPayload());
        Counter channelInCounter = this.getMessageCounterForChannel("channel-connector-in");
        Counter channelProcessCounter = this.getMessageCounterForChannel("channel-connector-process");
        Counter channelOutCounter = this.getMessageCounterForChannel("channel-connector-out");
        Assert.assertEquals((long)2L, (long)channelInCounter.getCount());
        Assert.assertEquals((long)2L, (long)channelProcessCounter.getCount());
        Assert.assertEquals((long)4L, (long)channelOutCounter.getCount());
    }

    @Test
    public void testMetricsInApp() {
        Awaitility.await().until(this.testBean::getInAppMessagesReceived, Matchers.equalTo((Object)6));
        Counter appACounter = this.getMessageCounterForChannel("channel-app-a");
        Counter appBCounter = this.getMessageCounterForChannel("channel-app-b");
        Assert.assertEquals((long)3L, (long)appACounter.getCount());
        Assert.assertEquals((long)6L, (long)appBCounter.getCount());
    }

    private Counter getMessageCounterForChannel(String channel) {
        SortedMap counters = this.metricRegistry.getCounters((id, m) -> id.getName().equals("mp.messaging.message.count") && id.getTags().getOrDefault("channel", "").equals(channel));
        Assert.assertThat(counters.entrySet(), (Matcher)Matchers.hasSize((int)1));
        return (Counter)counters.values().iterator().next();
    }
}

