/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.streams.operators.tck.spi;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.eclipse.microprofile.reactive.streams.operators.ProcessorBuilder;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.AbstractStageVerification;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.QuietRuntimeException;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.ReactiveStreamsSpiVerification;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.testng.Assert;
import org.testng.annotations.Test;

public class FilterStageVerification
extends AbstractStageVerification {
    FilterStageVerification(ReactiveStreamsSpiVerification.VerificationDeps deps) {
        super(deps);
    }

    @Test
    public void filterStageShouldFilterElements() {
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).filter(i -> (i & 1) == 1).toList().run(this.getEngine()))), Arrays.asList(1, 3, 5));
    }

    @Test(expectedExceptions={QuietRuntimeException.class}, expectedExceptionsMessageRegExp="failed")
    public void filterStageShouldPropagateExceptions() {
        CompletableFuture cancelled = new CompletableFuture();
        CompletionStage result = this.infiniteStream().onTerminate(() -> cancelled.complete(null)).filter(foo -> {
            throw new QuietRuntimeException("failed");
        }).toList().run(this.getEngine());
        this.await(cancelled);
        this.await(result);
    }

    @Test(expectedExceptions={QuietRuntimeException.class}, expectedExceptionsMessageRegExp="failed")
    public void filterStageShouldPropagateUpstreamExceptions() {
        this.await(this.rs.failed((Throwable)new QuietRuntimeException("failed")).filter(foo -> true).toList().run(this.getEngine()));
    }

    @Test
    public void filterStageShouldPropagateCancel() {
        CompletableFuture cancelled = new CompletableFuture();
        this.await(this.infiniteStream().onTerminate(() -> cancelled.complete(null)).filter(i -> i < 3).cancel().run(this.getEngine()));
        this.await(cancelled);
    }

    @Test
    public void filterStageBuilderShouldBeReusable() {
        ProcessorBuilder filter = this.rs.builder().filter(i -> i < 3);
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.of((Object[])new Integer[]{1, 2, 3}).via(filter).toList().run(this.getEngine()))), Arrays.asList(1, 2));
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.of((Object[])new Integer[]{1, 2, 3}).via(filter).toList().run(this.getEngine()))), Arrays.asList(1, 2));
    }

    @Override
    List<Object> reactiveStreamsTckVerifiers() {
        return Collections.singletonList(new ProcessorVerification());
    }

    class ProcessorVerification
    extends AbstractStageVerification.StageProcessorVerification<Integer> {
        ProcessorVerification() {
            super(FilterStageVerification.this);
        }

        public Processor<Integer, Integer> createIdentityProcessor(int bufferSize) {
            return FilterStageVerification.this.rs.builder().filter(i -> true).buildRs(FilterStageVerification.this.getEngine());
        }

        @Override
        public Publisher<Integer> createFailedPublisher() {
            return FilterStageVerification.this.rs.failed((Throwable)new RuntimeException("failed")).filter(i -> true).buildRs(FilterStageVerification.this.getEngine());
        }

        public Integer createElement(int element) {
            return element;
        }
    }
}

