/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.streams.operators.tck.spi;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.eclipse.microprofile.reactive.streams.operators.ProcessorBuilder;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.AbstractStageVerification;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.QuietRuntimeException;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.ReactiveStreamsSpiVerification;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.testng.Assert;
import org.testng.annotations.Test;

public class FlatMapIterableStageVerification
extends AbstractStageVerification {
    FlatMapIterableStageVerification(ReactiveStreamsSpiVerification.VerificationDeps deps) {
        super(deps);
    }

    @Test
    public void flatMapIterableStageShouldMapElements() {
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.of((Object[])new Integer[]{1, 2, 3}).flatMapIterable(n -> Arrays.asList(n, n, n)).toList().run(this.getEngine()))), Arrays.asList(1, 1, 1, 2, 2, 2, 3, 3, 3));
    }

    @Test
    public void flatMapIterableStageShouldSupportEmptyMappingOfElements() {
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.of((Object[])new Integer[]{1, 2, 3}).flatMapIterable(n -> Collections.emptyList()).toList().run(this.getEngine()))), Collections.emptyList());
    }

    @Test(expectedExceptions={QuietRuntimeException.class}, expectedExceptionsMessageRegExp="failed")
    public void flatMapIterableStageShouldHandleExceptionsInCallback() {
        CompletableFuture cancelled = new CompletableFuture();
        CompletionStage result = this.infiniteStream().onTerminate(() -> cancelled.complete(null)).flatMapIterable(foo -> {
            throw new QuietRuntimeException("failed");
        }).toList().run(this.getEngine());
        this.await(cancelled);
        this.await(result);
    }

    @Test(expectedExceptions={QuietRuntimeException.class}, expectedExceptionsMessageRegExp="failed")
    public void flatMapIterableStageShouldHandleExceptionsInIterableIterateMethod() {
        CompletableFuture cancelled = new CompletableFuture();
        CompletionStage result = this.infiniteStream().onTerminate(() -> cancelled.complete(null)).flatMapIterable(foo -> () -> {
            throw new QuietRuntimeException("failed");
        }).toList().run(this.getEngine());
        this.await(cancelled);
        this.await(result);
    }

    @Test(expectedExceptions={QuietRuntimeException.class}, expectedExceptionsMessageRegExp="failed")
    public void flatMapIterableStageShouldHandleExceptionsInIteratorHasNextMethod() {
        CompletableFuture cancelled = new CompletableFuture();
        CompletionStage result = this.infiniteStream().onTerminate(() -> cancelled.complete(null)).flatMapIterable(foo -> () -> new Iterator<Object>(){

            @Override
            public boolean hasNext() {
                throw new QuietRuntimeException("failed");
            }

            @Override
            public Object next() {
                return null;
            }
        }).toList().run(this.getEngine());
        this.await(cancelled);
        this.await(result);
    }

    @Test(expectedExceptions={QuietRuntimeException.class}, expectedExceptionsMessageRegExp="failed")
    public void flatMapIterableStageShouldHandleExceptionsInIteratorNextMethod() {
        CompletableFuture cancelled = new CompletableFuture();
        CompletionStage result = this.infiniteStream().onTerminate(() -> cancelled.complete(null)).flatMapIterable(foo -> () -> new Iterator<Object>(){

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public Object next() {
                throw new QuietRuntimeException("failed");
            }
        }).toList().run(this.getEngine());
        this.await(cancelled);
        this.await(result);
    }

    @Test(expectedExceptions={QuietRuntimeException.class}, expectedExceptionsMessageRegExp="failed")
    public void flatMapIterableStageShouldPropagateUpstreamExceptions() {
        this.await(this.rs.failed((Throwable)new QuietRuntimeException("failed")).flatMapIterable(Collections::singletonList).toList().run(this.getEngine()));
    }

    @Test
    public void flatMapIterableBuilderShouldBeReusable() {
        ProcessorBuilder mapper = this.rs.builder().flatMapIterable(i -> Arrays.asList(i, i));
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.of((Object[])new Integer[]{1, 2}).via(mapper).toList().run(this.getEngine()))), Arrays.asList(1, 1, 2, 2));
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.of((Object[])new Integer[]{1, 2}).via(mapper).toList().run(this.getEngine()))), Arrays.asList(1, 1, 2, 2));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void flatMapIterableStageShouldFailIfNullIterableReturned() {
        CompletableFuture cancelled = new CompletableFuture();
        CompletionStage result = this.infiniteStream().onTerminate(() -> cancelled.complete(null)).flatMapIterable(t -> null).toList().run(this.getEngine());
        this.await(cancelled);
        this.await(result);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void flatMapIterableStageShouldFailIfNullIteratorReturned() {
        CompletableFuture cancelled = new CompletableFuture();
        CompletionStage result = this.infiniteStream().onTerminate(() -> cancelled.complete(null)).flatMapIterable(t -> () -> null).toList().run(this.getEngine());
        this.await(cancelled);
        this.await(result);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void flatMapIterableStageShouldFailIfNullElementReturnedFromIterator() {
        CompletableFuture cancelled = new CompletableFuture();
        CompletionStage result = this.infiniteStream().onTerminate(() -> cancelled.complete(null)).flatMapIterable(t -> Collections.singletonList(null)).toList().run(this.getEngine());
        this.await(cancelled);
        this.await(result);
    }

    @Override
    List<Object> reactiveStreamsTckVerifiers() {
        return Collections.singletonList(new ProcessorVerification());
    }

    public class ProcessorVerification
    extends AbstractStageVerification.StageProcessorVerification<Integer> {
        public ProcessorVerification() {
            super(FlatMapIterableStageVerification.this);
        }

        public Processor<Integer, Integer> createIdentityProcessor(int bufferSize) {
            return FlatMapIterableStageVerification.this.rs.builder().flatMapIterable(xva$0 -> Arrays.asList(xva$0)).buildRs(FlatMapIterableStageVerification.this.getEngine());
        }

        @Override
        public Publisher<Integer> createFailedPublisher() {
            return FlatMapIterableStageVerification.this.rs.failed((Throwable)new RuntimeException("failed")).flatMapIterable(xva$0 -> Arrays.asList(xva$0)).buildRs(FlatMapIterableStageVerification.this.getEngine());
        }

        public Integer createElement(int element) {
            return element;
        }
    }
}

