/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.streams.operators.tck.spi;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.microprofile.reactive.streams.operators.ProcessorBuilder;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.AbstractStageVerification;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.ReactiveStreamsSpiVerification;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import org.testng.Assert;
import org.testng.annotations.Test;

public class LimitStageVerification
extends AbstractStageVerification {
    LimitStageVerification(ReactiveStreamsSpiVerification.VerificationDeps deps) {
        super(deps);
    }

    @Test
    public void limitStageShouldLimitTheOutputElements() {
        Assert.assertEquals((Collection)((Collection)this.await(this.infiniteStream().limit(3L).toList().run(this.getEngine()))), Arrays.asList(1, 2, 3));
    }

    @Test
    public void limitStageShouldAllowLimitingToZero() {
        Assert.assertEquals((Collection)((Collection)this.await(this.infiniteStream().limit(0L).toList().run(this.getEngine()))), Collections.emptyList());
    }

    @Test
    public void limitStageToZeroShouldCompleteStreamEvenWhenNoElementsAreReceived() {
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.fromPublisher(subscriber -> subscriber.onSubscribe(new Subscription(){

            public void request(long n) {
            }

            public void cancel() {
            }
        })).limit(0L).toList().run(this.getEngine()))), Collections.emptyList());
    }

    @Test
    public void limitStageShouldCancelUpStreamWhenDone() {
        CompletableFuture cancelled = new CompletableFuture();
        this.infiniteStream().onTerminate(() -> cancelled.complete(null)).limit(1L).toList().run(this.getEngine());
        this.await(cancelled);
    }

    @Test
    public void limitStageShouldIgnoreSubsequentErrorsWhenDone() {
        Assert.assertEquals((Collection)((Collection)this.await(this.infiniteStream().flatMap(i -> {
            if (i == 4) {
                return this.rs.failed((Throwable)new RuntimeException("failed"));
            }
            return this.rs.of(i);
        }).limit(3L).toList().run(this.getEngine()))), Arrays.asList(1, 2, 3));
    }

    @Test
    public void limitStageShouldPropagateCancellation() {
        CompletableFuture cancelled = new CompletableFuture();
        this.await(this.infiniteStream().onTerminate(() -> cancelled.complete(null)).peek(i -> {
            if (i == 100) {
                cancelled.completeExceptionally(new RuntimeException("Was not cancelled"));
            }
        }).limit(100L).limit(3L).toList().run(this.getEngine()));
        this.await(cancelled);
    }

    @Test
    public void limitStageBuilderShouldBeReusable() {
        ProcessorBuilder limit = this.rs.builder().limit(3L);
        Assert.assertEquals((Collection)((Collection)this.await(this.infiniteStream().via(limit).toList().run(this.getEngine()))), Arrays.asList(1, 2, 3));
        Assert.assertEquals((Collection)((Collection)this.await(this.infiniteStream().map(i -> i + 1).via(limit).toList().run(this.getEngine()))), Arrays.asList(2, 3, 4));
    }

    @Override
    List<Object> reactiveStreamsTckVerifiers() {
        return Collections.singletonList(new ProcessorVerification());
    }

    public class ProcessorVerification
    extends AbstractStageVerification.StageProcessorVerification<Integer> {
        public Processor<Integer, Integer> createIdentityProcessor(int bufferSize) {
            return LimitStageVerification.this.rs.builder().limit(Long.MAX_VALUE).buildRs(LimitStageVerification.this.getEngine());
        }

        public Integer createElement(int element) {
            return element;
        }

        @Override
        public Publisher<Integer> createFailedPublisher() {
            return LimitStageVerification.this.rs.failed((Throwable)new RuntimeException("failed")).limit(Long.MAX_VALUE).buildRs(LimitStageVerification.this.getEngine());
        }
    }
}

