/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.streams.operators.tck.spi;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.eclipse.microprofile.reactive.streams.operators.ProcessorBuilder;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.AbstractStageVerification;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.QuietRuntimeException;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.ReactiveStreamsSpiVerification;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.testng.Assert;
import org.testng.annotations.Test;

public class MapStageVerification
extends AbstractStageVerification {
    MapStageVerification(ReactiveStreamsSpiVerification.VerificationDeps deps) {
        super(deps);
    }

    @Test
    public void mapStageShouldMapElements() {
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.of((Object[])new Integer[]{1, 2, 3}).map(Object::toString).toList().run(this.getEngine()))), Arrays.asList("1", "2", "3"));
    }

    @Test(expectedExceptions={QuietRuntimeException.class}, expectedExceptionsMessageRegExp="failed")
    public void mapStageShouldHandleExceptions() {
        CompletableFuture cancelled = new CompletableFuture();
        CompletionStage result = this.infiniteStream().onTerminate(() -> cancelled.complete(null)).map(foo -> {
            throw new QuietRuntimeException("failed");
        }).toList().run(this.getEngine());
        this.await(cancelled);
        this.await(result);
    }

    @Test(expectedExceptions={QuietRuntimeException.class}, expectedExceptionsMessageRegExp="failed")
    public void mapStageShouldPropagateUpstreamExceptions() {
        this.await(this.rs.failed((Throwable)new QuietRuntimeException("failed")).map(Function.identity()).toList().run(this.getEngine()));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void mapStageShouldFailIfNullReturned() {
        CompletableFuture cancelled = new CompletableFuture();
        CompletionStage result = this.infiniteStream().onTerminate(() -> cancelled.complete(null)).map(t -> null).toList().run(this.getEngine());
        this.await(cancelled);
        this.await(result);
    }

    @Test
    public void mapStageBuilderShouldBeReusable() {
        ProcessorBuilder map = this.rs.builder().map(i -> i + 1);
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.of((Object[])new Integer[]{1, 2, 3}).via(map).toList().run(this.getEngine()))), Arrays.asList(2, 3, 4));
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.of((Object[])new Integer[]{4, 5, 6}).via(map).toList().run(this.getEngine()))), Arrays.asList(5, 6, 7));
    }

    @Override
    List<Object> reactiveStreamsTckVerifiers() {
        return Collections.singletonList(new ProcessorVerification());
    }

    public class ProcessorVerification
    extends AbstractStageVerification.StageProcessorVerification<Integer> {
        public Processor<Integer, Integer> createIdentityProcessor(int bufferSize) {
            return MapStageVerification.this.rs.builder().map(Function.identity()).buildRs(MapStageVerification.this.getEngine());
        }

        @Override
        public Publisher<Integer> createFailedPublisher() {
            return MapStageVerification.this.rs.failed((Throwable)new RuntimeException("failed")).map(Function.identity()).buildRs(MapStageVerification.this.getEngine());
        }

        public Integer createElement(int element) {
            return element;
        }
    }
}

