/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.streams.operators.tck.api;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.microprofile.reactive.streams.operators.CompletionSubscriber;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreamsFactory;
import org.eclipse.microprofile.reactive.streams.operators.spi.Graph;
import org.eclipse.microprofile.reactive.streams.operators.spi.ReactiveStreamsEngine;
import org.eclipse.microprofile.reactive.streams.operators.spi.Stage;
import org.eclipse.microprofile.reactive.streams.operators.spi.SubscriberWithCompletionStage;
import org.eclipse.microprofile.reactive.streams.operators.spi.UnsupportedStageException;
import org.eclipse.microprofile.reactive.streams.operators.tck.api.AbstractReactiveStreamsApiVerification;
import org.eclipse.microprofile.reactive.streams.operators.tck.api.Mocks;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SubscriberBuilderVerification
extends AbstractReactiveStreamsApiVerification {
    public SubscriberBuilderVerification(ReactiveStreamsFactory rs) {
        super(rs);
    }

    @Test
    public void build() {
        final AtomicReference builtGraph = new AtomicReference();
        final CompletableFuture expectedCs = new CompletableFuture();
        CompletionSubscriber returned = this.rs.builder().cancel().build(new ReactiveStreamsEngine(){

            public <T> Publisher<T> buildPublisher(Graph graph) throws UnsupportedStageException {
                throw new RuntimeException("Wrong method invoked");
            }

            public <T, R> SubscriberWithCompletionStage<T, R> buildSubscriber(Graph graph) throws UnsupportedStageException {
                builtGraph.set(graph);
                return new SubscriberWithCompletionStage<T, R>(){

                    public CompletionStage<R> getCompletion() {
                        return expectedCs;
                    }

                    public Subscriber<T> getSubscriber() {
                        return Mocks.SUBSCRIBER;
                    }
                };
            }

            public <T, R> Processor<T, R> buildProcessor(Graph graph) throws UnsupportedStageException {
                throw new RuntimeException("Wrong method invoked");
            }

            public <T> CompletionStage<T> buildCompletion(Graph graph) throws UnsupportedStageException {
                throw new RuntimeException("Wrong method invoked");
            }
        });
        Assert.assertEquals((Object)returned.getCompletion(), expectedCs);
        Assert.assertEquals((int)((Graph)builtGraph.get()).getStages().size(), (int)1);
        Assert.assertTrue((boolean)(((Graph)builtGraph.get()).getStages().iterator().next() instanceof Stage.Cancel));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void buildNull() {
        this.rs.builder().cancel().build(null);
    }
}

