/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck;

import javax.inject.Inject;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.inject.RestClient;
import org.eclipse.microprofile.rest.client.tck.WiremockArquillianTest;
import org.eclipse.microprofile.rest.client.tck.interfaces.FeatureProviderClient;
import org.eclipse.microprofile.rest.client.tck.interfaces.SimpleGetApi;
import org.eclipse.microprofile.rest.client.tck.providers.InjectedSimpleFeature;
import org.eclipse.microprofile.rest.client.tck.providers.SimpleFeature;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class FeatureRegistrationTest
extends WiremockArquillianTest {
    @Inject
    @RestClient
    private FeatureProviderClient featureProviderClient;

    @Deployment
    public static WebArchive createDeployment() {
        StringAsset mpConfig = new StringAsset(FeatureProviderClient.class.getName() + "/mp-rest/url=" + FeatureRegistrationTest.getStringURL());
        JavaArchive jar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{SimpleFeature.class, InjectedSimpleFeature.class, SimpleGetApi.class, FeatureProviderClient.class, WiremockArquillianTest.class})).addAsManifestResource((Asset)mpConfig, "microprofile-config.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(FeatureRegistrationTest.class.getSimpleName() + ".war"))).addAsLibrary((Archive)jar);
    }

    @Test
    public void testFeatureRegistrationViaBuilder() {
        SimpleFeature.reset();
        ((RestClientBuilder)RestClientBuilder.newBuilder().register(SimpleFeature.class)).baseUrl(FeatureRegistrationTest.getServerURL()).build(SimpleGetApi.class);
        Assert.assertTrue((boolean)SimpleFeature.wasInvoked(), (String)"The SimpleFeature should have been invoked when building the client");
    }

    @Test
    public void testFeatureRegistrationViaCDI() {
        Assert.assertTrue((boolean)InjectedSimpleFeature.wasInvoked(), (String)"The InjectedSimpleFeature should have been invoked when building the client");
    }
}

