/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck.interfaces;

import java.lang.reflect.Method;
import javax.annotation.Priority;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.eclipse.microprofile.rest.client.tck.interfaces.Loggable;

@Loggable
@Interceptor
@Priority(value=2000)
public class LoggableInterceptor {
    private static String invocationMethod;
    private static Class<?> invocationClass;
    private static Object result;

    public static String getInvocationMethod() {
        return invocationMethod;
    }

    public static Class<?> getInvocationClass() {
        return invocationClass;
    }

    public static Object getResult() {
        return result;
    }

    public static void reset() {
        invocationClass = null;
        invocationMethod = null;
        result = null;
    }

    @AroundInvoke
    public Object logInvocation(InvocationContext ctx) throws Exception {
        Object returnVal;
        Method m = ctx.getMethod();
        invocationClass = m.getDeclaringClass();
        invocationMethod = m.getName();
        result = returnVal = ctx.proceed();
        return returnVal;
    }
}

