/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.tck.WiremockArquillianTest;
import org.eclipse.microprofile.rest.client.tck.interfaces.JsonPClient;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ClientReuseTest
extends WiremockArquillianTest {
    @Deployment
    public static Archive<?> createDeployment() {
        return ((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(ClientReuseTest.class.getSimpleName() + ".war"))).addClasses(new Class[]{WiremockArquillianTest.class, JsonPClient.class});
    }

    @Test
    public void shouldReuseClientAfterFailure() throws Throwable {
        this.stubReturning(1, "{\"content\": true}");
        this.stubReturning(2, "Not a json");
        this.stubReturning(3, "{\"content\": true}");
        this.callWithTimeout(this::testReuseClientAfterFailure, 20L, TimeUnit.SECONDS);
    }

    private Void testReuseClientAfterFailure() {
        JsonPClient client = (JsonPClient)RestClientBuilder.newBuilder().baseUri(ClientReuseTest.getServerURI()).build(JsonPClient.class);
        Assert.assertTrue((boolean)client.get("1").getBoolean("content"));
        this.expectFailure(() -> client.get("2"));
        Assert.assertTrue((boolean)client.get("3").getBoolean("content"));
        return null;
    }

    private void stubReturning(int id, String text) {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)("/" + id))).willReturn(WireMock.aResponse().withBody(text).withHeader("Content-Type", new String[]{"application/json"})));
    }

    private void callWithTimeout(Callable<Object> timedCallable, long timeout, TimeUnit timeUnit) throws Throwable {
        ExecutorService executorService = Executors.newFixedThreadPool(1);
        try {
            List<Future<Object>> futures = executorService.invokeAll(Collections.singleton(timedCallable), timeout, timeUnit);
            futures.iterator().next().get();
        }
        catch (InterruptedException | CancellationException e) {
            e.printStackTrace();
            Assert.fail((String)("the test didn't finish in " + timeout + " " + timeUnit));
        }
        catch (ExecutionException e) {
            Throwable unwrappedError = e.getCause();
            throw unwrappedError;
        }
    }

    private void expectFailure(Callable<?> callable) {
        try {
            callable.call();
        }
        catch (Exception ignored) {
            return;
        }
        Assert.fail((String)"The call that was expected to fall succeeded");
    }
}

