/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.text.atl;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.m2m.atl.adt.ui.AtlUIPlugin;
import org.eclipse.m2m.atl.adt.ui.editor.AtlEditor;
import org.eclipse.m2m.atl.adt.ui.text.atl.AtlCompletionProposal;
import org.eclipse.swt.graphics.Image;

public class AtlCompletionDataSource {
    private static final ResourceSet resourceSet = new ResourceSetImpl();
    public static final String URI_TAG = "nsURI";
    public static final String PATH_TAG = "path";
    private AtlEditor fEditor;
    private Map metamodels;
    private List inputMetamodelsIds;
    private List outputMetamodelsIds;
    public static final int ALL_METAMODELS = 0;
    public static final int INPUT_METAMODELS = 1;
    public static final int OUTPUT_METAMODELS = 2;
    private static Map path2image = new HashMap();

    public AtlCompletionDataSource(AtlEditor editor) {
        this.fEditor = editor;
    }

    public boolean initialized() {
        return this.metamodels != null;
    }

    public void updateDataSource() {
        String text = this.fEditor.getEditorInputContent();
        try {
            this.parseMetamodels(text);
        }
        catch (Exception exception) {}
    }

    private void parseMetamodels(String text) throws IOException {
        this.metamodels = new HashMap();
        this.inputMetamodelsIds = new ArrayList();
        this.outputMetamodelsIds = new ArrayList();
        byte[] buffer = text.getBytes();
        int length = buffer.length;
        BufferedReader brin = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(buffer, 0, length)));
        List uris = AtlCompletionDataSource.getTaggedInformations(brin, URI_TAG);
        for (String line : uris) {
            EPackage regValue;
            if (line.split("=").length != 2) continue;
            String name = line.split("=")[0].trim();
            String uri = line.split("=")[1].trim();
            if (uri == null || uri.length() <= 0 || (regValue = EPackage.Registry.INSTANCE.getEPackage(uri = uri.trim())) == null) continue;
            ArrayList<EPackage> list = new ArrayList<EPackage>();
            list.add(regValue);
            this.metamodels.put(name, list);
        }
        List paths = AtlCompletionDataSource.getTaggedInformations(brin, PATH_TAG);
        for (String line : paths) {
            Resource resource;
            if (line.split("=").length != 2) continue;
            String name = line.split("=")[0].trim();
            String path = line.split("=")[1].trim();
            if (path == null || path.length() <= 0 || (resource = AtlCompletionDataSource.load(URI.createPlatformResourceURI((String)(path = path.trim()), (boolean)true), resourceSet)) == null) continue;
            ArrayList list = new ArrayList();
            for (Object object : resource.getContents()) {
                if (!(object instanceof EPackage)) continue;
                list.add(object);
            }
            this.metamodels.put(name, list);
        }
        if (this.fEditor.getOutlinePage() == null) {
            this.inputMetamodelsIds = null;
            this.outputMetamodelsIds = null;
            return;
        }
        EObject model = this.fEditor.getOutlinePage().getModel();
        if (model.eClass().getName().equals("Module")) {
            EList outModels;
            EList inModels = (EList)AtlCompletionDataSource.eGet(model, "inModels");
            if (inModels != null) {
                for (EObject me : inModels) {
                    EObject mm = (EObject)AtlCompletionDataSource.eGet(me, "metamodel");
                    this.inputMetamodelsIds.add(AtlCompletionDataSource.eGet(mm, "name").toString());
                }
            }
            if ((outModels = (EList)AtlCompletionDataSource.eGet(model, "outModels")) != null) {
                for (EObject me : outModels) {
                    EObject mm = (EObject)AtlCompletionDataSource.eGet(me, "metamodel");
                    this.outputMetamodelsIds.add(AtlCompletionDataSource.eGet(mm, "name").toString());
                }
            }
        }
    }

    public List getURIProposals(String prefix, int offset) {
        ArrayList<AtlCompletionProposal> res = new ArrayList<AtlCompletionProposal>();
        Set uris = EPackage.Registry.INSTANCE.keySet();
        for (Object object : uris) {
            String replacementString = object.toString();
            if (!AtlCompletionDataSource.startsWithIgnoreCase(prefix, replacementString)) continue;
            AtlCompletionProposal proposal = new AtlCompletionProposal(replacementString, offset - prefix.length(), replacementString.length(), null, replacementString, 0, null);
            res.add(proposal);
        }
        Collections.sort(res);
        return res;
    }

    private Map getMetamodelPackages(int filter) {
        if (this.inputMetamodelsIds == null && this.outputMetamodelsIds == null) {
            return this.metamodels;
        }
        switch (filter) {
            case 1: {
                HashMap inputres = new HashMap();
                for (String id : this.inputMetamodelsIds) {
                    inputres.put(id, this.metamodels.get(id));
                }
                return inputres;
            }
            case 2: {
                HashMap outputres = new HashMap();
                for (String id : this.outputMetamodelsIds) {
                    outputres.put(id, this.metamodels.get(id));
                }
                return outputres;
            }
        }
        return this.metamodels;
    }

    private List getMetamodelPackages(String metamodelId) {
        return (List)this.metamodels.get(metamodelId);
    }

    public List getMetaElementsProposals(String prefix, int offset, int filter) {
        ArrayList res = new ArrayList();
        Set entries = this.getMetamodelPackages(filter).entrySet();
        for (Map.Entry entry : entries) {
            String metamodelName = entry.getKey().toString();
            List packages = (List)entry.getValue();
            if (packages == null) continue;
            for (EPackage metamodel : packages) {
                res.addAll(this.getMetaElementsProposals(metamodelName, metamodel, prefix, offset));
            }
        }
        return res;
    }

    private List getMetaElementsProposals(String metamodelName, EPackage metamodel, String prefix, int offset) {
        ArrayList<AtlCompletionProposal> res = new ArrayList<AtlCompletionProposal>();
        TreeSet classifiers = new TreeSet(new Comparator(){

            public int compare(Object arg0, Object arg1) {
                EClassifier c0 = (EClassifier)arg0;
                EClassifier c1 = (EClassifier)arg1;
                return AtlCompletionDataSource.getEClassifierShortPath(c0, false).compareTo(AtlCompletionDataSource.getEClassifierShortPath(c1, false));
            }
        });
        classifiers.addAll(AtlCompletionDataSource.computeAllClassifiersList(metamodel));
        for (EClassifier classifier : classifiers) {
            String replacementString = String.valueOf(metamodelName) + "!" + AtlCompletionDataSource.getEClassifierShortPath(classifier, false);
            if (!AtlCompletionDataSource.startsWithIgnoreCase(prefix, replacementString) || prefix.equals(replacementString)) continue;
            Image image = AtlCompletionDataSource.getImage("model_class.gif");
            StringBuffer additionalProposalInfo = new StringBuffer();
            if (classifier instanceof EClass) {
                EClass cl = (EClass)classifier;
                if (cl.isAbstract()) {
                    additionalProposalInfo.append("abstract ");
                }
                additionalProposalInfo.append("class ");
                additionalProposalInfo.append(cl.getName());
                boolean first = true;
                for (EClass st : cl.getESuperTypes()) {
                    if (first) {
                        additionalProposalInfo.append(" extends\n\t");
                        first = false;
                    } else {
                        additionalProposalInfo.append(",\n\t");
                    }
                    additionalProposalInfo.append(st.getName());
                }
            }
            AtlCompletionProposal proposal = new AtlCompletionProposal(replacementString, offset - prefix.length(), replacementString.length(), image, replacementString, 0, additionalProposalInfo.toString());
            res.add(proposal);
        }
        Collections.sort(res);
        return res;
    }

    private static List computeAllClassifiersList(EPackage ePackage) {
        BasicEList classifiers = new BasicEList();
        if (ePackage != null) {
            AtlCompletionDataSource.computeAllClassifiersList(ePackage, (List)classifiers);
        }
        return classifiers;
    }

    private static void computeAllClassifiersList(EPackage ePackage, List all) {
        for (EClassifier classifier : ePackage.getEClassifiers()) {
            if (!(classifier instanceof EClass) || ((EClass)classifier).isInterface()) continue;
            all.add(classifier);
        }
        Iterator packages = ePackage.getESubpackages().iterator();
        while (packages.hasNext()) {
            AtlCompletionDataSource.computeAllClassifiersList((EPackage)packages.next(), all);
        }
    }

    public List getMetaFeaturesProposals(List existing, EObject atlType, String prefix, int offset) {
        EClassifier res;
        if (atlType != null && (res = this.getEClassifierFromAtlType(atlType)) instanceof EClass) {
            return this.getMetaFeaturesProposals(existing, (EClass)res, prefix, offset);
        }
        return new ArrayList();
    }

    private List getMetaFeaturesProposals(List existing, EClass modelElement, String prefix, int offset) {
        ArrayList<AtlCompletionProposal> res = new ArrayList<AtlCompletionProposal>();
        if (modelElement instanceof EClass) {
            EClass type = modelElement;
            TreeSet features = new TreeSet(new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    EStructuralFeature f0 = (EStructuralFeature)arg0;
                    EStructuralFeature f1 = (EStructuralFeature)arg1;
                    return f0.getName().compareTo(f1.getName());
                }
            });
            features.addAll(type.getEAllStructuralFeatures());
            for (EStructuralFeature feature : features) {
                EReference opposite;
                String replacementString = feature.getName();
                if (existing.contains(replacementString) || !AtlCompletionDataSource.startsWithIgnoreCase(prefix, replacementString) || prefix.equals(replacementString)) continue;
                Image image = null;
                if (!feature.isChangeable()) continue;
                if (feature instanceof EAttribute) {
                    image = AtlCompletionDataSource.getImage("model_attribute.gif");
                } else if (feature instanceof EReference) {
                    image = AtlCompletionDataSource.getImage("model_reference.gif");
                }
                StringBuffer additionalProposalInfo = new StringBuffer();
                if (feature instanceof EAttribute) {
                    additionalProposalInfo.append("attribute ");
                } else if (feature instanceof EReference) {
                    additionalProposalInfo.append("reference ");
                }
                additionalProposalInfo.append(feature.getName());
                if (feature.getLowerBound() != 1 || feature.getUpperBound() != 1) {
                    additionalProposalInfo.append('[');
                    if (feature.getLowerBound() == 0 && feature.getUpperBound() == -1) {
                        additionalProposalInfo.append('*');
                    } else {
                        additionalProposalInfo.append(feature.getLowerBound());
                        additionalProposalInfo.append('-');
                        additionalProposalInfo.append(feature.getUpperBound());
                    }
                    additionalProposalInfo.append(']');
                }
                if (feature.isOrdered()) {
                    additionalProposalInfo.append(" ordered");
                }
                if (feature instanceof EReference && ((EReference)feature).isContainment()) {
                    additionalProposalInfo.append(" container");
                }
                additionalProposalInfo.append(" :\n\t");
                additionalProposalInfo.append(feature.getEType().getName());
                if (feature instanceof EReference && (opposite = ((EReference)feature).getEOpposite()) != null) {
                    additionalProposalInfo.append(" oppositeOf ");
                    additionalProposalInfo.append(opposite.getName());
                }
                AtlCompletionProposal proposal = new AtlCompletionProposal(replacementString, offset - prefix.length(), replacementString.length(), image, replacementString, 0, additionalProposalInfo.toString());
                res.add(proposal);
            }
        }
        Collections.sort(res);
        return res;
    }

    public List getHelperTypesProposals(String prefix, int offset) {
        ArrayList<AtlCompletionProposal> res = new ArrayList<AtlCompletionProposal>();
        res.addAll(this.getMetaElementsProposals(prefix, offset, 0));
        String[] types = new String[]{"Boolean", "String", "Integer", "Sequence", "Set", "Bag", "OrderedSet", "Map"};
        int i = 0;
        while (i < types.length) {
            String replacementString = types[i];
            if (AtlCompletionDataSource.startsWithIgnoreCase(prefix, replacementString)) {
                AtlCompletionProposal proposal = new AtlCompletionProposal(replacementString, offset - prefix.length(), replacementString.length(), null, replacementString, 0, null);
                res.add(proposal);
            }
            ++i;
        }
        return res;
    }

    private static boolean startsWithIgnoreCase(String prefix, String replacementString) {
        if (replacementString.length() >= prefix.length()) {
            String tmp = replacementString.substring(0, prefix.length());
            return tmp.equalsIgnoreCase(prefix);
        }
        return false;
    }

    private static String getEClassifierShortPath(EClassifier eClassifier, boolean mode) {
        String name = eClassifier.getName();
        if (eClassifier.getEPackage() != null && mode) {
            name = "\"" + eClassifier.getEPackage().getName() + "::" + name + "\"";
        }
        return name;
    }

    public static Image getImage(String path) {
        Object result = (Image)path2image.get(path);
        if (result == null && !path2image.containsKey(path)) {
            ImageDescriptor descriptor = AtlUIPlugin.getImageDescriptor(path);
            result = descriptor != null ? descriptor.createImage() : null;
            path2image.put(path, result);
        }
        if (result.isDisposed()) {
            result = null;
        }
        return result;
    }

    public static List getTaggedInformations(BufferedReader reader, String tag) throws IOException {
        reader.mark(1000);
        ArrayList<String> res = new ArrayList<String>();
        while (reader.ready()) {
            String line = reader.readLine();
            if (line == null || line.startsWith("library") || line.startsWith("module") || line.startsWith("query")) break;
            if (!line.trim().startsWith("-- @" + tag)) continue;
            line = line.replaceFirst("^\\p{Space}*--\\p{Space}*@" + tag + "\\p{Space}+([^\\p{Space}]*)\\p{Space}*$", "$1");
            res.add(line);
        }
        reader.reset();
        return res;
    }

    public static Resource load(URI modelURI, ResourceSet resourceSet) throws IOException {
        Resource.Factory.Registry reg;
        Object resourceFactory;
        String fileExtension = modelURI.fileExtension();
        if (fileExtension == null || fileExtension.length() == 0) {
            fileExtension = "*";
        }
        if ((resourceFactory = (reg = Resource.Factory.Registry.INSTANCE).getExtensionToFactoryMap().get(fileExtension)) != null) {
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(fileExtension, resourceFactory);
        } else {
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(fileExtension, new XMIResourceFactoryImpl());
        }
        Resource modelResource = resourceSet.createResource(modelURI);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", System.getProperty("file.encoding"));
        modelResource.load(options);
        return modelResource;
    }

    public static Object eGet(EObject self, String featureName) {
        EStructuralFeature feature = self.eClass().getEStructuralFeature(featureName);
        if (feature != null) {
            return self.eGet(feature);
        }
        return null;
    }

    public EClassifier getEClassifierFromAtlType(EObject atlType) {
        Iterator iterator;
        String metamodelId;
        List packages;
        EObject model;
        if (atlType != null && (model = (EObject)AtlCompletionDataSource.eGet(atlType, "model")) != null && (packages = this.getMetamodelPackages(metamodelId = AtlCompletionDataSource.eGet(model, "name").toString())) != null && (iterator = packages.iterator()).hasNext()) {
            EPackage pack = (EPackage)iterator.next();
            EClassifier res = pack.getEClassifier(AtlCompletionDataSource.eGet(atlType, "name").toString());
            return res;
        }
        return null;
    }

    public static Map getVariables(EObject rule) {
        HashMap<Object, Object> res = new HashMap<Object, Object>();
        res.put("thisModule", null);
        TreeIterator ruleContentsIterator = rule.eAllContents();
        while (ruleContentsIterator.hasNext()) {
            EObject content = (EObject)ruleContentsIterator.next();
            if (!content.eClass().getName().equals("SimpleInPatternElement")) continue;
            res.put(AtlCompletionDataSource.eGet(content, "varName"), AtlCompletionDataSource.eGet(content, "type"));
        }
        return res;
    }

    public List getVariablesProposals(EObject rule, String prefix, int offset) {
        ArrayList<AtlCompletionProposal> res = new ArrayList<AtlCompletionProposal>();
        Map variables = AtlCompletionDataSource.getVariables(rule);
        for (Map.Entry entry : variables.entrySet()) {
            String replacementString = entry.getKey().toString();
            StringBuffer additionalProposalInfo = new StringBuffer();
            EClassifier classifier = this.getEClassifierFromAtlType((EObject)entry.getValue());
            if (classifier != null) {
                additionalProposalInfo.append(AtlCompletionDataSource.getEClassifierShortPath(classifier, false));
            }
            if (!AtlCompletionDataSource.startsWithIgnoreCase(prefix, replacementString) || prefix.equals(replacementString)) continue;
            AtlCompletionProposal proposal = new AtlCompletionProposal(replacementString, offset - prefix.length(), replacementString.length(), null, replacementString, 0, additionalProposalInfo.toString());
            res.add(proposal);
        }
        return res;
    }
}

