/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.launching;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.m2m.atl.adt.debug.AtlDebugMessages;
import org.eclipse.m2m.atl.adt.launching.AtlLauncherTools;
import org.eclipse.m2m.atl.adt.launching.DialogUriSelection;
import org.eclipse.m2m.atl.engine.AtlParser;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMCollection;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModelElement;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclUndefined;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMString;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class MainAtlTab
extends AbstractLaunchConfigurationTab {
    protected static Logger logger = Logger.getLogger("org.eclipse.m2m.atl");
    private ScrolledComposite scrollContainer;
    private Composite rootContainer;
    private Combo projectsList;
    private Combo projectFilesList;
    private List sourceMetamodelsFromModule = new ArrayList();
    private List targetMetamodelsFromModule = new ArrayList();
    private List sourceModelsFromModule = new ArrayList();
    private List targetModelsFromModule = new ArrayList();
    private List librariesFromModule = new ArrayList();
    private List superimposedFromLaunchConfig = new ArrayList();
    private List nonLibraries = new ArrayList();
    private List removableMetamodels = new ArrayList();
    private List removableSourceModels = new ArrayList();
    private List removableTargetModels = new ArrayList();
    private List removableLibraries = new ArrayList();
    private Map sourceC2RelationshipFromModule = new HashMap();
    private Map targetC2RelationshipFromModule = new HashMap();
    private Group projectInformationGroup;
    private Group metamodelsGroup;
    private Group sourceModelsGroup;
    private Group targetModelsGroup;
    private Group librariesGroup;
    private Group controlGroup;
    private Map metamodelsGroupWidgets = new HashMap();
    private Map sourceModelsGroupWidgets = new HashMap();
    private Map targetModelsGroupWidgets = new HashMap();
    private Map librariesGroupWidgets = new HashMap();
    private static final int IS_METAMODEL = 2;
    private static final int IS_MODEL = 4;
    private static final int IS_SOURCE = 8;
    private static final int IS_TARGET = 16;
    private static final int IS_LIBRARY = 32;
    private Pattern asmToAtl = Pattern.compile("\\.asm$");
    private Pattern moduleName = Pattern.compile("^.*/(.*)\\.a(tl|sm)$");
    private Map asmFileCache = new HashMap();
    private ILaunchConfiguration configuration = null;

    public void createControl(Composite parent) {
        this.scrollContainer = new ScrolledComposite(parent, 768);
        this.scrollContainer.setExpandHorizontal(true);
        this.scrollContainer.setExpandVertical(true);
        this.rootContainer = new Composite((Composite)this.scrollContainer, 0);
        this.rootContainer.setLayout((Layout)new GridLayout());
        this.scrollContainer.setContent((Control)this.rootContainer);
        this.projectInformationGroup = new Group(this.rootContainer, 0);
        this.projectInformationGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.projectInformationGroup.setLayout((Layout)new GridLayout(2, false));
        this.projectInformationGroup.setText(AtlDebugMessages.getString("MainAtlTab.PROJECT"));
        Label projectNameLabel = new Label((Composite)this.projectInformationGroup, 0);
        projectNameLabel.setText(AtlDebugMessages.getString("MainAtlTab.PROJECTNAME"));
        this.projectsList = new Combo((Composite)this.projectInformationGroup, 8);
        this.projectsList.setLayoutData((Object)new GridData(4, 4, true, true));
        this.projectsList.setItems(AtlLauncherTools.projectNames());
        Label projectFileLabel = new Label((Composite)this.projectInformationGroup, 0);
        projectFileLabel.setText(AtlDebugMessages.getString("MainAtlTab.ATLFILENAME"));
        this.projectFilesList = new Combo((Composite)this.projectInformationGroup, 8);
        this.projectFilesList.setLayoutData((Object)new GridData(4, 4, true, true));
        this.metamodelsGroup = new Group(this.rootContainer, 0);
        this.metamodelsGroup.setText(AtlDebugMessages.getString("MainAtlTab.METAMODELS"));
        this.metamodelsGroup.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        this.metamodelsGroup.setLayout((Layout)new GridLayout(8, false));
        this.sourceModelsGroup = new Group(this.rootContainer, 0);
        this.sourceModelsGroup.setText(AtlDebugMessages.getString("MainAtlTab.SOURCEMODELS"));
        this.sourceModelsGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.sourceModelsGroup.setLayout((Layout)new GridLayout(4, false));
        this.targetModelsGroup = new Group(this.rootContainer, 0);
        this.targetModelsGroup.setText(AtlDebugMessages.getString("MainAtlTab.TARGETMODELS"));
        this.targetModelsGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.targetModelsGroup.setLayout((Layout)new GridLayout(4, false));
        this.librariesGroup = new Group(this.rootContainer, 0);
        this.librariesGroup.setText(AtlDebugMessages.getString("MainAtlTab.LIBRARIES"));
        this.librariesGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.librariesGroup.setLayout((Layout)new GridLayout(4, false));
        this.controlGroup = new Group(this.rootContainer, 0);
        this.controlGroup.setText(AtlDebugMessages.getString("MainAtlTab.MODIFY"));
        this.controlGroup.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        this.controlGroup.setLayout((Layout)new GridLayout(7, false));
        Button addSourceModelBtn = new Button((Composite)this.controlGroup, 0);
        addSourceModelBtn.setText(AtlDebugMessages.getString("MainAtlTab.ADDSOURCE"));
        Button addTargetModelBtn = new Button((Composite)this.controlGroup, 0);
        addTargetModelBtn.setText(AtlDebugMessages.getString("MainAtlTab.ADDTARGET"));
        Button addLibBtn = new Button((Composite)this.controlGroup, 0);
        addLibBtn.setText(AtlDebugMessages.getString("MainAtlTab.ADDLIB"));
        this.projectsList.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MainAtlTab.this.projectFilesList.setItems(AtlLauncherTools.fileNames(MainAtlTab.this.projectsList.getText()));
                MainAtlTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.projectFilesList.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MainAtlTab.this.rebuild();
            }
        });
        addSourceModelBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                InputDialog dlg = new InputDialog(MainAtlTab.this.getShell(), AtlDebugMessages.getString("MainAtlTab.ADDSOURCEMODEL"), AtlDebugMessages.getString("MainAtlTab.MMNAME"), "MM", null);
                if (dlg.open() == 1) {
                    return;
                }
                String metamodelName = dlg.getValue();
                dlg = new InputDialog(MainAtlTab.this.getShell(), AtlDebugMessages.getString("MainAtlTab.ADDSOURCEMODEL"), AtlDebugMessages.getString("MainAtlTab.MNAME"), "IN", null);
                if (dlg.open() == 1) {
                    return;
                }
                String modelName = dlg.getValue();
                if (!MainAtlTab.this.sourceMetamodelsFromModule.contains(metamodelName)) {
                    MainAtlTab.this.sourceMetamodelsFromModule.add(metamodelName);
                    if (!MainAtlTab.this.targetMetamodelsFromModule.contains(metamodelName)) {
                        MainAtlTab.this.removableMetamodels.add(metamodelName);
                    }
                }
                if (!MainAtlTab.this.sourceModelsFromModule.contains(modelName)) {
                    MainAtlTab.this.sourceModelsFromModule.add(modelName);
                    MainAtlTab.this.sourceC2RelationshipFromModule.put(modelName, metamodelName);
                    MainAtlTab.this.removableSourceModels.add(modelName);
                }
                MainAtlTab.this.build();
                MainAtlTab.this.layout();
            }
        });
        addTargetModelBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                InputDialog dlg = new InputDialog(MainAtlTab.this.getShell(), AtlDebugMessages.getString("MainAtlTab.ADDTARGETMODEL"), AtlDebugMessages.getString("MainAtlTab.MMNAME"), "MM", null);
                if (dlg.open() == 1) {
                    return;
                }
                String metamodelName = dlg.getValue();
                dlg = new InputDialog(MainAtlTab.this.getShell(), AtlDebugMessages.getString("MainAtlTab.ADDTARGETMODEL"), AtlDebugMessages.getString("MainAtlTab.MNAME"), "OUT", null);
                if (dlg.open() == 1) {
                    return;
                }
                String modelName = dlg.getValue();
                if (!MainAtlTab.this.targetMetamodelsFromModule.contains(metamodelName)) {
                    MainAtlTab.this.targetMetamodelsFromModule.add(metamodelName);
                    if (!MainAtlTab.this.sourceMetamodelsFromModule.contains(metamodelName)) {
                        MainAtlTab.this.removableMetamodels.add(metamodelName);
                    }
                }
                if (!MainAtlTab.this.targetModelsFromModule.contains(modelName)) {
                    MainAtlTab.this.targetModelsFromModule.add(modelName);
                    MainAtlTab.this.targetC2RelationshipFromModule.put(modelName, metamodelName);
                    MainAtlTab.this.removableTargetModels.add(modelName);
                }
                MainAtlTab.this.build();
                MainAtlTab.this.layout();
            }
        });
        addLibBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                InputDialog dlg = new InputDialog(MainAtlTab.this.getShell(), AtlDebugMessages.getString("MainAtlTab.ADDLIBRARY"), AtlDebugMessages.getString("MainAtlTab.LIBRARYNAME"), "LIB", null);
                if (dlg.open() == 1) {
                    return;
                }
                String libName = dlg.getValue();
                if (!MainAtlTab.this.librariesFromModule.contains(libName)) {
                    MainAtlTab.this.librariesFromModule.add(libName);
                    MainAtlTab.this.removableLibraries.add(libName);
                }
                MainAtlTab.this.build();
                MainAtlTab.this.layout();
            }
        });
        this.setControl((Control)this.scrollContainer);
    }

    public void superimposedChanged(List superimposed) {
        this.superimposedFromLaunchConfig = superimposed;
        this.build();
        this.layout();
    }

    private void rebuild() {
        try {
            this.clear();
            this.build();
            this.initializeExtraWidgetsFrom(this.configuration);
            this.build();
            this.initializeWidgetValuesFrom(this.configuration);
            this.layout();
            logger.fine("MainAtlTab rebuild");
        }
        catch (CoreException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    private void clear() {
        this.sourceModelsFromModule.clear();
        this.sourceMetamodelsFromModule.clear();
        this.targetModelsFromModule.clear();
        this.targetMetamodelsFromModule.clear();
        this.librariesFromModule.clear();
        this.removableMetamodels.clear();
        this.removableSourceModels.clear();
        this.removableTargetModels.clear();
        this.removableLibraries.clear();
        this.sourceC2RelationshipFromModule.clear();
        this.targetC2RelationshipFromModule.clear();
        this.metamodelsGroupWidgets.clear();
        this.sourceModelsGroupWidgets.clear();
        this.targetModelsGroupWidgets.clear();
        this.librariesGroupWidgets.clear();
        this.disposeGroupChildren(this.metamodelsGroup);
        this.disposeGroupChildren(this.sourceModelsGroup);
        this.disposeGroupChildren(this.targetModelsGroup);
        this.disposeGroupChildren(this.librariesGroup);
    }

    private void initializeExtraWidgetsFrom(ILaunchConfiguration configuration) throws CoreException {
        String mmName;
        if (configuration == null) {
            return;
        }
        Map savedLibraries = configuration.getAttribute("Libs", new HashMap());
        Map input = configuration.getAttribute("Input", new HashMap());
        Map output = configuration.getAttribute("Output", new HashMap());
        for (String mName : input.keySet()) {
            mmName = (String)input.get(mName);
            if (!this.sourceMetamodelsFromModule.contains(mmName)) {
                this.sourceMetamodelsFromModule.add(mmName);
                if (!this.targetMetamodelsFromModule.contains(mmName)) {
                    this.removableMetamodels.add(mmName);
                }
            }
            if (this.sourceModelsFromModule.contains(mName)) continue;
            this.sourceModelsFromModule.add(mName);
            this.sourceC2RelationshipFromModule.put(mName, mmName);
            this.removableSourceModels.add(mName);
        }
        for (String mName : output.keySet()) {
            mmName = (String)output.get(mName);
            if (!this.targetMetamodelsFromModule.contains(mmName)) {
                this.targetMetamodelsFromModule.add(mmName);
                if (!this.sourceMetamodelsFromModule.contains(mmName)) {
                    this.removableMetamodels.add(mmName);
                }
            }
            if (this.targetModelsFromModule.contains(mName)) continue;
            this.targetModelsFromModule.add(mName);
            this.targetC2RelationshipFromModule.put(mName, mmName);
            this.removableTargetModels.add(mName);
        }
        for (String libraryName : savedLibraries.keySet()) {
            if (this.librariesFromModule.contains(libraryName)) continue;
            this.librariesFromModule.add(libraryName);
            this.removableLibraries.add(libraryName);
        }
    }

    private void initializeWidgetValuesFrom(ILaunchConfiguration configuration) throws CoreException {
        Map widgets;
        if (configuration == null) {
            return;
        }
        Map savedPaths = configuration.getAttribute("Path", new HashMap());
        Map savedModelHandlers = configuration.getAttribute("Model Handler", new HashMap());
        Map savedLibraries = configuration.getAttribute("Libs", new HashMap());
        for (String modelName : savedPaths.keySet()) {
            if (this.metamodelsGroupWidgets.get(modelName) != null) {
                widgets = (Map)this.metamodelsGroupWidgets.get(modelName);
                Text metamodelLocation = (Text)widgets.get("metamodelLocation");
                Button isMetametamodel = (Button)widgets.get("isMetametamodel");
                Combo modelHandlers = (Combo)widgets.get("modelHandlers");
                if (((String)savedPaths.get(modelName)).startsWith("#")) {
                    isMetametamodel.setSelection(true);
                    isMetametamodel.notifyListeners(13, null);
                } else {
                    metamodelLocation.setText((String)savedPaths.get(modelName));
                }
                int item = 0;
                while (item < modelHandlers.getItems().length) {
                    if (modelHandlers.getItem(item).equals((String)savedModelHandlers.get(modelName))) {
                        modelHandlers.select(item);
                    }
                    ++item;
                }
                continue;
            }
            widgets = null;
            if (this.sourceModelsGroupWidgets.get(modelName) != null) {
                widgets = (Map)this.sourceModelsGroupWidgets.get(modelName);
            } else if (this.targetModelsGroupWidgets.get(modelName) != null) {
                widgets = (Map)this.targetModelsGroupWidgets.get(modelName);
            }
            if (widgets == null) continue;
            Text modelLocation = (Text)widgets.get("location");
            modelLocation.setText((String)savedPaths.get(modelName));
        }
        for (String libraryName : savedLibraries.keySet()) {
            widgets = (Map)this.librariesGroupWidgets.get(libraryName);
            if (widgets == null) continue;
            Text libraryLocation = (Text)widgets.get("location");
            libraryLocation.setText((String)savedLibraries.get(libraryName));
        }
    }

    private void calcNonLibraries() {
        this.nonLibraries.clear();
        String path2 = this.projectFilesList.getText();
        Matcher m = this.moduleName.matcher(path2);
        if (m.find()) {
            this.nonLibraries.add(m.group(1));
        }
        for (String path2 : this.superimposedFromLaunchConfig) {
            m = this.moduleName.matcher(path2);
            if (!m.find()) continue;
            this.nonLibraries.add(m.group(1));
        }
    }

    private void getModelsFromATLFiles() {
        String path2;
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IResource res = wsRoot.findMember(path2 = this.projectFilesList.getText());
        if (res instanceof IFile) {
            this.getModelsFromATLFile((IFile)res);
        }
        for (String path2 : this.superimposedFromLaunchConfig) {
            res = wsRoot.findMember(path2 = this.asmToAtl.matcher(path2).replaceFirst(".atl"));
            if (res instanceof IFile) {
                this.getModelsFromATLFile((IFile)res);
                continue;
            }
            logger.severe(String.valueOf(AtlDebugMessages.getString("MainAtlTab.FILENOTFOUND")) + path2);
        }
    }

    private void build() {
        this.calcNonLibraries();
        this.getModelsFromATLFiles();
        this.buildMetamodelControls(this.sourceMetamodelsFromModule);
        this.buildMetamodelControls(this.targetMetamodelsFromModule);
        this.buildSourceModelControls(this.sourceModelsFromModule);
        this.buildTargetModelControls(this.targetModelsFromModule);
        this.buildLibraryControls(this.librariesFromModule);
    }

    private void buildMetamodelControls(Collection modelNames) {
        for (String modelName : modelNames) {
            if (this.metamodelsGroupWidgets.containsKey(modelName)) continue;
            this.metamodelsGroupWidgets.put(modelName, this.buildMetamodelsControls(this.metamodelsGroup, modelName, 10, this.removableMetamodels.contains(modelName)));
        }
    }

    private void buildSourceModelControls(Collection modelNames) {
        for (String modelName : modelNames) {
            if (this.sourceModelsGroupWidgets.containsKey(modelName)) continue;
            String mmName = (String)this.sourceC2RelationshipFromModule.get(modelName);
            this.sourceModelsGroupWidgets.put(modelName, this.buildModelsAndLibrariesControls(this.sourceModelsGroup, modelName, mmName, 12, this.removableSourceModels.contains(modelName)));
        }
    }

    private void buildTargetModelControls(Collection modelNames) {
        for (String modelName : modelNames) {
            if (this.targetModelsGroupWidgets.get(modelName) != null) continue;
            String mmName = (String)this.targetC2RelationshipFromModule.get(modelName);
            this.targetModelsGroupWidgets.put(modelName, this.buildModelsAndLibrariesControls(this.targetModelsGroup, modelName, mmName, 20, this.removableTargetModels.contains(modelName)));
        }
    }

    private void buildLibraryControls(Collection libraryNames) {
        for (String libraryName : libraryNames) {
            if (this.librariesGroupWidgets.get(libraryName) != null) continue;
            this.librariesGroupWidgets.put(libraryName, this.buildModelsAndLibrariesControls(this.librariesGroup, libraryName, null, 32, this.removableLibraries.contains(libraryName)));
        }
    }

    private void layout() {
        this.metamodelsGroup.layout();
        this.sourceModelsGroup.layout();
        this.targetModelsGroup.layout();
        this.librariesGroup.layout();
        this.rootContainer.layout();
        this.scrollContainer.setMinSize(this.rootContainer.computeSize(-1, -1));
        this.scrollContainer.layout();
        this.canSave();
        this.updateLaunchConfigurationDialog();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.configuration = configuration;
        try {
            String projectName = configuration.getAttribute("Project Name", "");
            String fileName = configuration.getAttribute("ATL File Name", "");
            this.superimposedFromLaunchConfig = configuration.getAttribute("Superimpose", new ArrayList());
            this.projectsList.setText(projectName);
            this.projectFilesList.setItems(AtlLauncherTools.fileNames(projectName));
            this.projectFilesList.setText(fileName);
        }
        catch (CoreException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        this.rebuild();
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        boolean isMetametamodel;
        String modelHandler;
        String location;
        HashMap<String, String> savedPaths = new HashMap<String, String>();
        HashMap<String, String> savedModelHandlers = new HashMap<String, String>();
        HashMap<String, String> savedLibraries = new HashMap<String, String>();
        HashMap savedInput = new HashMap();
        HashMap savedOutput = new HashMap();
        HashMap<Object, String> savedType = new HashMap<Object, String>();
        for (String string : this.sourceMetamodelsFromModule) {
            location = ((Text)((Map)this.metamodelsGroupWidgets.get(string)).get("metamodelLocation")).getText();
            modelHandler = ((Combo)((Map)this.metamodelsGroupWidgets.get(string)).get("modelHandlers")).getText();
            isMetametamodel = ((Button)((Map)this.metamodelsGroupWidgets.get(string)).get("isMetametamodel")).getSelection();
            if (isMetametamodel) {
                savedPaths.put(string, "#" + modelHandler);
            } else {
                savedPaths.put(string, location);
            }
            savedModelHandlers.put(string, modelHandler);
        }
        for (String string : this.targetMetamodelsFromModule) {
            location = ((Text)((Map)this.metamodelsGroupWidgets.get(string)).get("metamodelLocation")).getText();
            modelHandler = ((Combo)((Map)this.metamodelsGroupWidgets.get(string)).get("modelHandlers")).getText();
            isMetametamodel = ((Button)((Map)this.metamodelsGroupWidgets.get(string)).get("isMetametamodel")).getSelection();
            if (isMetametamodel) {
                savedPaths.put(string, "#" + modelHandler);
            } else {
                savedPaths.put(string, location);
            }
            savedModelHandlers.put(string, modelHandler);
        }
        for (String string : this.sourceModelsFromModule) {
            location = ((Text)((Map)this.sourceModelsGroupWidgets.get(string)).get("location")).getText();
            savedPaths.put(string, location);
        }
        for (String string : this.targetModelsFromModule) {
            location = ((Text)((Map)this.targetModelsGroupWidgets.get(string)).get("location")).getText();
            savedPaths.put(string, location);
        }
        for (String string : this.librariesFromModule) {
            location = ((Text)((Map)this.librariesGroupWidgets.get(string)).get("location")).getText();
            savedLibraries.put(string, location);
        }
        for (Map.Entry entry : this.sourceC2RelationshipFromModule.entrySet()) {
            savedInput.put(entry.getKey(), entry.getValue());
            savedType.put(entry.getKey(), "MODELINPUT");
            savedType.put(entry.getValue(), "METAMODELINPUT");
        }
        for (Map.Entry entry : this.targetC2RelationshipFromModule.entrySet()) {
            savedOutput.put(entry.getKey(), entry.getValue());
            savedType.put(entry.getKey(), "MODELOUTPUT");
            savedType.put(entry.getValue(), "METAMODELOUTPUT");
        }
        configuration.setAttribute("Project Name", this.projectsList.getText());
        configuration.setAttribute("ATL File Name", this.projectFilesList.getText());
        configuration.setAttribute("Path", savedPaths);
        configuration.setAttribute("Model Handler", savedModelHandlers);
        configuration.setAttribute("Libs", savedLibraries);
        configuration.setAttribute("Input", savedInput);
        configuration.setAttribute("Output", savedOutput);
        configuration.setAttribute("ModelType", savedType);
    }

    public String getName() {
        return AtlLauncherTools.REMOTEATLNAME;
    }

    public boolean canSave() {
        if (this.projectsList.getText().equals("")) {
            this.setErrorMessage(AtlDebugMessages.getString("MainAtlTab.GIVEPROJECTNAME"));
            return false;
        }
        if (this.projectFilesList.getText().equals("")) {
            this.setErrorMessage(AtlDebugMessages.getString("MainAtlTab.GIVETRANSFORMATIONNAME"));
            return false;
        }
        for (Map.Entry entry : this.metamodelsGroupWidgets.entrySet()) {
            String mName = (String)entry.getKey();
            Map widgets = (Map)entry.getValue();
            Text metamodelLocation = (Text)widgets.get("metamodelLocation");
            Button isMetametamodel = (Button)widgets.get("isMetametamodel");
            if (metamodelLocation.getText().length() != 0 || isMetametamodel.getSelection()) continue;
            this.setErrorMessage(String.valueOf(AtlDebugMessages.getString("MainAtlTab.GIVEPATHFOR")) + mName);
            return false;
        }
        if (!this.canSaveModelsGroupWidgets(this.sourceModelsGroupWidgets)) {
            return false;
        }
        if (!this.canSaveModelsGroupWidgets(this.targetModelsGroupWidgets)) {
            return false;
        }
        if (!this.canSaveModelsGroupWidgets(this.librariesGroupWidgets)) {
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private boolean canSaveModelsGroupWidgets(Map modelsGroupWidgets) {
        for (Map.Entry entry : modelsGroupWidgets.entrySet()) {
            String mName = (String)entry.getKey();
            Map widgets = (Map)entry.getValue();
            Text location = (Text)widgets.get("location");
            if (location.getText().length() != 0) continue;
            this.setErrorMessage(String.valueOf(AtlDebugMessages.getString("MainAtlTab.GIVEPATHFOR")) + mName);
            return false;
        }
        return true;
    }

    public Image getImage() {
        return AtlLauncherTools.createImage("icons/atllogo_icon.gif");
    }

    private String editExternalPath(int type) {
        String ret = "";
        FileDialog fileDialog = type == 20 ? new FileDialog(this.getShell(), 8192) : new FileDialog(this.getShell(), 4096);
        fileDialog.setFilterExtensions(new String[]{"*"});
        String fileName = fileDialog.open();
        if (fileName != null) {
            ret = "ext:" + fileName;
        }
        return ret;
    }

    private String editPath(final int type) {
        String ret = "";
        if (type == 20) {
            SaveAsDialog sad = new SaveAsDialog(this.getShell());
            sad.open();
            IPath outputPath = sad.getResult();
            if (outputPath != null) {
                ret = outputPath.toString();
            }
        } else {
            ElementTreeSelectionDialog elementTreeSelectionDialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
            elementTreeSelectionDialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
            elementTreeSelectionDialog.setMessage(AtlDebugMessages.getString("ModelChoiceTab.CHOOSEMODEL"));
            elementTreeSelectionDialog.setAllowMultiple(false);
            elementTreeSelectionDialog.setDoubleClickSelects(true);
            elementTreeSelectionDialog.addFilter(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    IFile currentFile;
                    boolean ret = false;
                    if (element instanceof IContainer) {
                        ret = true;
                    } else if (element instanceof IFile && (currentFile = (IFile)element).getFileExtension() != null) {
                        ret = type == 32 ? currentFile.getFileExtension().toUpperCase().equals("ASM") : true;
                    }
                    return ret;
                }
            });
            elementTreeSelectionDialog.setValidator(new ISelectionStatusValidator(){

                public IStatus validate(Object[] selection) {
                    IStatus ret = Status.CANCEL_STATUS;
                    if (selection.length == 1 && selection[0] instanceof IFile) {
                        ret = Status.OK_STATUS;
                    }
                    return ret;
                }
            });
            elementTreeSelectionDialog.open();
            Object result = elementTreeSelectionDialog.getFirstResult();
            if (result != null && result instanceof IFile) {
                IFile currentFile = (IFile)result;
                ret = currentFile.getFullPath().toString();
            }
        }
        return ret;
    }

    private Map buildMetamodelsControls(Group parent, final String metamodelName, final int type, boolean removable) {
        HashMap<String, Object> thisGroupWidgets = new HashMap<String, Object>();
        final Label metamodelLabel = new Label((Composite)parent, 0);
        metamodelLabel.setText(String.valueOf(metamodelName) + ": ");
        final Text metamodelLocation = new Text((Composite)parent, 2048);
        thisGroupWidgets.put("metamodelLocation", metamodelLocation);
        metamodelLocation.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 6, 1));
        final Button remove = new Button((Composite)parent, 0);
        remove.setText("X");
        if (!removable) {
            new Label((Composite)parent, 0);
        }
        final Button isMetametamodel = new Button((Composite)parent, 32);
        thisGroupWidgets.put("isMetametamodel", isMetametamodel);
        isMetametamodel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 2, 1));
        isMetametamodel.setText("Is metametamodel");
        isMetametamodel.setToolTipText(AtlDebugMessages.getString("MainAtlTab.MODELHANDLERCHOICE"));
        final Label modelHandlerLabel = new Label((Composite)parent, 0);
        modelHandlerLabel.setText("Model handler: ");
        modelHandlerLabel.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        final Combo modelHandlers = new Combo((Composite)parent, 8);
        thisGroupWidgets.put("modelHandlers", modelHandlers);
        modelHandlers.setItems(AtlLauncherTools.getModelHandlers());
        modelHandlers.select(AtlLauncherTools.getEMFKey());
        modelHandlers.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        final Button browseWorkspace = new Button((Composite)parent, 0);
        browseWorkspace.setText("Workspace...");
        final Button browseFilesystem = new Button((Composite)parent, 0);
        browseFilesystem.setText("File system...");
        final Button browseEMFRegistry = new Button((Composite)parent, 0);
        browseEMFRegistry.setText("EMF Registry...");
        final Label filler = new Label((Composite)parent, 0);
        filler.setLayoutData((Object)new GridData(0, 0, false, false, 1, 1));
        metamodelLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (metamodelLocation.getText().startsWith("uri:")) {
                    modelHandlers.select(AtlLauncherTools.getEMFKey());
                    modelHandlers.setEnabled(true);
                } else {
                    modelHandlers.setEnabled(true);
                }
                MainAtlTab.this.updateLaunchConfigurationDialog();
            }
        });
        isMetametamodel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                metamodelLocation.setEnabled(!isMetametamodel.getSelection());
                browseWorkspace.setEnabled(!isMetametamodel.getSelection());
                browseFilesystem.setEnabled(!isMetametamodel.getSelection());
                browseEMFRegistry.setEnabled(!isMetametamodel.getSelection());
                if (isMetametamodel.getSelection()) {
                    modelHandlers.setEnabled(true);
                } else {
                    metamodelLocation.notifyListeners(24, null);
                }
                MainAtlTab.this.updateLaunchConfigurationDialog();
            }
        });
        modelHandlers.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MainAtlTab.this.updateLaunchConfigurationDialog();
            }
        });
        browseWorkspace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                String path = MainAtlTab.this.editPath(type);
                if (path.trim().length() > 0) {
                    metamodelLocation.setText(path);
                }
            }
        });
        browseFilesystem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                String path = MainAtlTab.this.editExternalPath(type);
                if (path.trim().length() > 0) {
                    metamodelLocation.setText(path);
                }
            }
        });
        browseEMFRegistry.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                DialogUriSelection launcher = new DialogUriSelection(new Shell());
                launcher.create();
                if (launcher.open() == 0) {
                    metamodelLocation.setText("uri:" + launcher.getUriSelected());
                }
            }
        });
        SelectionAdapter removeAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                MainAtlTab.this.metamodelsGroupWidgets.remove(metamodelName);
                MainAtlTab.this.sourceMetamodelsFromModule.remove(metamodelName);
                MainAtlTab.this.targetMetamodelsFromModule.remove(metamodelName);
                MainAtlTab.this.updateModelsGroupFor(metamodelName);
                metamodelLabel.dispose();
                metamodelLocation.dispose();
                isMetametamodel.dispose();
                modelHandlerLabel.dispose();
                modelHandlers.dispose();
                browseWorkspace.dispose();
                browseFilesystem.dispose();
                browseEMFRegistry.dispose();
                remove.dispose();
                filler.dispose();
                MainAtlTab.this.layout();
            }
        };
        remove.addSelectionListener((SelectionListener)removeAdapter);
        thisGroupWidgets.put("removeAdapter", removeAdapter);
        if (!removable) {
            remove.dispose();
        }
        return thisGroupWidgets;
    }

    private Map buildModelsAndLibrariesControls(Group parent, final String modelName, String metamodelName, final int type, boolean removable) {
        HashMap<String, Object> thisGroupWidgets = new HashMap<String, Object>();
        final Label modelLabel = new Label((Composite)parent, 0);
        modelLabel.setText(String.valueOf(modelName) + ": ");
        final Text location = new Text((Composite)parent, 2048);
        thisGroupWidgets.put("location", location);
        location.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        final Button remove = new Button((Composite)parent, 0);
        remove.setText("X");
        thisGroupWidgets.put("remove", remove);
        if (!removable) {
            new Label((Composite)parent, 0);
        }
        final Label metamodelLabel = new Label((Composite)parent, 0);
        if (metamodelName != null) {
            metamodelLabel.setText("conforms to " + metamodelName);
        }
        final Button browseWorkspace = new Button((Composite)parent, 0);
        browseWorkspace.setText("Workspace...");
        browseWorkspace.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        final Button browseFilesystem = new Button((Composite)parent, 0);
        browseFilesystem.setText("File system...");
        final Label filler = new Label((Composite)parent, 0);
        filler.setLayoutData((Object)new GridData(0, 0, false, false, 1, 1));
        location.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MainAtlTab.this.updateLaunchConfigurationDialog();
            }
        });
        browseWorkspace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                String path = MainAtlTab.this.editPath(type);
                if (path.trim().length() > 0) {
                    location.setText(path);
                }
            }
        });
        browseFilesystem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                String path = MainAtlTab.this.editExternalPath(type);
                if (path.trim().length() > 0) {
                    location.setText(path);
                }
            }
        });
        SelectionAdapter removeAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (MainAtlTab.this.sourceModelsGroupWidgets.get(modelName) != null) {
                    MainAtlTab.this.sourceModelsGroupWidgets.remove(modelName);
                    MainAtlTab.this.sourceModelsFromModule.remove(modelName);
                    String mmName = (String)MainAtlTab.this.sourceC2RelationshipFromModule.remove(modelName);
                    MainAtlTab.this.updateMetamodelsGroupFor(mmName);
                } else if (MainAtlTab.this.targetModelsGroupWidgets.get(modelName) != null) {
                    MainAtlTab.this.targetModelsGroupWidgets.remove(modelName);
                    MainAtlTab.this.targetModelsFromModule.remove(modelName);
                    String mmName = (String)MainAtlTab.this.targetC2RelationshipFromModule.remove(modelName);
                    MainAtlTab.this.updateMetamodelsGroupFor(mmName);
                } else {
                    MainAtlTab.this.librariesGroupWidgets.remove(modelName);
                    MainAtlTab.this.librariesFromModule.remove(modelName);
                }
                modelLabel.dispose();
                metamodelLabel.dispose();
                location.dispose();
                browseWorkspace.dispose();
                browseFilesystem.dispose();
                remove.dispose();
                filler.dispose();
                MainAtlTab.this.layout();
            }
        };
        remove.addSelectionListener((SelectionListener)removeAdapter);
        thisGroupWidgets.put("removeAdapter", removeAdapter);
        if (!removable) {
            remove.dispose();
        }
        return thisGroupWidgets;
    }

    private void updateMetamodelsGroupFor(String metamodelName) {
        Map widgets;
        if (!this.sourceC2RelationshipFromModule.values().contains(metamodelName) && !this.targetC2RelationshipFromModule.values().contains(metamodelName) && (widgets = (Map)this.metamodelsGroupWidgets.get(metamodelName)) != null) {
            SelectionAdapter removeAdapter = (SelectionAdapter)widgets.get("removeAdapter");
            removeAdapter.widgetSelected(null);
        }
    }

    private void updateModelsGroupFor(String metamodelName) {
        SelectionAdapter removeAdapter;
        Map widgets;
        Map.Entry entry;
        Iterator i = this.sourceC2RelationshipFromModule.entrySet().iterator();
        while (i.hasNext()) {
            entry = i.next();
            if (!entry.getValue().equals(metamodelName)) continue;
            i.remove();
            widgets = (Map)this.sourceModelsGroupWidgets.get(entry.getKey());
            if (widgets == null) continue;
            removeAdapter = (SelectionAdapter)widgets.get("removeAdapter");
            removeAdapter.widgetSelected(null);
        }
        i = this.targetC2RelationshipFromModule.entrySet().iterator();
        while (i.hasNext()) {
            entry = i.next();
            if (!entry.getValue().equals(metamodelName)) continue;
            i.remove();
            widgets = (Map)this.targetModelsGroupWidgets.get(entry.getKey());
            if (widgets == null) continue;
            removeAdapter = (SelectionAdapter)widgets.get("removeAdapter");
            removeAdapter.widgetSelected(null);
        }
    }

    private void disposeGroupChildren(Group group) {
        Control[] controls = group.getChildren();
        int i = 0;
        while (i < controls.length) {
            controls[i].dispose();
            ++i;
        }
    }

    private void getModelsFromATLFile(IFile file) {
        try {
            ASMModel atlmodel;
            if (this.asmFileCache.containsKey(file)) {
                atlmodel = (ASMModel)this.asmFileCache.get(file);
            } else {
                InputStream input = file.getContents();
                atlmodel = AtlParser.getDefault().parseToModel(input);
                input.close();
                this.asmFileCache.put(file, atlmodel);
            }
            Set module = atlmodel.getElementsByType("Module");
            Set query = atlmodel.getElementsByType("Query");
            if (module.size() > 0) {
                String metamodelName;
                String modelName;
                ASMModelElement current;
                ASMModelElement atlModule = (ASMModelElement)module.toArray()[0];
                Iterator inModelsIt = ((ASMCollection)atlModule.get(null, "inModels")).iterator();
                Iterator outModelsIt = ((ASMCollection)atlModule.get(null, "outModels")).iterator();
                Iterator librariesIt = ((ASMCollection)atlModule.get(null, "libraries")).iterator();
                while (inModelsIt.hasNext()) {
                    current = (ASMModelElement)inModelsIt.next();
                    if (current.get(null, "metamodel") instanceof ASMOclUndefined) continue;
                    modelName = ((ASMString)current.get(null, "name")).getSymbol();
                    metamodelName = ((ASMString)current.get(null, "metamodel").get(null, "name")).getSymbol();
                    if (!this.sourceMetamodelsFromModule.contains(metamodelName)) {
                        this.sourceMetamodelsFromModule.add(metamodelName);
                    }
                    if (this.sourceModelsFromModule.contains(modelName)) continue;
                    this.sourceModelsFromModule.add(modelName);
                    this.sourceC2RelationshipFromModule.put(modelName, metamodelName);
                }
                while (outModelsIt.hasNext()) {
                    current = (ASMModelElement)outModelsIt.next();
                    if (current.get(null, "metamodel") instanceof ASMOclUndefined) continue;
                    modelName = ((ASMString)current.get(null, "name")).getSymbol();
                    metamodelName = ((ASMString)current.get(null, "metamodel").get(null, "name")).getSymbol();
                    if (!this.targetMetamodelsFromModule.contains(metamodelName)) {
                        this.targetMetamodelsFromModule.add(metamodelName);
                    }
                    if (this.targetModelsFromModule.contains(modelName)) continue;
                    this.targetModelsFromModule.add(modelName);
                    this.targetC2RelationshipFromModule.put(modelName, metamodelName);
                }
                while (librariesIt.hasNext()) {
                    current = (ASMModelElement)librariesIt.next();
                    String library = ((ASMString)current.get(null, "name")).getSymbol();
                    if (this.nonLibraries.contains(library) || this.librariesFromModule.contains(library)) continue;
                    this.librariesFromModule.add(library);
                }
            } else if (query.size() > 0) {
                ASMModelElement atlQuery = (ASMModelElement)query.toArray()[0];
                Set models = atlQuery.getModel().getElementsByType("OclModel");
                for (ASMModelElement model : models) {
                    String modelName = "IN";
                    String metamodelName = ((ASMString)model.get(null, "name")).getSymbol();
                    if (!this.sourceMetamodelsFromModule.contains(metamodelName)) {
                        this.sourceMetamodelsFromModule.add(metamodelName);
                    }
                    if (this.sourceModelsFromModule.contains(modelName)) continue;
                    this.sourceModelsFromModule.add(modelName);
                    this.sourceC2RelationshipFromModule.put(modelName, metamodelName);
                }
                for (ASMModelElement current : (ASMCollection)atlQuery.get(null, "libraries")) {
                    String library = ((ASMString)current.get(null, "name")).getSymbol();
                    if (this.nonLibraries.contains(library) || this.librariesFromModule.contains(library)) continue;
                    this.librariesFromModule.add(library);
                }
            }
        }
        catch (Exception e1) {
            logger.log(Level.SEVERE, e1.getLocalizedMessage(), e1);
        }
    }
}

