/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime.debug;

import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.debug.DebugEventListener;

public class DebugTokenStream
implements TokenStream {
    protected DebugEventListener dbg;
    public TokenStream input;
    protected boolean initialStreamState = true;
    protected int lastMarker;

    public DebugTokenStream(TokenStream tokenStream, DebugEventListener debugEventListener) {
        this.input = tokenStream;
        this.setDebugListener(debugEventListener);
        tokenStream.LT(1);
    }

    public void setDebugListener(DebugEventListener debugEventListener) {
        this.dbg = debugEventListener;
    }

    public void consume() {
        if (this.initialStreamState) {
            this.consumeInitialHiddenTokens();
        }
        int n = this.input.index();
        Token token = this.input.LT(1);
        this.input.consume();
        int n2 = this.input.index();
        this.dbg.consumeToken(token);
        if (n2 > n + 1) {
            for (int i = n + 1; i < n2; ++i) {
                this.dbg.consumeHiddenToken(this.input.get(i));
            }
        }
    }

    protected void consumeInitialHiddenTokens() {
        int n = this.input.index();
        for (int i = 0; i < n; ++i) {
            this.dbg.consumeHiddenToken(this.input.get(i));
        }
        this.initialStreamState = false;
    }

    public Token LT(int n) {
        if (this.initialStreamState) {
            this.consumeInitialHiddenTokens();
        }
        this.dbg.LT(n, this.input.LT(n));
        return this.input.LT(n);
    }

    public int LA(int n) {
        if (this.initialStreamState) {
            this.consumeInitialHiddenTokens();
        }
        this.dbg.LT(n, this.input.LT(n));
        return this.input.LA(n);
    }

    public Token get(int n) {
        return this.input.get(n);
    }

    public int mark() {
        this.lastMarker = this.input.mark();
        this.dbg.mark(this.lastMarker);
        return this.lastMarker;
    }

    public int index() {
        return this.input.index();
    }

    public void rewind(int n) {
        this.dbg.rewind(n);
        this.input.rewind(n);
    }

    public void rewind() {
        this.dbg.rewind();
        this.input.rewind(this.lastMarker);
    }

    public void release(int n) {
    }

    public void seek(int n) {
        this.input.seek(n);
    }

    public int size() {
        return this.input.size();
    }

    public TokenSource getTokenSource() {
        return this.input.getTokenSource();
    }

    public String toString() {
        return this.input.toString();
    }

    public String toString(int n, int n2) {
        return this.input.toString(n, n2);
    }

    public String toString(Token token, Token token2) {
        return this.input.toString(token, token2);
    }
}

