/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.profiler.ui.profilingdatatable;

import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.m2m.atl.profiler.core.util.ProfilingModelUtils;
import org.eclipse.m2m.atl.profiler.model.ATLOperation;
import org.eclipse.m2m.atl.profiler.model.ProfilingOperation;

public class TimeComparator
extends ViewerComparator {
    private boolean asc;

    public TimeComparator() {
        this.asc = true;
    }

    public TimeComparator(boolean asc) {
        this.asc = asc;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        if (e1 instanceof ATLOperation) {
            ATLOperation op1 = (ATLOperation)e1;
            ATLOperation op2 = (ATLOperation)e2;
            double t1 = ProfilingModelUtils.getTotalTime((EList)op1.getProfilingInstructions());
            double t2 = ProfilingModelUtils.getTotalTime((EList)op2.getProfilingInstructions());
            double res = t1 - t2;
            if (!this.asc) {
                res = t2 - t1;
            }
            if (res > 0.0) {
                return 1;
            }
            if (res == 0.0) {
                return 0;
            }
            return -1;
        }
        if (e1 instanceof ProfilingOperation) {
            ProfilingOperation pop1 = (ProfilingOperation)e1;
            ProfilingOperation pop2 = (ProfilingOperation)e2;
            double t1 = pop1.getEndTime() - pop1.getLaunchedTime();
            double t2 = pop2.getEndTime() - pop2.getLaunchedTime();
            double res = t1 - t2;
            if (!this.asc) {
                res = t2 - t1;
            }
            if (res > 0.0) {
                return 1;
            }
            if (res == 0.0) {
                return 0;
            }
            return -1;
        }
        return 0;
    }
}

