/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.text;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.m2m.atl.adt.ui.AtlUIPlugin;
import org.eclipse.m2m.atl.adt.ui.text.AtlColorManager;
import org.eclipse.m2m.atl.adt.ui.text.atl.AtlCompletionProcessor;
import org.eclipse.swt.graphics.Color;

public class AtlContentAssistPreference {
    private AtlContentAssistPreference() {
    }

    public static void changeConfiguration(ContentAssistant assistant, IPreferenceStore store, PropertyChangeEvent event) {
        String property = event.getProperty();
        AtlColorManager colorManager = AtlUIPlugin.getDefault().getTextTools().getColorManager();
        if ("Atl.CodeAssist.AutoActivation.Enable".equals(property)) {
            assistant.enableAutoActivation(store.getBoolean("Atl.CodeAssist.AutoActivation.Enable"));
        } else if ("Atl.CodeAssist.AutoActivation.Delay".equals(property)) {
            assistant.setAutoActivationDelay(store.getInt("Atl.CodeAssist.AutoActivation.Delay"));
        } else if ("Atl.CodeAssist.AutoInsert".equals(property)) {
            assistant.enableAutoInsert(store.getBoolean("Atl.CodeAssist.AutoInsert"));
        } else if ("Atl.CodeAssist.ProposalsBackground".equals(property)) {
            assistant.setProposalSelectorBackground(AtlContentAssistPreference.getColor(store, "Atl.CodeAssist.ProposalsBackground", colorManager));
        } else if ("Atl.CodeAssist.ProposalsForeground".equals(property)) {
            assistant.setProposalSelectorForeground(AtlContentAssistPreference.getColor(store, "Atl.CodeAssist.ProposalsForeground", colorManager));
        } else if ("Atl.CodeAssist.ParametersBackground".equals(property)) {
            Color c = AtlContentAssistPreference.getColor(store, "Atl.CodeAssist.ParametersBackground", colorManager);
            assistant.setContextInformationPopupBackground(c);
            assistant.setContextSelectorBackground(c);
        } else if ("Atl.CodeAssist.ParametersForeground".equals(property)) {
            Color c = AtlContentAssistPreference.getColor(store, "Atl.CodeAssist.ParametersForeground", colorManager);
            assistant.setContextInformationPopupForeground(c);
            assistant.setContextSelectorForeground(c);
        } else if ("Atl.CodeAssist.PrefixCompletion".equals(property)) {
            assistant.enablePrefixCompletion(store.getBoolean("Atl.CodeAssist.PrefixCompletion"));
        }
        AtlContentAssistPreference.changeProcessor(assistant, store, property);
    }

    private static void changeProcessor(ContentAssistant assistant, IPreferenceStore store, String key) {
        AtlCompletionProcessor cp = AtlContentAssistPreference.getProcessor(assistant);
        if (cp == null) {
            return;
        }
        if ("Atl.CodeAssist.AutoActivation.Triggers".equals(key)) {
            String triggers = store.getString("Atl.CodeAssist.AutoActivation.Triggers");
            if (triggers != null) {
                cp.setCompletionProposalAutoActivationCharacters(triggers.toCharArray());
            }
        } else if ("Atl.CodeAssist.ShowVisibleProposals".equals(key)) {
            boolean enabled = store.getBoolean("Atl.CodeAssist.ShowVisibleProposals");
            cp.restrictProposalsToVisibility(enabled);
        } else if ("Atl.CodeAssist.CaseSensitivity".equals(key)) {
            boolean enabled = store.getBoolean("Atl.CodeAssist.CaseSensitivity");
            cp.restrictProposalsToMatchingCases(enabled);
        } else if ("Atl.CodeAssist.OrderProposals".equals(key)) {
            boolean enable = store.getBoolean("Atl.CodeAssist.OrderProposals");
            cp.orderProposalsAlphabetically(enable);
        }
    }

    public static void configure(ContentAssistant assistant, IPreferenceStore store) {
        AtlColorManager manager = AtlUIPlugin.getDefault().getTextTools().getColorManager();
        assistant.enableAutoActivation(store.getBoolean("Atl.CodeAssist.AutoActivation.Enable"));
        assistant.setAutoActivationDelay(store.getInt("Atl.CodeAssist.AutoActivation.Delay"));
        assistant.enableAutoInsert(store.getBoolean("Atl.CodeAssist.AutoInsert"));
        assistant.setProposalSelectorBackground(AtlContentAssistPreference.getColor(store, "Atl.CodeAssist.ProposalsBackground", manager));
        assistant.setProposalSelectorForeground(AtlContentAssistPreference.getColor(store, "Atl.CodeAssist.ProposalsForeground", manager));
        assistant.enablePrefixCompletion(store.getBoolean("Atl.CodeAssist.PrefixCompletion"));
        assistant.setProposalPopupOrientation(10);
        Color background = AtlContentAssistPreference.getColor(store, "Atl.CodeAssist.ProposalsBackground", manager);
        assistant.setContextInformationPopupBackground(background);
        assistant.setContextSelectorBackground(background);
        assistant.setProposalSelectorBackground(background);
        Color foreground = AtlContentAssistPreference.getColor(store, "Atl.CodeAssist.ProposalsForeground", manager);
        assistant.setContextInformationPopupForeground(foreground);
        assistant.setContextSelectorForeground(foreground);
        assistant.setProposalSelectorForeground(foreground);
        AtlContentAssistPreference.configureProcessor(assistant, store);
    }

    private static void configureProcessor(ContentAssistant assistant, IPreferenceStore store) {
        AtlCompletionProcessor cp = AtlContentAssistPreference.getProcessor(assistant);
        if (cp == null) {
            return;
        }
        String triggers = store.getString("Atl.CodeAssist.AutoActivation.Triggers");
        if (triggers != null) {
            cp.setCompletionProposalAutoActivationCharacters(triggers.toCharArray());
        }
        cp.restrictProposalsToVisibility(store.getBoolean("Atl.CodeAssist.ShowVisibleProposals"));
        cp.restrictProposalsToMatchingCases(store.getBoolean("Atl.CodeAssist.CaseSensitivity"));
        cp.orderProposalsAlphabetically(store.getBoolean("Atl.CodeAssist.OrderProposals"));
    }

    private static Color getColor(IPreferenceStore store, String key, AtlColorManager colorManager) {
        return colorManager.getColor(PreferenceConverter.getColor((IPreferenceStore)store, (String)key));
    }

    private static AtlCompletionProcessor getProcessor(ContentAssistant assistant) {
        IContentAssistProcessor p = assistant.getContentAssistProcessor("__dftl_partition_content_type");
        if (p instanceof AtlCompletionProcessor) {
            return (AtlCompletionProcessor)p;
        }
        return null;
    }
}

