/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.emfvm;

import org.eclipse.m2m.atl.engine.emfvm.ASMOperation;
import org.eclipse.m2m.atl.engine.emfvm.lib.ASMModule;
import org.eclipse.m2m.atl.engine.emfvm.lib.AbstractStackFrame;
import org.eclipse.m2m.atl.engine.emfvm.lib.ExecEnv;
import org.eclipse.m2m.atl.engine.emfvm.lib.Operation;

public class StackFrame
extends AbstractStackFrame {
    private int pc = -1;

    public StackFrame(ExecEnv execEnv, ASMModule asmModule, Operation operation) {
        super(execEnv, asmModule, operation);
    }

    protected StackFrame(StackFrame caller, Operation operation) {
        super(caller, operation);
    }

    public StackFrame(ExecEnv execEnv) {
        super(execEnv);
    }

    public AbstractStackFrame newFrame(Operation operation) {
        return new StackFrame(this, operation);
    }

    protected String getStringLocation() {
        String ret = ((ASMOperation)this.operation).resolveLineNumber(this.pc);
        if (ret == null) {
            ret = "";
        }
        ret = String.valueOf(ret) + "#" + this.pc;
        return ret;
    }

    public int getLocation() {
        return this.pc;
    }

    public String resolveVariableName(int slot) {
        return this.getOperation().resolveVariableName(slot, this.pc);
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        if (this.operation instanceof ASMOperation) {
            ret.append("\tat ");
            ret.append(((ASMOperation)this.operation).getName());
            ret.append("#" + this.getLocation());
            ret.append('(');
            ret.append(String.valueOf(((ASMOperation)this.operation).getASM().getName()) + ".atl");
            String location = this.getStringLocation();
            if (location != null && location.matches("[0-9]*:[0-9]*-[0-9]*:[0-9]*#[0-9]*")) {
                ret.append(String.valueOf('[') + location.split("#")[0] + ']');
            }
            ret.append(')');
            ret.append("\n\t\tlocal variables: ");
            boolean first = true;
            ASMOperation ao = (ASMOperation)this.operation;
            int i = 0;
            while (i < ao.getMaxLocals()) {
                String varName = ao.resolveVariableName(i, this.pc);
                if (varName != null) {
                    if (!first) {
                        ret.append(", ");
                    }
                    first = false;
                    ret.append(varName);
                    ret.append('=');
                    ret.append(this.getExecEnv().toPrettyPrintedString(this.localVars[i]));
                }
                ++i;
            }
        } else {
            ret.append("<native>");
        }
        if (this.caller != null) {
            ret.append('\n');
            ret.append(this.caller.toString());
        }
        return ret.toString();
    }

    public int getPc() {
        return this.pc;
    }

    public void setPc(int pc) {
        this.pc = pc;
    }
}

