/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.outline;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.m2m.atl.adt.ui.AtlUIPlugin;
import org.eclipse.m2m.atl.adt.ui.outline.AtlEMFConstants;
import org.eclipse.m2m.atl.adt.ui.outline.Root;
import org.eclipse.swt.graphics.Image;

public class AtlLabelProvider
extends LabelProvider {
    private boolean initialized = false;
    private Map<EClass, Reader> readers = new HashMap<EClass, Reader>();
    private Map<ImageDescriptor, Image> imageCache = new HashMap<ImageDescriptor, Image>();
    private Map<String, String> classToImages = new HashMap<String, String>();
    private Reader defaultReader = new Reader(this){

        public String getText(EObject object) {
            return "<default> : " + object.eClass().getName();
        }
    };

    public AtlLabelProvider() {
        this.initForImages();
    }

    public void initReaders() {
        this.readers.put(AtlEMFConstants.clRule, new Reader(this){
            private EStructuralFeature name;
            {
                this.name = AtlEMFConstants.clRule.getEStructuralFeature("name");
            }

            public String getText(EObject rule) {
                return (String)rule.eGet(this.name);
            }
        });
        this.readers.put(AtlEMFConstants.clMatchedRule, this.readers.get(AtlEMFConstants.clRule));
        this.readers.put(AtlEMFConstants.clLazyMatchedRule, this.readers.get(AtlEMFConstants.clRule));
        this.readers.put(AtlEMFConstants.clCalledRule, this.readers.get(AtlEMFConstants.clRule));
        this.readers.put(AtlEMFConstants.clHelper, new Reader(this){
            private EStructuralFeature sfFeature;
            {
                this.sfFeature = AtlEMFConstants.clOclFeatureDefinition.getEStructuralFeature("feature");
            }

            public String getText(EObject helper) {
                EObject featureDef = (EObject)helper.eGet(AtlEMFConstants.sfHelperDefinition);
                if (featureDef != null) {
                    EObject feature = (EObject)featureDef.eGet(this.sfFeature);
                    if (feature == null) {
                        return null;
                    }
                    return (String)feature.eGet(feature.eClass().getEStructuralFeature("name"));
                }
                return null;
            }
        });
        this.readers.put(AtlEMFConstants.clLibraryRef, new Reader(this){
            private EStructuralFeature sfName;
            {
                this.sfName = AtlEMFConstants.clLibraryRef.getEStructuralFeature("name");
            }

            public String getText(EObject libraryRef) {
                return (String)libraryRef.eGet(this.sfName);
            }
        });
        this.readers.put(AtlEMFConstants.clOclModel, new Reader(this){
            private EStructuralFeature sfName;
            {
                this.sfName = AtlEMFConstants.clOclModel.getEStructuralFeature("name");
            }

            public String getText(EObject oclModel) {
                return (String)oclModel.eGet(this.sfName);
            }
        });
        this.readers.put(AtlEMFConstants.clVariableDeclaration, new Reader(this){
            private EStructuralFeature sfVarName;
            {
                this.sfVarName = AtlEMFConstants.clVariableDeclaration.getEStructuralFeature("varName");
            }

            public String getText(EObject variableDeclaration) {
                return (String)variableDeclaration.eGet(this.sfVarName);
            }
        });
        this.readers.put(AtlEMFConstants.clUnit, new Reader(this){
            private EStructuralFeature sfName;
            {
                this.sfName = AtlEMFConstants.clUnit.getEStructuralFeature("name");
            }

            public String getText(EObject unit) {
                return (String)unit.eGet(this.sfName);
            }
        });
        this.readers.put(AtlEMFConstants.clModule, this.readers.get(AtlEMFConstants.clUnit));
        this.readers.put(AtlEMFConstants.clLibrary, this.readers.get(AtlEMFConstants.clUnit));
        this.readers.put(AtlEMFConstants.clQuery, this.readers.get(AtlEMFConstants.clUnit));
        this.readers.put(AtlEMFConstants.clVariableDeclaration, new Reader(this){

            public String getText(EObject rule) {
                return (String)rule.eGet(AtlEMFConstants.sfVarName);
            }
        });
        this.readers.put(AtlEMFConstants.clPatternElement, this.readers.get(AtlEMFConstants.clVariableDeclaration));
        this.readers.put(AtlEMFConstants.clRuleVariableDeclaration, this.readers.get(AtlEMFConstants.clVariableDeclaration));
        this.readers.put(AtlEMFConstants.clParameter, this.readers.get(AtlEMFConstants.clVariableDeclaration));
        this.readers.put(AtlEMFConstants.clInPatternElement, this.readers.get(AtlEMFConstants.clPatternElement));
        this.readers.put(AtlEMFConstants.clSimpleInPatternElement, this.readers.get(AtlEMFConstants.clInPatternElement));
        this.readers.put(AtlEMFConstants.clOutPatternElement, this.readers.get(AtlEMFConstants.clPatternElement));
        this.readers.put(AtlEMFConstants.clSimpleOutPatternElement, this.readers.get(AtlEMFConstants.clOutPatternElement));
    }

    private void initForText(EObject unit) {
        if (!this.initialized) {
            AtlEMFConstants.pkAtl = unit.eClass().getEPackage();
            AtlEMFConstants.clModule = (EClass)AtlEMFConstants.pkAtl.getEClassifier("Module");
            AtlEMFConstants.clLibrary = (EClass)AtlEMFConstants.pkAtl.getEClassifier("Library");
            AtlEMFConstants.clQuery = (EClass)AtlEMFConstants.pkAtl.getEClassifier("Query");
            AtlEMFConstants.sfModuleElements = AtlEMFConstants.clModule.getEStructuralFeature("elements");
            AtlEMFConstants.clRule = (EClass)AtlEMFConstants.pkAtl.getEClassifier("Rule");
            AtlEMFConstants.clMatchedRule = (EClass)AtlEMFConstants.pkAtl.getEClassifier("MatchedRule");
            AtlEMFConstants.clLazyMatchedRule = (EClass)AtlEMFConstants.pkAtl.getEClassifier("LazyMatchedRule");
            AtlEMFConstants.clCalledRule = (EClass)AtlEMFConstants.pkAtl.getEClassifier("CalledRule");
            AtlEMFConstants.clHelper = (EClass)AtlEMFConstants.pkAtl.getEClassifier("Helper");
            AtlEMFConstants.sfHelperDefinition = AtlEMFConstants.clHelper.getEStructuralFeature("definition");
            AtlEMFConstants.clLibraryRef = (EClass)AtlEMFConstants.pkAtl.getEClassifier("LibraryRef");
            AtlEMFConstants.clUnit = (EClass)AtlEMFConstants.pkAtl.getEClassifier("Unit");
            AtlEMFConstants.clPatternElement = (EClass)AtlEMFConstants.pkAtl.getEClassifier("PatternElement");
            AtlEMFConstants.clRuleVariableDeclaration = (EClass)AtlEMFConstants.pkAtl.getEClassifier("RuleVariableDeclaration");
            AtlEMFConstants.clInPatternElement = (EClass)AtlEMFConstants.pkAtl.getEClassifier("InPatternElement");
            AtlEMFConstants.clOutPatternElement = (EClass)AtlEMFConstants.pkAtl.getEClassifier("OutPatternElement");
            AtlEMFConstants.clSimpleInPatternElement = (EClass)AtlEMFConstants.pkAtl.getEClassifier("SimpleInPatternElement");
            AtlEMFConstants.clSimpleOutPatternElement = (EClass)AtlEMFConstants.pkAtl.getEClassifier("SimpleOutPatternElement");
            AtlEMFConstants.clInPattern = (EClass)AtlEMFConstants.pkAtl.getEClassifier("InPattern");
            AtlEMFConstants.clOutPattern = (EClass)AtlEMFConstants.pkAtl.getEClassifier("OutPattern");
            AtlEMFConstants.pkOcl = AtlEMFConstants.sfHelperDefinition.getEType().getEPackage();
            AtlEMFConstants.clOclFeatureDefinition = (EClass)AtlEMFConstants.pkOcl.getEClassifier("OclFeatureDefinition");
            AtlEMFConstants.clOclFeature = (EClass)AtlEMFConstants.pkOcl.getEClassifier("OclFeature");
            AtlEMFConstants.clOclModel = (EClass)AtlEMFConstants.pkOcl.getEClassifier("OclModel");
            AtlEMFConstants.clParameter = (EClass)AtlEMFConstants.pkOcl.getEClassifier("Parameter");
            AtlEMFConstants.clVariableDeclaration = (EClass)AtlEMFConstants.pkOcl.getEClassifier("VariableDeclaration");
            AtlEMFConstants.sfVarName = AtlEMFConstants.clVariableDeclaration.getEStructuralFeature("varName");
            AtlEMFConstants.clElement = (EClass)AtlEMFConstants.pkAtl.getEClassifier("LocatedElement");
            AtlEMFConstants.sfLocation = AtlEMFConstants.clElement.getEStructuralFeature("location");
            this.initReaders();
            this.initialized = true;
        }
    }

    private void initForImages() {
        this.classToImages.put("Library", "libs.gif");
        this.classToImages.put("Module", "module.gif");
        this.classToImages.put("Query", "query.gif");
        this.classToImages.put("OclModel", "oclModel.gif");
        this.classToImages.put("LibraryRef", "libsreference.gif");
        this.classToImages.put("Helper", "helper.gif");
        this.classToImages.put("MatchedRule", "matchedRule.gif");
        this.classToImages.put("LazyMatchedRule", "lazyRule.gif");
        this.classToImages.put("Operation", "operation.gif");
        this.classToImages.put("InPattern", "inPattern.gif");
        this.classToImages.put("OutPattern", "outPattern.gif");
        this.classToImages.put("Binding", "binding.gif");
        this.classToImages.put("Iterator", "iterator.gif");
        this.classToImages.put("SimpleInPatternElement", "element.gif");
        this.classToImages.put("SimpleOutPatternElement", "element.gif");
        this.classToImages.put("OperationCallExp", "expressionATL.gif");
        this.classToImages.put("OperatorCallExp", "expressionATL.gif");
        this.classToImages.put("NavigationOrAttributeCallExp", "expressionATL.gif");
        this.classToImages.put("EnumLiteralExp", "expressionATL.gif");
        this.classToImages.put("IteratorExp", "expressionATL.gif");
        this.classToImages.put("CollectionOperationCallExp", "expressionATL.gif");
        this.classToImages.put("IfExp", "expressionATL.gif");
        this.classToImages.put("StringExp", "expressionATL.gif");
        this.classToImages.put("VariableExp", "expressionATL.gif");
        this.classToImages.put("BooleanType", "type.gif");
        this.classToImages.put("OclModelElement", "type.gif");
        this.classToImages.put("StringType", "type.gif");
        this.classToImages.put("TupleType", "type.gif");
    }

    private ImageDescriptor getImage(String className) {
        String iconName = this.classToImages.get(className);
        if (iconName != null) {
            return AtlUIPlugin.getImageDescriptor(iconName);
        }
        return AtlUIPlugin.getImageDescriptor("test.gif");
    }

    public Image getImage(Object element) {
        Image ret = null;
        if (!(element instanceof Root)) {
            String className;
            ImageDescriptor descriptor;
            EObject eo = (EObject)element;
            if (AtlEMFConstants.clUnit.isInstance(element)) {
                this.initForText(eo);
            }
            if ((ret = this.imageCache.get(descriptor = this.getImage(className = ((EObject)element).eClass().getName()))) == null) {
                ret = descriptor.createImage();
                this.imageCache.put(descriptor, ret);
            }
        }
        return ret;
    }

    private Reader getReader(EObject eo) {
        Reader ret = null;
        ret = this.readers.get(eo.eClass());
        if (ret == null) {
            ret = this.defaultReader;
        }
        return ret;
    }

    public String getText(Object element) {
        String ret = "default";
        if (!(element instanceof Root)) {
            EObject eo = (EObject)element;
            this.initForText(eo);
            ret = this.getReader(eo).getText(eo);
            ret = String.valueOf(ret) + " : " + eo.eClass().getName();
        }
        return ret;
    }

    public void dispose() {
        Iterator<Image> images = this.imageCache.values().iterator();
        while (images.hasNext()) {
            images.next().dispose();
        }
        this.imageCache.clear();
    }

    protected RuntimeException unknownElement(Object element) {
        return new RuntimeException(element.getClass().getName());
    }

    private abstract class Reader {
        private Reader() {
        }

        public abstract String getText(EObject var1);
    }
}

