/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.launcher.debug;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.debug.core.adwp.BooleanValue;
import org.eclipse.m2m.atl.debug.core.adwp.IntegerValue;
import org.eclipse.m2m.atl.debug.core.adwp.NullValue;
import org.eclipse.m2m.atl.debug.core.adwp.ObjectReference;
import org.eclipse.m2m.atl.debug.core.adwp.RealValue;
import org.eclipse.m2m.atl.debug.core.adwp.StringValue;
import org.eclipse.m2m.atl.debug.core.adwp.Value;
import org.eclipse.m2m.atl.emftvm.CodeBlock;
import org.eclipse.m2m.atl.emftvm.EmftvmFactory;
import org.eclipse.m2m.atl.emftvm.ExecEnv;
import org.eclipse.m2m.atl.emftvm.Field;
import org.eclipse.m2m.atl.emftvm.Operation;
import org.eclipse.m2m.atl.emftvm.launcher.EmftvmLauncherPlugin;
import org.eclipse.m2m.atl.emftvm.launcher.debug.NetworkDebugger;
import org.eclipse.m2m.atl.emftvm.util.EMFTVMUtil;
import org.eclipse.m2m.atl.emftvm.util.StackFrame;
import org.eclipse.m2m.atl.emftvm.util.VMException;

public class LocalObjectReference
extends ObjectReference {
    private static final CodeBlock EMPTY_CB = EmftvmFactory.eINSTANCE.createCodeBlock();
    private static Map<List<Object>, ObjectReference> values = new HashMap<List<Object>, ObjectReference>();
    private static Map<Integer, ObjectReference> valuesById = new HashMap<Integer, ObjectReference>();
    private static int idGenerator;
    protected Object object;
    protected NetworkDebugger debugger;

    protected LocalObjectReference(Object object, int id, NetworkDebugger debugger) {
        super(id);
        this.object = object;
        this.debugger = debugger;
    }

    public Object getObject() {
        return this.object;
    }

    public String toString() {
        return this.object.toString();
    }

    public static ObjectReference valueOf(int objectId) {
        Integer id = objectId;
        ObjectReference ret = valuesById.get(id);
        assert (ret != null);
        return ret;
    }

    public static ObjectReference valueOf(Object object, NetworkDebugger debugger) {
        ArrayList<Object> key = new ArrayList<Object>();
        key.add(object);
        key.add(debugger);
        ObjectReference ret = values.get(key);
        if (ret == null) {
            int id = idGenerator++;
            ret = new LocalObjectReference(object, id, debugger);
            values.put(key, ret);
            valuesById.put(id, ret);
        }
        return ret;
    }

    public Value get(String propName) {
        Value ret = null;
        StackFrame frame = this.debugger.getLastFrame();
        ExecEnv env = this.debugger.getExecEnv();
        try {
            Object type = this.getType();
            Field field = env.findField(type, propName);
            if (field != null) {
                ret = this.object2value(field.getValue(this.object, frame));
            } else if (this.object instanceof EObject) {
                assert (type instanceof EClass);
                EStructuralFeature sf = ((EClass)type).getEStructuralFeature(propName);
                if (sf != null) {
                    ret = this.object2value(EMFTVMUtil.uncheckedGet((ExecEnv)env, (EObject)((EObject)this.object), (EStructuralFeature)sf));
                }
            }
        }
        catch (Exception e) {
            EmftvmLauncherPlugin.log(e);
        }
        return ret;
    }

    public void set(String propName, Value value) {
        ExecEnv env = this.debugger.getExecEnv();
        Object realValue = this.value2object(value);
        Object type = this.getType();
        Field field = env.findField(type, propName);
        if (field != null) {
            field.setValue(this.object, realValue);
        } else if (this.object instanceof EObject) {
            assert (type instanceof EClass);
            EStructuralFeature sf = ((EClass)type).getEStructuralFeature(propName);
            if (sf != null) {
                EMFTVMUtil.set((ExecEnv)env, (EObject)((EObject)this.object), (EStructuralFeature)sf, (Object)realValue);
            }
        }
    }

    private Object value2object(Value value) {
        Object ret = null;
        if (value instanceof LocalObjectReference) {
            ret = ((LocalObjectReference)value).object;
        } else if (value instanceof StringValue) {
            ret = ((StringValue)value).getValue();
        } else if (value instanceof IntegerValue) {
            ret = ((IntegerValue)value).getValue();
        } else if (value instanceof RealValue) {
            ret = ((RealValue)value).getValue();
        } else if (value instanceof BooleanValue) {
            ret = ((BooleanValue)value).getValue();
        }
        return ret;
    }

    private Object getType() {
        if (this.object instanceof EObject) {
            return ((EObject)this.object).eClass();
        }
        return this.object == null ? Void.TYPE : this.object.getClass();
    }

    public Value call(String opName, List<Value> args) {
        boolean debug = false;
        ExecEnv execEnv = this.debugger.getExecEnv();
        Value ret = null;
        Object type = this.getType();
        if (args.isEmpty()) {
            Operation op = execEnv.findOperation(type, opName);
            if (op == null) {
                try {
                    StackFrame frame = new StackFrame(execEnv, EMPTY_CB);
                    ret = this.object2value(EMFTVMUtil.invokeNative((StackFrame)frame, (Object)this.object, (String)opName));
                }
                catch (VMException e) {
                    ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
                }
                catch (UnsupportedOperationException e) {
                    ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
                }
            } else {
                CodeBlock body = op.getBody();
                StackFrame frame = new StackFrame(execEnv, body);
                frame.setLocal(this.object, 0, 0);
                Object o = body.execute(frame);
                ret = this.object2value(o);
            }
        } else {
            Object[] realArgs = this.getRealArgs(args);
            Object[] argTypes = EMFTVMUtil.getArgumentTypes((Object[])realArgs);
            Operation op = execEnv.findOperation(type, opName, argTypes);
            if (op == null) {
                try {
                    StackFrame frame = new StackFrame(execEnv, EMPTY_CB);
                    ret = this.object2value(EMFTVMUtil.invokeNative((StackFrame)frame, (Object)this.object, (String)opName, (Object[])realArgs));
                }
                catch (VMException e) {
                    ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
                }
                catch (UnsupportedOperationException e) {
                    ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
                }
            } else {
                CodeBlock body = op.getBody();
                StackFrame frame = new StackFrame(execEnv, body);
                frame.setLocals(this.object, realArgs);
                Object o = body.execute(frame);
                ret = this.object2value(o);
            }
        }
        return ret;
    }

    private Object[] getRealArgs(List<Value> args) {
        Object[] realArgs = new Object[args.size()];
        int i = 0;
        while (i < realArgs.length) {
            realArgs[i] = this.value2object(args.get(i));
            ++i;
        }
        return realArgs;
    }

    private Value object2value(Object o) {
        return LocalObjectReference.object2value(o, this.debugger);
    }

    public static Value object2value(Object o, NetworkDebugger debugger) {
        Object ret = null;
        ret = o instanceof String ? StringValue.valueOf((String)((String)o)) : (o instanceof Integer ? IntegerValue.valueOf((int)((Integer)o)) : (o instanceof Double ? RealValue.valueOf((double)((Double)o)) : (o instanceof Boolean ? BooleanValue.valueOf((boolean)((Boolean)o)) : (o == null ? new NullValue() : LocalObjectReference.valueOf(o, debugger)))));
        return ret;
    }
}

