/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtimperative.evaluation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainModelManager;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.pivot.ParserException;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QVTiModelManager
implements DomainModelManager {
    public static final TypedModel MIDDLE_MODEL = null;
    @NonNull
    protected final MetaModelManager metaModelManager;
    private Map<TypedModel, Resource> modelResourceMap = new HashMap<TypedModel, Resource>();
    private Map<TypedModel, EList<EObject>> modelElementsMap = new HashMap<TypedModel, EList<EObject>>();

    public QVTiModelManager(@NonNull MetaModelManager metaModelManager) {
        this.metaModelManager = metaModelManager;
    }

    public void addModel(@NonNull TypedModel typedModel, @NonNull Resource model) {
        this.modelResourceMap.put(typedModel, model);
    }

    public Resource getModel(@NonNull TypedModel typedModel) {
        return this.modelResourceMap.get(typedModel);
    }

    public Collection<Resource> getAllModelResources() {
        return this.modelResourceMap.values();
    }

    public Resource getMiddleModel() {
        return this.modelResourceMap.get(MIDDLE_MODEL);
    }

    public void addModelElement(@Nullable TypedModel model, @NonNull Object element) {
        EList<EObject> elements = null;
        if (this.modelElementsMap.containsKey(model)) {
            elements = this.modelElementsMap.get(model);
        } else {
            elements = new EList<EObject>();
            if (model != MIDDLE_MODEL) {
                elements.addAll((Collection)this.modelResourceMap.get(model).getContents());
            }
        }
        elements.add((Object)((EObject)element));
        this.modelElementsMap.put(model, elements);
    }

    public List<Object> getElementsByType(@Nullable TypedModel model, @NonNull Type type) {
        ArrayList<Object> elements = new ArrayList<Object>();
        if (this.modelElementsMap.containsKey(model)) {
            for (EObject root : this.modelElementsMap.get(model)) {
                if (root == null) continue;
                if (this.isInstance((DomainType)type, root)) {
                    elements.add(root);
                }
                TreeIterator contents = root.eAllContents();
                while (contents.hasNext()) {
                    EObject element = (EObject)contents.next();
                    if (element == null || !this.isInstance((DomainType)type, element)) continue;
                    elements.add(element);
                }
            }
        } else {
            TreeIterator contents = this.modelResourceMap.get(model).getAllContents();
            while (contents.hasNext()) {
                EObject element = (EObject)contents.next();
                if (element == null || !this.isInstance((DomainType)type, element)) continue;
                elements.add(element);
            }
        }
        return elements;
    }

    public void saveModels() {
        for (Map.Entry<TypedModel, Resource> entry : this.modelResourceMap.entrySet()) {
            Resource model = entry.getValue();
            TypedModel key = entry.getKey();
            if (key == MIDDLE_MODEL || !this.modelElementsMap.containsKey(key)) continue;
            for (EObject e : this.modelElementsMap.get(key)) {
                if (e.eContainer() != null) continue;
                model.getContents().add((Object)e);
            }
            try {
                HashMap<String, Boolean> options = new HashMap<String, Boolean>();
                options.put("SCHEMA_LOCATION", Boolean.TRUE);
                model.save(options);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void saveMiddleModel(@NonNull URI uri) {
        Resource r = this.metaModelManager.getExternalResourceSet().createResource(uri);
        for (EObject e : this.modelElementsMap.get(MIDDLE_MODEL)) {
            if (e.eContainer() != null) continue;
            r.getContents().add((Object)e);
        }
        try {
            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
            options.put("SCHEMA_LOCATION", Boolean.TRUE);
            r.save(options);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void dispose() {
        this.modelResourceMap = null;
    }

    @NonNull
    public Set<EObject> get(@NonNull DomainType type) {
        throw new UnsupportedOperationException();
    }

    protected boolean isInstance(@NonNull DomainType requiredType, @NonNull EObject eObject) {
        EClass eClass = eObject.eClass();
        EPackage ePackage = eClass.getEPackage();
        Type objectType = null;
        if (ePackage == PivotPackage.eINSTANCE) {
            String name = (String)DomainUtil.nonNullEMF((Object)eClass.getName());
            objectType = this.metaModelManager.getPivotType(name);
        } else {
            try {
                objectType = (Type)this.metaModelManager.getPivotOf(Type.class, (EObject)eClass);
            }
            catch (ParserException parserException) {
                // empty catch block
            }
        }
        return objectType != null && objectType.conformsTo((DomainStandardLibrary)this.metaModelManager, requiredType);
    }
}

