/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.QVTm2QVTs;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.AbstractPartitionFactory;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.BasicPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionedTransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.utilities.ReachabilityForest;
import org.eclipse.qvtd.pivot.qvtschedule.BasicPartition;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.MergedPartition;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.Role;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.Graphable;

public class MergedPartitionFactory
extends AbstractPartitionFactory<Region> {
    protected final @NonNull Iterable<@NonNull BasicPartitionAnalysis> subPartitionAnalyses;

    public MergedPartitionFactory(@NonNull ScheduleManager scheduleManager, @NonNull Region region, @NonNull Iterable<@NonNull BasicPartitionAnalysis> subPartitionAnalyses) {
        super(scheduleManager, region);
        this.subPartitionAnalyses = subPartitionAnalyses;
    }

    protected void addNode(@NonNull BasicPartition partition, @NonNull Node node, @NonNull Role newNodeRole) {
        assert (node.getOwningRegion() == this.region);
        Role displacedNodeRole = partition.putNodeRole(node, newNodeRole);
        assert (displacedNodeRole == null);
    }

    protected @NonNull String computeName() {
        StringBuilder s = new StringBuilder();
        s.append(String.valueOf(this.region.getName()) + "\u00ab");
        boolean isFirst = true;
        for (BasicPartitionAnalysis subPartitionAnalysis : this.subPartitionAnalyses) {
            if (!isFirst) {
                s.append(",");
            }
            String name = subPartitionAnalysis.getName();
            int iStart = name.indexOf(171);
            int iFinish = name.indexOf(187);
            if (iStart >= 0 && iStart < iFinish) {
                s.append(name.subSequence(iStart + 1, iFinish));
            } else {
                s.append(name);
            }
            isFirst = false;
        }
        s.append("\u00bb");
        return s.toString();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public @NonNull BasicPartitionAnalysis createPartitionAnalysis(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis) {
        @NonNull List headNodes = ((BasicPartition)this.subPartitionAnalyses.iterator().next().getPartition()).getHeadNodes();
        MergedPartition mergedPartition = this.createMergedPartition(this.computeName(), headNodes);
        for (BasicPartitionAnalysis subPartitionAnalysis : this.subPartitionAnalyses) {
            BasicPartition subPartition = (BasicPartition)subPartitionAnalysis.getPartition();
            PivotUtilInternal.resetContainer((EObject)subPartition);
            mergedPartition.getOwnedMergedPartitions().add(subPartition);
            mergedPartition.getExplicitPredecessors().addAll(subPartition.getExplicitPredecessors());
            mergedPartition.getExplicitSuccessors().addAll(subPartition.getExplicitSuccessors());
        }
        mergedPartition.initTypedModelAnalysis();
        return this.createPartitionAnalysis(partitionedTransformationAnalysis, mergedPartition);
    }

    protected @NonNull BasicPartitionAnalysis createPartitionAnalysis(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis, @NonNull MergedPartition mergedPartition) {
        ReachabilityForest reachabilityForest = this.createReachabilityForest();
        int partitionNumber = this.region.getNextPartitionNumber();
        String namePrefix = "\u00abmerge" + partitionNumber + "\u00bb";
        String symbolSuffix = "_p" + partitionNumber;
        BasicPartitionAnalysis basicPartitionAnalysis = new BasicPartitionAnalysis(partitionedTransformationAnalysis, (BasicPartition)mergedPartition, reachabilityForest, namePrefix, symbolSuffix);
        this.initializePartition(basicPartitionAnalysis);
        basicPartitionAnalysis.analyzePartition();
        basicPartitionAnalysis.analyzePartition2();
        if (QVTm2QVTs.DEBUG_GRAPHS.isActive()) {
            this.scheduleManager.writeDebugGraphs((Graphable)basicPartitionAnalysis.getPartition(), null);
        }
        return basicPartitionAnalysis;
    }

    @Override
    protected @NonNull Iterable<@NonNull NavigableEdge> getAvailableNavigableEdges() {
        HashSet<@NonNull NavigableEdge> oldEdges = new HashSet<NavigableEdge>();
        HashSet<@NonNull NavigableEdge> realizedEdges = new HashSet<NavigableEdge>();
        for (BasicPartitionAnalysis subPartitionAnalysis : this.subPartitionAnalyses) {
            BasicPartition partition = (BasicPartition)subPartitionAnalysis.getPartition();
            for (Edge edge : partition.getPartialEdges()) {
                if (!edge.isNavigation()) continue;
                if (subPartitionAnalysis.isRealized(edge)) {
                    realizedEdges.add((NavigableEdge)edge);
                    continue;
                }
                if (!subPartitionAnalysis.isOld(edge)) continue;
                oldEdges.add((NavigableEdge)edge);
            }
        }
        oldEdges.removeAll(realizedEdges);
        return oldEdges;
    }

    @Override
    protected @NonNull Iterable<@NonNull Node> getReachabilityRootNodes() {
        HashSet<@NonNull Node> rootNodes = new HashSet<Node>();
        for (BasicPartitionAnalysis subPartitionAnalysis : this.subPartitionAnalyses) {
            ReachabilityForest reachabilityForest = subPartitionAnalysis.getReachabilityForest();
            for (Node node : reachabilityForest.getNodes()) {
                if (reachabilityForest.getCost(node) != 0) continue;
                rootNodes.add(node);
            }
        }
        return rootNodes;
    }

    protected void initializePartition(@NonNull BasicPartitionAnalysis partitionAnalysis) {
        BasicPartition partition = (BasicPartition)partitionAnalysis.getPartition();
        String regionName = this.region.getName();
        if ("mapNavigationOrAttributeCallExp_Property_qvtr".equals(regionName)) {
            this.getClass();
        }
        HashSet<@NonNull E> mergedNodes = new HashSet();
        HashSet<@NonNull E> mergedEdges = new HashSet();
        for (BasicPartitionAnalysis subPartitionAnalysis : this.subPartitionAnalyses) {
            BasicPartition subPartition = (BasicPartition)subPartitionAnalysis.getPartition();
            Iterables.addAll(mergedNodes, (Iterable)subPartition.getPartialNodes());
            Iterables.addAll(mergedEdges, (Iterable)subPartition.getPartialEdges());
        }
        for (Node mergedNode : mergedNodes) {
            this.mergeNode(partition, mergedNode);
        }
        for (Edge edge : mergedEdges) {
            this.mergeEdge(partition, edge);
        }
    }

    protected void mergeEdge(@NonNull BasicPartition partition, @NonNull Edge edge) {
        boolean isConstant = false;
        boolean isLoaded = false;
        boolean isPredicated = false;
        boolean isRealized = false;
        boolean isSpeculated = false;
        for (BasicPartitionAnalysis subPartitionAnalysis : this.subPartitionAnalyses) {
            Role role = ((BasicPartition)subPartitionAnalysis.getPartition()).getRole(edge);
            if (role == null) continue;
            switch (role) {
                case CONSTANT: {
                    isConstant = true;
                    break;
                }
                case LOADED: {
                    isLoaded = true;
                    break;
                }
                case PREDICATED: {
                    isPredicated = true;
                    break;
                }
                case REALIZED: {
                    isRealized = true;
                    break;
                }
                case SPECULATED: {
                    isSpeculated = true;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
        if (isConstant) {
            this.addEdge(partition, edge, Role.CONSTANT);
        } else if (isLoaded) {
            this.addEdge(partition, edge, Role.LOADED);
        } else if (isRealized) {
            this.addEdge(partition, edge, Role.REALIZED);
        } else if (isSpeculated) {
            this.addEdge(partition, edge, Role.SPECULATED);
        } else if (isPredicated) {
            this.addEdge(partition, edge, Role.PREDICATED);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    protected void mergeNode(@NonNull BasicPartition partition, @NonNull Node node) {
        boolean isConstant = false;
        boolean isConstantSuccessFalse = false;
        boolean isConstantSuccessTrue = false;
        boolean isLoaded = false;
        boolean isPredicated = false;
        boolean isRealized = false;
        boolean isSpeculated = false;
        boolean isSpeculation = false;
        for (BasicPartitionAnalysis subPartitionAnalysis : this.subPartitionAnalyses) {
            Role role = ((BasicPartition)subPartitionAnalysis.getPartition()).getRole(node);
            if (role == null) continue;
            switch (role) {
                case CONSTANT: {
                    isConstant = true;
                    break;
                }
                case CONSTANT_SUCCESS_FALSE: {
                    isConstantSuccessFalse = true;
                    break;
                }
                case CONSTANT_SUCCESS_TRUE: {
                    isConstantSuccessTrue = true;
                    break;
                }
                case LOADED: {
                    isLoaded = true;
                    break;
                }
                case PREDICATED: {
                    isPredicated = true;
                    break;
                }
                case REALIZED: {
                    isRealized = true;
                    break;
                }
                case SPECULATED: {
                    isSpeculated = true;
                    break;
                }
                case SPECULATION: {
                    isSpeculation = true;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
        if (isConstant) {
            this.addNode(partition, node, Role.CONSTANT);
        } else if (isConstantSuccessFalse) {
            this.addNode(partition, node, Role.CONSTANT_SUCCESS_FALSE);
        } else if (isConstantSuccessTrue) {
            this.addNode(partition, node, Role.CONSTANT_SUCCESS_TRUE);
        } else if (isLoaded) {
            this.addNode(partition, node, Role.LOADED);
        } else if (isRealized) {
            this.addNode(partition, node, Role.REALIZED);
        } else if (isSpeculation) {
            this.addNode(partition, node, isSpeculated ? Role.REALIZED : Role.SPECULATION);
        } else if (isSpeculated) {
            this.addNode(partition, node, Role.SPECULATED);
        } else if (isPredicated) {
            this.addNode(partition, node, Role.PREDICATED);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    protected @Nullable Role resolveEdgeRole(@NonNull Role sourceNodeRole, @NonNull Edge edge, @NonNull Role targetNodeRole) {
        throw new UnsupportedOperationException();
    }

    public @NonNull String toString() {
        return String.valueOf(super.toString()) + " " + this.subPartitionAnalyses;
    }
}

