/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.xtext.qvtbase.ui.commands;

import org.apache.log4j.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ocl.xtext.base.ui.commands.ToggleNatureCommand;
import org.eclipse.osgi.util.NLS;
import org.eclipse.qvtd.xtext.qvtbase.ui.QVTdProjectHelper;
import org.eclipse.qvtd.xtext.qvtbase.ui.messages.QVTdBaseUIMessages;
import org.eclipse.ui.handlers.HandlerUtil;

public class ToggleQVTdNatureCommand
extends AbstractHandler
implements ToggleNatureCommand {
    private static final Logger log = Logger.getLogger(ToggleQVTdNatureCommand.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            for (Object element : (IStructuredSelection)selection) {
                IProject project = null;
                if (element instanceof IAdaptable) {
                    project = (IProject)((IAdaptable)element).getAdapter(IProject.class);
                }
                if (project == null) continue;
                this.toggleNature(project);
            }
        }
        return null;
    }

    public String getAddNatureDialogText(String projectName) {
        return NLS.bind((String)QVTdBaseUIMessages.QVTdNatureAddingEditorCallback_MessageDialog_Message, (Object)projectName);
    }

    public String getAddNatureDialogTitle() {
        return QVTdBaseUIMessages.QVTdNatureAddingEditorCallback_MessageDialog_Title;
    }

    public @NonNull String getAddNatureKey() {
        return "add_qvtd_nature";
    }

    public boolean hasNature(@NonNull IProject project) {
        return QVTdProjectHelper.hasNature(project);
    }

    public void toggleNature(@NonNull IProject project) {
        try {
            IProjectDescription description = project.getDescription();
            String[] natures = description.getNatureIds();
            int i = 0;
            while (i < natures.length) {
                if ("org.eclipse.qvtd.xtext.qvtbase.ui.qvtdnature".equals(natures[i])) {
                    String[] newNatures = new String[natures.length - 1];
                    System.arraycopy(natures, 0, newNatures, 0, i);
                    System.arraycopy(natures, i + 1, newNatures, i, natures.length - i - 1);
                    description.setNatureIds(newNatures);
                    project.setDescription(description, null);
                    return;
                }
                ++i;
            }
            String[] newNatures = new String[natures.length + 1];
            System.arraycopy(natures, 0, newNatures, 0, natures.length);
            newNatures[natures.length] = "org.eclipse.qvtd.xtext.qvtbase.ui.qvtdnature";
            description.setNatureIds(newNatures);
            project.setDescription(description, null);
        }
        catch (CoreException e) {
            log.error((Object)"Error toggling QVTd nature", (Throwable)e);
        }
    }
}

