/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.trace.Transformation2TracePackage;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.QVTrelationMultipleScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.QVTrelationNameGenerator;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.Relation2TraceGroup;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.utilities.TraceHelper;
import org.eclipse.qvtd.pivot.qvtrelation.RelationalTransformation;
import org.eclipse.qvtd.runtime.evaluation.AbstractTransformer;

public class RelationalTransformation2TracePackage
extends Transformation2TracePackage {
    private @Nullable EPackage traceEPackage;
    private @Nullable Class dispatchClass = null;
    private @Nullable Class executionClass = null;
    private final @NonNull Class transformationTraceClass = this.createTransformationTraceClass();

    public RelationalTransformation2TracePackage(@NonNull QVTrelationMultipleScheduleManager scheduleManager, @NonNull RelationalTransformation transformation) {
        super(scheduleManager, (Transformation)transformation);
    }

    public @NonNull Class createTransformationTraceClass() {
        Class transformationTraceClass = this.createClass(this.transformation, "Tx" + this.transformation.getName());
        for (Property contextualProperty : PivotUtil.getOwnedProperties((Class)this.transformation)) {
            if (contextualProperty.getOpposite() != null || contextualProperty.isIsDerived() || contextualProperty.isIsTransient() || contextualProperty.isIsVolatile()) continue;
            String name = PivotUtil.getName((NamedElement)contextualProperty);
            Type type = PivotUtil.getType((TypedElement)contextualProperty);
            assert (contextualProperty.getOpposite() == null);
            assert (!contextualProperty.isIsMany());
            Property contextualTraceProperty = PivotUtil.createProperty((String)name, (Type)type);
            contextualTraceProperty.setIsRequired(contextualProperty.isIsRequired());
            transformationTraceClass.getOwnedProperties().add(contextualTraceProperty);
        }
        TraceHelper traceHelper = this.scheduleManager.getTraceHelper();
        transformationTraceClass.getSuperClasses().add(traceHelper.getTransformationExecutionClass());
        return transformationTraceClass;
    }

    public @NonNull Class getDispatchClass() {
        Class dispatchClass2 = this.dispatchClass;
        if (dispatchClass2 == null) {
            TraceHelper traceHelper = this.scheduleManager.getTraceHelper();
            this.dispatchClass = dispatchClass2 = traceHelper.getDispatchClass();
        }
        return dispatchClass2;
    }

    public @NonNull Class getExecutionClass() {
        Class executionClass2 = this.executionClass;
        if (executionClass2 == null) {
            TraceHelper traceHelper = this.scheduleManager.getTraceHelper();
            this.executionClass = executionClass2 = traceHelper.getExecutionClass();
        }
        return executionClass2;
    }

    @Override
    public @NonNull QVTrelationNameGenerator getNameGenerator() {
        return (QVTrelationNameGenerator)super.getNameGenerator();
    }

    @Override
    public @NonNull Relation2TraceGroup getRule2TraceGroup(@NonNull Rule rule) {
        return (Relation2TraceGroup)super.getRule2TraceGroup(rule);
    }

    public @NonNull EPackage getTraceEPackage() {
        EPackage traceEPackage2 = this.traceEPackage;
        if (traceEPackage2 == null) {
            EnvironmentFactory environmentFactory = this.scheduleManager.getEnvironmentFactory();
            URI traceURI = AbstractTransformer.TRACE_MODEL_URI;
            Resource resource = environmentFactory.getResourceSet().getResource(traceURI, true);
            traceEPackage2 = (EPackage)resource.getContents().get(0);
            assert (traceEPackage2 != null);
            this.traceEPackage = traceEPackage2;
        }
        return traceEPackage2;
    }

    @Override
    public @NonNull Class getTransformationTraceClass() {
        return this.transformationTraceClass;
    }
}

