/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.runtime.evaluation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.qvtd.runtime.evaluation.AbstractObjectManager;
import org.eclipse.qvtd.runtime.evaluation.Execution;
import org.eclipse.qvtd.runtime.evaluation.ExecutionVisitor;
import org.eclipse.qvtd.runtime.evaluation.Invocation;
import org.eclipse.qvtd.runtime.evaluation.SlotState;
import org.eclipse.qvtd.runtime.internal.evaluation.AbstractObjectState;

public abstract class AbstractSlotState
implements SlotState {
    protected final @NonNull AbstractObjectState<?> objectState;
    protected @NonNull SlotMode mode;
    private @Nullable Object blockedInvocations = null;

    protected AbstractSlotState(@NonNull AbstractObjectState<?> objectState, @NonNull SlotMode mode) {
        this.objectState = objectState;
        this.mode = mode;
    }

    @Override
    public <R> R accept(@NonNull ExecutionVisitor<R> visitor) {
        return visitor.visitSlotState(this);
    }

    @Override
    public synchronized void block(@NonNull Invocation invocation) {
        Object blockedInvocations2 = this.blockedInvocations;
        if (blockedInvocations2 == null) {
            this.blockedInvocations = invocation;
        } else if (blockedInvocations2 instanceof Invocation) {
            ArrayList<@NonNull Invocation> blockedInvocationList = new ArrayList<Invocation>();
            blockedInvocationList.add((Invocation)blockedInvocations2);
            blockedInvocationList.add(invocation);
            this.blockedInvocations = blockedInvocationList;
        } else {
            List blockedInvocationList = (List)blockedInvocations2;
            blockedInvocationList.add(invocation);
        }
    }

    protected abstract @NonNull AbstractObjectManager<@NonNull ? extends SlotState> getObjectManager();

    @Override
    public boolean isAssigned() {
        return this.mode == SlotMode.ASSIGNED;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected synchronized void unblock() {
        Object blockedInvocations2 = this.blockedInvocations;
        if (blockedInvocations2 instanceof Invocation) {
            ((Invocation)blockedInvocations2).unblock();
        } else if (blockedInvocations2 != null) {
            @NonNull List blockedInvocationList = (List)blockedInvocations2;
            for (Invocation invocation : blockedInvocationList) {
                invocation.unblock();
            }
        }
        this.blockedInvocations = null;
    }

    public static abstract class Incremental
    extends AbstractSlotState
    implements SlotState.Incremental {
        public static final @NonNull List<@NonNull Execution.Incremental> EMPTY_EXECUTIONS_LIST = Collections.emptyList();
        public static final @NonNull List<@NonNull Invocation.Incremental> EMPTY_INVOCATIONS_LIST = Collections.emptyList();
        private Set<@NonNull Invocation.Incremental> sources = null;
        private Set<@NonNull Execution.Incremental> targets = null;

        protected Incremental(@NonNull AbstractObjectState<?> objectState, @NonNull SlotMode mode) {
            super(objectState, mode);
        }

        @Override
        public void addSourceInternal(@NonNull Invocation.Incremental invocation) {
            if (this.sources == null) {
                this.sources = new HashSet<Invocation.Incremental>();
            }
            this.sources.add(invocation);
        }

        @Override
        public void addTargetInternal(@NonNull Execution.Incremental invocation) {
            if (this.targets == null) {
                this.targets = new HashSet<Execution.Incremental>();
            }
            this.targets.add(invocation);
        }

        @Override
        public @NonNull Iterable<@NonNull Invocation.Incremental> getSources() {
            return this.sources != null ? this.sources : EMPTY_INVOCATIONS_LIST;
        }

        @Override
        public @NonNull Iterable<@NonNull Execution.Incremental> getTargets() {
            return this.targets != null ? this.targets : EMPTY_EXECUTIONS_LIST;
        }

        protected void revokeTargets() {
            for (Execution.Incremental target : this.getTargets()) {
                target.revoke();
            }
        }
    }

    public static enum SlotMode {
        ASSIGNABLE,
        ASSIGNED,
        REASSIGNABLE;

    }
}

