/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.common.project;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.m2m.internal.qvt.oml.common.project.PluginUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.Logger;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModelBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectDependencyHelper {
    private ProjectDependencyHelper() {
    }

    public static IProject[] getQvtProjectDependencies(IProject project, boolean recursive) {
        LinkedHashSet<IProject> projects = new LinkedHashSet<IProject>();
        if (ProjectDependencyHelper.isPluginProject(project)) {
            ProjectDependencyHelper.collectQvtPluginWorkspaceDependencies(project, projects, recursive);
        } else {
            ProjectDependencyHelper.collectQvtProjectWorkspaceDependencies(project, projects, recursive);
        }
        return projects.toArray(new IProject[projects.size()]);
    }

    public static boolean isPluginProject(IProject project) {
        return project.isOpen() && (project.exists((IPath)new Path("META-INF/MANIFEST.MF")) || project.exists((IPath)new Path("plugin.xml")));
    }

    public static Set<IProject> collectQvtPluginWorkspaceDependencies(IProject dependantProject, Set<IProject> pluginDependencies, boolean recursive) {
        IPluginModelBase plugin = PluginUtil.findPluginModelByProject(dependantProject);
        if (plugin != null) {
            IPluginImport[] iPluginImportArray = plugin.getPluginBase().getImports();
            int n = iPluginImportArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject projectDep;
                IPluginImport nextImport = iPluginImportArray[n2];
                String importID = nextImport.getId();
                IPluginModelBase depPlugin = PluginUtil.findPluginModelByID(importID);
                if (depPlugin != null && depPlugin.getUnderlyingResource() != null && !pluginDependencies.contains(projectDep = depPlugin.getUnderlyingResource().getProject()) && ProjectDependencyHelper.isQvtProject(projectDep)) {
                    pluginDependencies.add(depPlugin.getUnderlyingResource().getProject());
                    if (recursive) {
                        ProjectDependencyHelper.collectQvtPluginWorkspaceDependencies(dependantProject, pluginDependencies, recursive);
                    }
                }
                ++n2;
            }
        }
        return pluginDependencies;
    }

    public static boolean isQvtProject(IProject project) {
        try {
            return project.isOpen() && project.hasNature("org.eclipse.m2m.qvt.oml.project.TransformationNature");
        }
        catch (CoreException e) {
            Logger.getLogger().log(Level.SEVERE, "Failed to check project nature", e);
            return false;
        }
    }

    public static Set<IProject> collectQvtProjectWorkspaceDependencies(IProject project, Set<IProject> qvtDependencies, boolean recursive) {
        try {
            IProject[] projects = project.getReferencedProjects();
            int i = 0;
            while (i < projects.length) {
                IProject nextProject = projects[i];
                if (!nextProject.isOpen() || nextProject.hasNature("org.eclipse.m2m.qvt.oml.project.TransformationNature")) {
                    boolean wasProcessed;
                    boolean bl = wasProcessed = !qvtDependencies.add(nextProject);
                    if (recursive && !wasProcessed) {
                        ProjectDependencyHelper.collectQvtProjectWorkspaceDependencies(nextProject, qvtDependencies, recursive);
                    }
                }
                ++i;
            }
            return qvtDependencies;
        }
        catch (CoreException e) {
            Logger.getLogger().log(Logger.SEVERE, "Can't get referenced projects", e);
            return Collections.emptySet();
        }
    }
}

