/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.m2m.internal.qvt.oml.Messages;
import org.eclipse.m2m.internal.qvt.oml.QvtMessage;
import org.eclipse.m2m.internal.qvt.oml.ast.env.ModelParameterExtent;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnvFactory;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalFileEnv;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.common.io.eclipse.WorkspaceMetamodelRegistryProvider;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.compiler.QVTOCompiler;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompilerKernel;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitProxy;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolver;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolverFactory;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.EmfStandaloneMetamodelProvider;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.IMetamodelProvider;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.IMetamodelRegistryProvider;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.MetamodelRegistry;
import org.eclipse.m2m.internal.qvt.oml.evaluator.InternalEvaluator;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModelInstance;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModelParameterHelper;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtAssertionFailed;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtInterruptedExecutionException;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtRuntimeException;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtStackOverFlowError;
import org.eclipse.m2m.internal.qvt.oml.expressions.DirectionKind;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelParameter;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.expressions.OperationalTransformation;
import org.eclipse.m2m.internal.qvt.oml.library.Context;
import org.eclipse.m2m.internal.qvt.oml.library.IContext;
import org.eclipse.m2m.qvt.oml.ExecutionContext;
import org.eclipse.m2m.qvt.oml.ExecutionDiagnostic;
import org.eclipse.m2m.qvt.oml.ExecutionStackTraceElement;
import org.eclipse.m2m.qvt.oml.ModelExtent;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.EvaluationVisitor;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.osgi.util.NLS;

public final class TransformationExecutorExt {
    private URI fURI;
    private EPackage.Registry fPackageRegistry;
    private CompiledUnit fCompiledUnit;
    private QvtCompilerKernel fCompilerKernel;
    private ExecutionDiagnostic fLoadDiagnostic;
    private OperationalTransformation fTransformation;

    public TransformationExecutorExt(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("null transformation URI");
        }
        this.fURI = uri;
    }

    public TransformationExecutorExt(URI uri, EPackage.Registry metamodelRegistry) {
        this(uri);
        if (metamodelRegistry == null) {
            throw new IllegalArgumentException("null package registry");
        }
        this.fPackageRegistry = metamodelRegistry;
    }

    public OperationalTransformation getTransformation() {
        this.loadTransformation();
        return this.fTransformation;
    }

    public Diagnostic loadTransformation() {
        if (this.fLoadDiagnostic == null) {
            this.doLoad();
        }
        return this.fLoadDiagnostic;
    }

    public ExecutionDiagnostic execute(ExecutionContext executionContext, ModelExtent ... modelParameters) {
        if (executionContext == null) {
            throw new IllegalArgumentException();
        }
        this.checkLegalModelParams(modelParameters);
        this.loadTransformation();
        if (!TransformationExecutorExt.isSuccess((Diagnostic)this.fLoadDiagnostic)) {
            return this.fLoadDiagnostic;
        }
        try {
            return this.doExecute(modelParameters, TransformationExecutorExt.createInternalContext(executionContext));
        }
        catch (QvtRuntimeException e) {
            return TransformationExecutorExt.createExecutionFailure(e);
        }
    }

    private ExecutionDiagnostic doExecute(ModelExtent[] args, IContext context) {
        QvtOperationalEnvFactory factory = this.getEnvironmentFactory();
        QvtOperationalEvaluationEnv evaluationEnv = factory.createEvaluationEnvironment(context, null);
        ExecutionDiagnostic modelParamsDiagnostic = this.initArguments(evaluationEnv, this.fTransformation, args);
        if (modelParamsDiagnostic.getSeverity() != 0) {
            return modelParamsDiagnostic;
        }
        QvtOperationalFileEnv rootEnv = factory.createEnvironment(this.fCompiledUnit.getURI(), this.fCompilerKernel);
        EvaluationVisitor<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> evaluator = factory.createEvaluationVisitor(rootEnv, (EvaluationEnvironment<EClassifier, EOperation, EStructuralFeature, EClass, EObject>)evaluationEnv, null);
        assert (evaluator instanceof InternalEvaluator) : "expecting InternalEvaluator implementation";
        InternalEvaluator rawEvaluator = (InternalEvaluator)evaluator;
        rawEvaluator.execute(this.fTransformation);
        List<Object> resultArgs = evaluationEnv.getOperationArgs();
        int i = 0;
        for (Object nextResultArg : resultArgs) {
            ModelInstance modelInstance = (ModelInstance)nextResultArg;
            ModelParameterExtent extent = modelInstance.getExtent();
            List<EObject> allRootElements = extent.getContents().getAllRootElements();
            try {
                args[i++].setContents(allRootElements);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                return new ExecutionDiagnostic_(4, 140, NLS.bind((String)Messages.ReadOnlyExtentModificationError, (Object)(i - 1)));
            }
        }
        return ExecutionDiagnostic_.OK_INSTANCE;
    }

    private void doLoad() {
        this.fLoadDiagnostic = ExecutionDiagnostic_.OK_INSTANCE;
        UnitProxy unit = UnitResolverFactory.Registry.INSTANCE.getUnit(this.fURI);
        if (unit == null) {
            this.fLoadDiagnostic = new ExecutionDiagnostic_(4, 200, NLS.bind((String)Messages.UnitNotFoundError, (Object)this.fURI));
            return;
        }
        QVTOCompiler compiler = this.createCompiler(unit.getResolver());
        try {
            this.fCompiledUnit = compiler.compile(unit, null, null);
            this.fCompilerKernel = compiler.getKernel();
            this.fLoadDiagnostic = TransformationExecutorExt.createCompilationDiagnostic(this.fCompiledUnit);
        }
        catch (MdaException e) {
            this.fLoadDiagnostic = new ExecutionDiagnostic_(4, 200, NLS.bind((String)Messages.FailedToCompileUnitError, (Object)this.fURI));
            this.fLoadDiagnostic.merge(BasicDiagnostic.toDiagnostic((Throwable)e));
        }
        if (this.fCompiledUnit != null && this.fLoadDiagnostic.getSeverity() == 0) {
            ExecutionDiagnostic validForExecution;
            this.fTransformation = this.selectTransformation();
            if (this.fTransformation == null) {
                this.fLoadDiagnostic = new ExecutionDiagnostic_(4, 200, NLS.bind((String)Messages.NotTransformationInUnitError, (Object)this.fURI));
            }
            if ((validForExecution = TransformationExecutorExt.checkIsExecutable(this.fTransformation)).getSeverity() != 0) {
                this.fLoadDiagnostic = validForExecution;
            }
        }
    }

    private ExecutionDiagnostic initArguments(QvtOperationalEvaluationEnv evalEnv, OperationalTransformation transformationModel, ModelExtent[] args) {
        EList<ModelParameter> modelParameters = transformationModel.getModelParameter();
        if (modelParameters.size() != args.length) {
            return new ExecutionDiagnostic_(4, 140, NLS.bind((String)Messages.InvalidModelParameterCountError, (Object)args.length, (Object)modelParameters.size()));
        }
        ExecutionDiagnostic result = ExecutionDiagnostic_.OK_INSTANCE;
        ArrayList<ModelParameterExtent> extents = new ArrayList<ModelParameterExtent>(args.length);
        int argCount = 0;
        for (ModelParameter modelParam : modelParameters) {
            ModelExtent nextArg = args[argCount++];
            ModelParameterExtent nextExtent = modelParam.getKind() != DirectionKind.OUT ? new ModelParameterExtent(nextArg.getContents(), null, modelParam) : new ModelParameterExtent(null);
            extents.add(nextExtent);
        }
        List<ModelInstance> modelArgs = ModelParameterHelper.createModelArguments(transformationModel, extents);
        evalEnv.getOperationArgs().addAll(modelArgs);
        return result;
    }

    private static ExecutionDiagnostic checkIsExecutable(OperationalTransformation transformation) {
        EList operations = transformation.getEOperations();
        for (EOperation oper : operations) {
            if (!(oper instanceof ImperativeOperation) || !"main".equals(oper.getName())) continue;
            return ExecutionDiagnostic_.OK_INSTANCE;
        }
        return new ExecutionDiagnostic_(4, 130, NLS.bind((String)Messages.NoTransformationEntryPointError, (Object)transformation.getName()));
    }

    private OperationalTransformation selectTransformation() {
        List<Module> allModules = this.fCompiledUnit.getModules();
        for (Module module : allModules) {
            if (!(module instanceof OperationalTransformation)) continue;
            return (OperationalTransformation)module;
        }
        return null;
    }

    private QvtOperationalEnvFactory getEnvironmentFactory() {
        return new QvtOperationalEnvFactory();
    }

    private static ExecutionDiagnostic createExecutionFailure(QvtRuntimeException qvtRuntimeException) {
        int code = 0;
        int severity = 4;
        String message = qvtRuntimeException.getLocalizedMessage();
        Object[] data = null;
        if (qvtRuntimeException instanceof QvtAssertionFailed) {
            code = 100;
        } else if (qvtRuntimeException instanceof QvtInterruptedExecutionException) {
            code = 110;
            severity = 8;
        } else {
            code = 120;
            if (!(qvtRuntimeException instanceof QvtStackOverFlowError)) {
                data = new Object[]{qvtRuntimeException};
            } else {
                message = Messages.StackTraceOverFlowError;
            }
        }
        if (message == null) {
            message = NLS.bind((String)Messages.QVTRuntimeExceptionCaught, (Object)qvtRuntimeException.getClass().getName());
        }
        ExecutionDiagnostic_ diagnostic = new ExecutionDiagnostic_(severity, code, message, data);
        diagnostic.setStackTrace(qvtRuntimeException.getQvtStackTrace());
        return diagnostic;
    }

    private void checkLegalModelParams(ModelExtent[] extents) throws IllegalArgumentException {
        if (extents == null) {
            throw new IllegalArgumentException("Null model parameters");
        }
        int i = 0;
        while (i < extents.length) {
            if (extents[i] == null) {
                throw new IllegalArgumentException("Null model parameter[" + i + "]");
            }
            ++i;
        }
    }

    private static ExecutionDiagnostic createCompilationDiagnostic(CompiledUnit compiledUnit) {
        List<QvtMessage> errors = compiledUnit.getErrors();
        if (errors.isEmpty()) {
            return ExecutionDiagnostic_.OK_INSTANCE;
        }
        URI uri = compiledUnit.getURI();
        ExecutionDiagnostic_ mainDiagnostic = new ExecutionDiagnostic_(4, 130, NLS.bind((String)Messages.CompilationErrorsFoundInUnit, (Object)uri.toString()));
        for (QvtMessage message : errors) {
            mainDiagnostic.add(TransformationExecutorExt.createQVTErrorMessageDiagnostic(message, uri));
        }
        return mainDiagnostic;
    }

    private static Diagnostic createQVTErrorMessageDiagnostic(QvtMessage msg, URI uri) {
        String source = uri.toString();
        String message = msg.getMessage();
        if (msg.getLineNum() >= 0) {
            message = String.valueOf(message) + " (at:" + msg.getLineNum() + ")";
        }
        return new BasicDiagnostic(4, source, 0, message, null);
    }

    private static boolean isSuccess(Diagnostic diagnostic) {
        int severity = diagnostic.getSeverity();
        return severity == 0 || severity == 2 || severity == 1;
    }

    private static IContext createInternalContext(ExecutionContext executionContext) {
        Context ctx = new Context();
        ctx.setLog(executionContext.getLog());
        ctx.setMonitor(executionContext.getMonitor());
        for (String key : executionContext.getConfigPropertyNames()) {
            Object value = executionContext.getConfigProperty(key);
            ctx.setConfigProperty(key, value);
        }
        return ctx;
    }

    public String toString() {
        return "QVTO-Executor: " + this.fURI;
    }

    private QVTOCompiler createCompiler(UnitResolver unitResolver) {
        if (this.fPackageRegistry == null) {
            return new QVTOCompiler(unitResolver);
        }
        EPackageRegistryImpl packageRegistryImpl = new EPackageRegistryImpl(EPackage.Registry.INSTANCE);
        packageRegistryImpl.putAll((Map)this.fPackageRegistry);
        WorkspaceMetamodelRegistryProvider metamodelRegistryProvider = new WorkspaceMetamodelRegistryProvider(TransformationExecutorExt.createResourceSet((EPackage.Registry)packageRegistryImpl), packageRegistryImpl){
            IMetamodelProvider registry;
            {
                this.registry = new EmfStandaloneMetamodelProvider((EPackage.Registry)ePackageRegistryImpl);
            }

            public MetamodelRegistry getRegistry(IMetamodelRegistryProvider.IRepositoryContext context) {
                MetamodelRegistry result = super.getRegistry(context);
                if (result == MetamodelRegistry.getInstance()) {
                    result = new MetamodelRegistry(this.registry);
                }
                return result;
            }
        };
        return new QVTOCompiler(unitResolver, (IMetamodelRegistryProvider)metamodelRegistryProvider);
    }

    private static ResourceSet createResourceSet(EPackage.Registry packageRegistry) {
        ResourceSetImpl rs = new ResourceSetImpl();
        if (packageRegistry != null) {
            rs.setPackageRegistry(packageRegistry);
            HashMap<URI, Resource> uriResourceMap = new HashMap<URI, Resource>();
            for (Object nextEntry : packageRegistry.values()) {
                EPackage ePackage;
                Resource resource;
                if (!(nextEntry instanceof EPackage) || (resource = (ePackage = (EPackage)nextEntry).eResource()) == null) continue;
                uriResourceMap.put(resource.getURI(), resource);
            }
            if (!uriResourceMap.isEmpty()) {
                rs.setURIResourceMap(uriResourceMap);
            }
        }
        return rs;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExecutionDiagnostic_
    extends ExecutionDiagnostic {
        protected static final ExecutionDiagnostic OK_INSTANCE = new ExecutionDiagnostic_(0, 0, "OK", null);

        public ExecutionDiagnostic_(int severity, int code, String message, Object[] data) {
            super(severity, code, message, data);
        }

        public ExecutionDiagnostic_(int severity, int code, String message) {
            super(severity, code, message);
        }

        @Override
        protected void setStackTrace(List<? extends ExecutionStackTraceElement> stackElements) {
            super.setStackTrace(stackElements);
        }
    }
}

